/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.executors.processor;

import com.manageengine.ela.server.common.executors.processor.CommonQueueProcessor;
import com.manageengine.ela.server.common.executors.queue.ConcurrentQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;

public abstract class ConcurrentQueueProcessor<E>
extends CommonQueueProcessor<E> {
    private static final Logger LOGGER = Logger.getLogger(ConcurrentQueueProcessor.class.getName());
    protected final ReentrantLock lock = new ReentrantLock(true);
    protected final Condition isExited = this.lock.newCondition();
    protected AtomicInteger threadsPerObject = new AtomicInteger();

    public ConcurrentQueueProcessor(ConcurrentQueue<E> queue) throws IllegalArgumentException {
        super(queue);
    }

    @Override
    protected E getData() throws InterruptedException {
        return this.queue.get(!this.stopQueueIfempty.get());
    }

    @Override
    public void stop() {
        this.lock.lock();
        try {
            LOGGER.info("Stop processor hook called in ConcurrentQueueProcessor");
            super.stop();
            this.queue.releaseAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void stopIfQueueIsEmpty() {
        this.lock.lock();
        try {
            LOGGER.info("stopIfQueueIsEmpty hook called in ConcurrentQueueProcessor , current queue size :" + this.queue.size());
            super.stopIfQueueIsEmpty();
            this.queue.releaseAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void preInvoke() {
        this.lock.lock();
        try {
            LOGGER.info("Total Processors running for current Object,at start : " + this.threadsPerObject.incrementAndGet());
            super.preInvoke();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void postInvoke() {
        this.lock.lock();
        try {
            LOGGER.info("Total Processors running for current Object ,at end : " + this.threadsPerObject.decrementAndGet());
            if (this.threadsPerObject.get() == 0) {
                this.isCompleted = true;
                LOGGER.info("going to process SignalAll");
                this.isExited.signalAll();
                LOGGER.info("SignalAll sent");
            }
            super.postInvoke();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void waitForCompletion() throws InterruptedException {
        this.lock.lock();
        try {
            if (!this.isCompleted) {
                LOGGER.info("Processor is queued in wait block");
                this.isExited.await();
                LOGGER.info("Processor is dequeued from wait block");
            } else {
                LOGGER.info("Processor already completed its itearations");
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

