/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.executors.processor;

import com.manageengine.ela.server.common.executors.processor.ProcessorPoolExecutor;
import com.manageengine.ela.server.common.executors.processor.QueueProcessor;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class ProcessorPoolExecutorImpl<E>
implements ProcessorPoolExecutor {
    private final AtomicLong max_proceesors = new AtomicLong(0L);
    private final ThreadPoolExecutor threadPoolExecutor;
    private final QueueProcessor<E> processor;
    private static final Logger LOGGER = Logger.getLogger(ProcessorPoolExecutorImpl.class.getName());

    public ProcessorPoolExecutorImpl(QueueProcessor<E> processor, int maxProcessors) throws IllegalArgumentException {
        this(processor, processor.getClass().getName(), maxProcessors);
    }

    public ProcessorPoolExecutorImpl(QueueProcessor<E> processor, final String threadName, int maxProcessors) throws IllegalArgumentException {
        this.max_proceesors.set(maxProcessors);
        this.processor = Objects.requireNonNull(processor);
        this.threadPoolExecutor = new ThreadPoolExecutor(maxProcessors, maxProcessors, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue()){

            @Override
            protected void beforeExecute(Thread thread, Runnable runnable) {
                thread.setName(threadName);
                super.beforeExecute(thread, runnable);
            }
        };
    }

    @Override
    public void addProcessor() throws IllegalAccessException {
        LOGGER.info("addProcessor called from TempFileWriter currentProcessor : " + this.threadPoolExecutor.getActiveCount());
        if ((long)this.threadPoolExecutor.getActiveCount() >= this.max_proceesors.get()) {
            throw new IllegalAccessException("Unable to allocate resource, " + this.toString());
        }
        this.threadPoolExecutor.execute(this.processor);
    }

    @Override
    public long getCurrentProcessors() {
        return this.threadPoolExecutor.getActiveCount();
    }

    @Override
    public void shutdown() throws InterruptedException {
        this.waitForCompletion();
        this.threadPoolExecutor.shutdown();
    }

    @Override
    public void forceShutdown() throws InterruptedException {
        this.processor.stop();
        this.waitForCompletion();
        this.threadPoolExecutor.shutdown();
    }

    @Override
    public void waitForCompletion() throws InterruptedException {
        long time = System.currentTimeMillis();
        LOGGER.info("In WaitBlock of ProcessorPoolExecutor at time :  " + System.currentTimeMillis());
        this.processor.waitForCompletion();
        LOGGER.info("Releasing from WaitBlock of ProcessorPoolExecutor at time :  " + System.currentTimeMillis());
        LOGGER.info("Wait Time in ProcessorPoolExecutor : " + (System.currentTimeMillis() - time));
    }

    @Override
    public long getMaxProcessors() {
        return this.max_proceesors.get();
    }

    @Override
    public void setMaxProcessors(long maxProcessor) {
        if (maxProcessor > 0L) {
            this.max_proceesors.set(maxProcessor);
        }
    }

    public String toString() {
        JSONObject jon = new JSONObject();
        try {
            jon.put("CURRENT_PROCESSOR", this.threadPoolExecutor.getActiveCount());
            jon.put("MAX_PROCESSOR", this.max_proceesors.get());
        }
        catch (JSONException e) {
            LOGGER.info("Error while inserting into JSONObject");
        }
        return jon.toString();
    }
}

