/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.executors.queue;

import com.manageengine.ela.server.common.executors.queue.ConcurrentQueue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class CommonQueueImpl<E>
implements ConcurrentQueue<E> {
    protected BlockingQueue<E> queue = null;
    private boolean stopQueue = false;
    private final int default_maxsize = 1000;
    protected final ReentrantLock lock = new ReentrantLock();
    protected final Condition notEmpty = this.lock.newCondition();

    public CommonQueueImpl() {
        this.queue = new ArrayBlockingQueue(1000);
    }

    public CommonQueueImpl(int maxSize) {
        this(new ArrayBlockingQueue(maxSize));
    }

    public CommonQueueImpl(BlockingQueue<E> queue) {
        this.queue = queue;
    }

    @Override
    public boolean remove(E data) throws IllegalArgumentException {
        boolean status = true;
        if (data == null) {
            throw new IllegalArgumentException("Invalid value requested");
        }
        if (this.contains(data)) {
            status = this.queue.remove(data);
        }
        return status;
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public E get(long nanosec) throws InterruptedException {
        E data = this.queue.poll(nanosec, TimeUnit.NANOSECONDS);
        return data;
    }

    @Override
    public E get(boolean waitFlag) throws InterruptedException {
        this.lock.lock();
        E data = null;
        try {
            if (this.queue.size() == 0 && waitFlag) {
                this.notEmpty.await();
            }
            data = this.queue.poll();
        }
        finally {
            this.lock.unlock();
        }
        return data;
    }

    @Override
    public E get() throws InterruptedException {
        E data = this.queue.take();
        return data;
    }

    @Override
    public void add(E data) throws Exception {
        if (data == null) {
            throw new IllegalArgumentException("Null value not allowed");
        }
        if (this.stopQueue) {
            throw new IllegalStateException("The Queue has been locked, please unlock before add data");
        }
        this.queue.add(data);
        this.signal();
    }

    private void signal() {
        this.lock.lock();
        try {
            this.notEmpty.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void signalAll() {
        this.lock.lock();
        try {
            this.notEmpty.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void put(E data) throws Exception {
        if (data == null) {
            throw new IllegalArgumentException("Null value not allowed");
        }
        if (this.stopQueue) {
            throw new IllegalStateException("The Queue has been locked, please unlock before add data");
        }
        this.queue.put(data);
        this.signal();
    }

    @Override
    public void lock() {
        this.stopQueue = true;
    }

    @Override
    public void unlock() {
        this.stopQueue = false;
    }

    @Override
    public int getDefaultMaxSize() {
        return 1000;
    }

    @Override
    public void releaseAll() {
        this.signalAll();
    }

    @Override
    public boolean contains(E data) {
        return this.queue.contains(data);
    }
}

