/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.export;

import com.adventnet.la.Reports.ReportStatusUpdater;
import com.adventnet.la.Reports.ScheduleOptions;
import com.adventnet.la.i18n.ResourceBundleMgr;
import com.adventnet.la.util.ProductBundle;
import com.manageengine.ela.server.common.client.structure.TableUniqueIdentifier;
import java.io.File;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Random;
import net.sf.jasperreports.engine.design.JRDesignReportFont;
import org.json.JSONObject;

public class TableExportParams {
    private HashMap<String, Object> parameters = null;
    private static final String PDF_IMAGE_PATH = System.getProperty("server.home") + File.separator + "webapps" + File.separator + "event" + File.separator + "images" + File.separator + "pdf.jpg";
    public static final String EXPORT_FOLDER_PATH = System.getProperty("server.home") + File.separator + "server" + File.separator + "reports" + File.separator + "direct_export" + File.separator;
    public static final String SCHEDULE_EXPORT_FOLDER_PATH = System.getProperty("server.home") + File.separator + "server" + File.separator + "reports" + File.separator + "scheduled_export" + File.separator;
    public static final String REPORT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String REPORT_NAME_DATE_FORMAT = "yyyy_MM_dd_HH_mm_ss_SSS";
    public static final String REPORT_FOLDER_FORMAT = "yyyy_MM_dd";
    private static final Random RANDOM = new Random();

    public TableExportParams(String reportName, ReportExportFormat format, JSONObject request) {
        try {
            this.parameters = new HashMap();
            ProductBundle instance = ProductBundle.getInstance();
            Locale locale = instance.getServerBundle().getLocale();
            if (locale == null || locale.toString().length() == 0) {
                locale = new Locale("en", "US");
            }
            this.parameters.put("REPORT_LOCALE", locale);
            this.parameters.put("REPORT_NAME", reportName);
            this.parameters.put("REPORT_FORMAT", format.getExportFormat());
            this.parameters.put("TABLE_REPORT_REQUEST", request);
            this.parameters.put("PDF_IMAGE_URL", PDF_IMAGE_PATH);
            this.parameters.put("BRAND_NAME", instance.getRebrandingString("BrandName"));
            this.parameters.put("PDF_IMAGE_URL", PDF_IMAGE_PATH);
            this.parameters.put("REPORT_CONTENT_START_DATE", new SimpleDateFormat(REPORT_DATE_FORMAT).format(new Date((Long)request.get("EXPORT_START_DATE"))));
            this.parameters.put("REPORT_CONTENT_END_DATE", new SimpleDateFormat(REPORT_DATE_FORMAT).format(new Date((Long)request.get("EXPORT_END_DATE"))));
            this.parameters.put("REPORT_CONTENT_LIST", request.getString("REPORT_CONTENT_LIST"));
            this.parameters.put("I18N_REPORT_NAME", instance.getString(locale, "ela.tableexportparams.reportname"));
            this.parameters.put("I18N_GROUP_NAME", instance.getString(locale, "ela.tableexportparams.groupname"));
            this.parameters.put("I18N_REPORT_GENERATED_TIME", instance.getString(locale, "ela.tableexportparams.reportgeneratedtime"));
            this.parameters.put("I18N_CONTENT_FROM", instance.getString(locale, "ela.tableexportparams.from"));
            this.parameters.put("I18N_CONTENT_TO", instance.getString(locale, "ela.tableexportparams.to"));
            this.parameters.put("I18N_REPORT_CONTENTS_LIST", instance.getString(locale, "ela.tableexportparams.reportcontentslist"));
            this.parameters.put("I18N_OF", instance.getString(locale, "ela.tableexportparams.of"));
            this.parameters.put("JSREPORTUSERID", request.getLong("JSREPORTUSERID"));
            this.parameters.put("JREPORTFORMAT", format.getExportFormat());
            ReportStatusUpdater statusUpdater = new ReportStatusUpdater();
            LocalDateTime dateTime = LocalDateTime.now();
            ScheduleOptions opInstance = ScheduleOptions.getInstance();
            ScheduleOptions.ScheduleNotif notifOption = opInstance.getNotifOption();
            String customDir = opInstance.getCommonDir();
            String basePath = request.optBoolean("IS_SCHEDULED", false) ? ((notifOption == ScheduleOptions.ScheduleNotif.FILE || notifOption == ScheduleOptions.ScheduleNotif.MAILANDFILE) && customDir != null ? customDir : SCHEDULE_EXPORT_FOLDER_PATH) : EXPORT_FOLDER_PATH;
            StringBuilder builder = new StringBuilder(basePath).append(File.separator).append(dateTime.format(DateTimeFormatter.ofPattern(REPORT_FOLDER_FORMAT))).append(File.separator);
            new File(builder.toString()).mkdirs();
            statusUpdater.setFilePath(builder.append(String.join((CharSequence)"_", statusUpdater.skipUnsupportedChars((Object)reportName).split("\\s+"))).append("_").append(dateTime.format(DateTimeFormatter.ofPattern(REPORT_NAME_DATE_FORMAT))).append("_").append(RANDOM.nextInt(1000)).append(".").append(this.getFileType(format)).toString());
            statusUpdater.setFileType(this.getFileType(format));
            statusUpdater.setReportName((Object)reportName);
            TableUniqueIdentifier tableUniqueIdentifier = new TableUniqueIdentifier(request, ResourceBundleMgr.getInstance().getServerLocale());
            statusUpdater.setReportID((Object)tableUniqueIdentifier.getUniqueId());
            statusUpdater.setUserID(Long.valueOf(request.getLong("JSREPORTUSERID")));
            if (format == ReportExportFormat.PDF) {
                String pdfFont = null;
                String pdfEncoding = null;
                try {
                    pdfFont = ProductBundle.getInstance().getString("pdf.font");
                    pdfEncoding = ProductBundle.getInstance().getString("pdf.encoding");
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
                if (pdfFont == null) {
                    pdfFont = "Helvetica";
                    pdfEncoding = "CP1252";
                }
                JRDesignReportFont font = new JRDesignReportFont();
                font.setPdfEncoding(pdfEncoding);
                font.setPdfFontName(pdfFont);
                this.parameters.put("JFONTDEFAULT", font);
            }
            this.parameters.put("STATUSUPDATER", statusUpdater);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getFileType(ReportExportFormat format) {
        switch (format) {
            case CSV: {
                return "csv";
            }
        }
        return "pdf";
    }

    public void setReportName(String reportName) {
        this.parameters.put("REPORT_NAME", reportName);
    }

    public void setReportForamt(ReportExportFormat format) {
        this.parameters.put("REPORT_FORMAT", (Object)format);
    }

    public void setTableRequest(Object requestHandler) {
        this.parameters.put("TABLE_REPORT_REQUEST", requestHandler);
    }

    public void setPdfImagePath(String pdfImagePath) {
        this.parameters.put("PDF_IMAGE_URL", pdfImagePath);
    }

    public void setDeviceGroupName(String groupName) {
        this.parameters.put("REPORT_DEVICE_GROUP", groupName);
    }

    public void setStartDate(String startDate) {
        this.parameters.put("REPORT_CONTENT_START_DATE", startDate);
    }

    public void setEndDate(String endDate) {
        this.parameters.put("REPORT_CONTENT_END_DATE", endDate);
    }

    public void setGeneratedTime(String generatedTime) {
        this.parameters.put("REPORT_GENERTATED_TIME", generatedTime);
    }

    public void setContentList(String contentList) {
        this.parameters.put("REPORT_CONTENT_LIST", contentList);
    }

    public void setSingleRowTemplate(String singleRowTemplate) {
        this.parameters.put("SINGLE_ROW_TEMPLATE", singleRowTemplate);
    }

    public void setBrandName(String brandName) {
        this.parameters.put("BRAND_NAME", brandName);
    }

    public HashMap<String, Object> getParameters() {
        return this.parameters;
    }

    public JSONObject getRequest() {
        return (JSONObject)this.parameters.get("TABLE_REPORT_REQUEST");
    }

    public ReportStatusUpdater getStatusUpdator() {
        return (ReportStatusUpdater)this.parameters.get("STATUSUPDATER");
    }

    public void add(String key, Object value) {
        this.parameters.put(key, value);
    }

    public Object get(String key) {
        return this.parameters.get(key);
    }

    public void setDynamicallyGenerated(Boolean isDynamicallyGenerated) {
        this.parameters.put("IS_DYNAMICALLY_GENERATED", isDynamicallyGenerated);
    }

    public static enum ReportExportFormat {
        PDF,
        CSV;


        public String getExportFormat() {
            switch (this) {
                case CSV: {
                    return "CSV";
                }
            }
            return "PDF";
        }
    }
}

