/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.export.callbacks;

import com.adventnet.la.Reports.ReportsCallback;
import com.adventnet.la.Reports.ScheduleOptions;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.common.export.TableExportParams;
import com.manageengine.ela.server.common.export.notifiers.MailNotification;
import com.manageengine.ela.server.common.io.file.FileHandler;
import com.zoho.za.ela.utils.Utils;
import java.io.File;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;

public class ScheduleCallBack
implements ReportsCallback {
    private static final String ZIP_EXTENSION = "zip";
    private static final Logger LOGGER = Logger.getLogger(ScheduleCallBack.class.getName());
    private TableExportParams exportParams = null;
    private boolean isMailNotifEnabled = false;

    public ScheduleCallBack(TableExportParams params) {
        this.exportParams = params;
        this.isMailNotifEnabled = params.getRequest().optString("EMAIL_ADDRESS", null) != null && ScheduleOptions.getInstance().getNotifOption() != ScheduleOptions.ScheduleNotif.FILE;
    }

    public Object reportExportCallback(Properties args) {
        Boolean isScheduled;
        Boolean result = true;
        String format = this.exportParams.get("REPORT_FORMAT").toString();
        if (format != null && TableExportParams.ReportExportFormat.valueOf(format) == TableExportParams.ReportExportFormat.CSV) {
            String csvFilePath = this.exportParams.getStatusUpdator().getFilePath();
            String extension = FilenameUtils.getExtension((String)csvFilePath);
            String targetFile = csvFilePath.substring(0, csvFilePath.length() - extension.length()) + ZIP_EXTENSION;
            boolean exitValue = FileHandler.compressFiles(new String[]{csvFilePath}, FileHandler.CompressType.ZIP, targetFile, Utils.getExportPasswordForUser((Long)((Long)this.exportParams.get("JSREPORTUSERID"))));
            if (exitValue && !FileHandler.deleteFile(csvFilePath)) {
                LOGGER.log(Level.INFO, "Cant delete csvfile after creating zip : {0}", csvFilePath);
            } else {
                this.exportParams.getStatusUpdator().setFilePath(targetFile);
            }
        }
        if ((isScheduled = Boolean.valueOf(this.exportParams.getRequest().optBoolean("IS_SCHEDULED", false))).booleanValue()) {
            try {
                DataObject dataObject = PersistenceDBUtil.getPersistence().constructDataObject();
                Row row = new Row("ELATableExportScheduleHistory");
                row.set("EXPORT_ID", (Object)this.exportParams.getRequest().getLong("EXPORT_ID"));
                row.set("EXPORT_START_TIME", (Object)this.exportParams.getStatusUpdator().getStartedTime());
                row.set("EXPORT_END_TIME", (Object)System.currentTimeMillis());
                row.set("DOWNLOAD_PATH", (Object)this.exportParams.getStatusUpdator().getFilePath());
                dataObject.addRow(row);
                PersistenceDBUtil.getPersistence().add(dataObject);
                if (this.isMailNotifEnabled) {
                    MailNotification.sendMail(this.exportParams);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Error occurred at reportExportCallback :{0}", e);
                result = false;
            }
        }
        try {
            URL url;
            File currentFile;
            Boolean isDynamic = (Boolean)this.exportParams.get("IS_DYNAMICALLY_GENERATED");
            if (isDynamic != null && isDynamic.booleanValue() && !FileHandler.deleteFile(currentFile = new File((url = (URL)this.exportParams.get("DYNAMIC_TEMPLATE")).toURI()))) {
                LOGGER.log(Level.INFO, "Cant delete temporary jasper file {0}", currentFile);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error occurred at reportExportCallback :{0}", e);
            result = false;
        }
        return result;
    }
}

