/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.export.generators;

import com.manageengine.ela.server.common.cache.Cache;
import com.manageengine.ela.server.common.client.structure.TableUniqueIdentifier;
import com.manageengine.ela.server.common.export.utils.TableExportUtil;
import java.io.File;
import java.io.InputStream;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.VerticalAlignEnum;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MultiColumnJRXMLGenerator {
    public static final int DYNAMIC_PAGE_WIDTH = Integer.MAX_VALUE;
    public static final int PAGE_MARGIN = 40;
    private static final Cache<String, String> DYNAMIC_JRXML_CONTAINER = new Cache();
    private static final String DEFAULT_EXPORTER = "/reports/TableDynamicTemplate.jxml";
    private static final String EXPORT_FOLDER_PATH = System.getProperty("server.home") + File.separator + "server" + File.separator + "reports" + File.separator + "jasper_files" + File.separator;
    public static final String EXPORT_FOLDER_TEMP_PATH = System.getProperty("server.home") + File.separator + "server" + File.separator + "reports" + File.separator + "jasper_files" + File.separator + "temp" + File.separator;

    public static String generateJRXML(TableUniqueIdentifier identifier, String reportName, JSONArray columns) throws JRException {
        String fileName;
        if (DYNAMIC_JRXML_CONTAINER.get(identifier.getUniqueId()) != null && new File(fileName = DYNAMIC_JRXML_CONTAINER.get(identifier.getUniqueId())).exists()) {
            return fileName;
        }
        String destFile = EXPORT_FOLDER_PATH + reportName + System.currentTimeMillis() + ".jasper";
        InputStream stream = TableExportUtil.class.getResourceAsStream(DEFAULT_EXPORTER);
        JasperDesign design = JRXmlLoader.load((InputStream)stream);
        design.setPageWidth(Integer.MAX_VALUE);
        design.setColumnWidth(0x7FFFFFD7);
        MultiColumnJRXMLGenerator.setColumnTextFields(design, columns);
        new File(EXPORT_FOLDER_PATH).mkdirs();
        JasperCompileManager.compileReportToFile((JasperDesign)design, (String)destFile);
        DYNAMIC_JRXML_CONTAINER.put(identifier.getUniqueId(), destFile);
        return destFile;
    }

    public static void removeJRXMLCache(TableUniqueIdentifier identifier) {
        DYNAMIC_JRXML_CONTAINER.remove(identifier.getUniqueId());
    }

    public static void removeJRXMLCache(String identifier) {
        String cache = DYNAMIC_JRXML_CONTAINER.get(identifier);
        if (cache == null) {
            return;
        }
        File fileToBeRemoved = new File(cache);
        if (fileToBeRemoved.exists()) {
            fileToBeRemoved.delete();
        }
        DYNAMIC_JRXML_CONTAINER.remove(identifier);
    }

    private static void setColumnTextFields(JasperDesign design, JSONArray columns) {
        JRDesignBand columnHeaderBand = (JRDesignBand)design.getColumnHeader();
        JRDesignBand detailBand = (JRDesignBand)design.getDetailSection().getBands()[0];
        int length = columns.length();
        int pageWidth = design.getColumnWidth();
        int eachColmWidth = pageWidth / length;
        for (int i = 0; i < length; ++i) {
            JSONObject obj = columns.optJSONObject(i);
            if (obj == null || !obj.optBoolean("IS_EXPORTABLE", false)) continue;
            try {
                String columnName = obj.getString("DISPLAY_NAME");
                String columnFieldName = obj.getString("COLUMN_TABLENAME") + "_" + obj.getString("COLUMNNAME");
                JRDesignField columnField = new JRDesignField();
                columnField.setName(columnFieldName);
                columnField.setValueClassName(String.class.getCanonicalName());
                design.addField((JRField)columnField);
                columnHeaderBand.addElement((JRDesignElement)MultiColumnJRXMLGenerator.getTextField(columnName, false, i, eachColmWidth));
                detailBand.addElement((JRDesignElement)MultiColumnJRXMLGenerator.getTextField(columnFieldName, true, i, eachColmWidth));
                continue;
            }
            catch (JRException | JSONException exp) {
                exp.printStackTrace();
            }
        }
    }

    private static JRDesignTextField getTextField(String text, boolean isField, int index, int columnWidth) {
        JRDesignTextField textField = new JRDesignTextField();
        JRDesignExpression expression = new JRDesignExpression();
        expression.setValueClassName(String.class.getCanonicalName());
        expression.setText(isField ? "$F{" + text + "}" : "\"" + text + "\"");
        textField.setExpression((JRExpression)expression);
        textField.setX(index * columnWidth);
        textField.setY(-5);
        textField.setWidth(columnWidth);
        textField.setHeight(15);
        textField.setPrintWhenDetailOverflows(true);
        textField.setStretchWithOverflow(true);
        textField.setHorizontalAlignment(HorizontalAlignEnum.JUSTIFIED);
        textField.setVerticalAlignment(VerticalAlignEnum.MIDDLE);
        return textField;
    }
}

