/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.export.notifiers;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.ReportTask;
import com.adventnet.la.util.Mailer;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.manageengine.ela.server.common.export.TableExportParams;
import com.manageengine.ela.server.common.io.file.FileHandler;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.io.FilenameUtils;
import org.json.JSONException;

public class MailNotification {
    private static final String ZIP_EXTENSION = "zip";

    public static void sendMail(TableExportParams exportParams) {
        String emailSubject;
        String emailAddresses = exportParams.getRequest().optString("EMAIL_ADDRESS", null);
        Mailer mailer = MailNotification.getMailer(emailAddresses, emailSubject = exportParams.getRequest().optString("EMAIL_SUBJECT", null));
        if (mailer == null) {
            return;
        }
        mailer.setAutoReplyText(MailNotification.getMailBody(exportParams, false));
        String sourceFile = exportParams.getStatusUpdator().getFilePath();
        String extension = FilenameUtils.getExtension((String)sourceFile);
        if (Boolean.parseBoolean(System.getProperty("EC_pdfReport", "false")) || ZIP_EXTENSION.equalsIgnoreCase(extension)) {
            mailer.addFilesToAttach(sourceFile);
        } else {
            String targetFile = sourceFile.substring(0, sourceFile.length() - extension.length()) + ZIP_EXTENSION;
            FileHandler.compressFiles(new String[]{sourceFile}, FileHandler.CompressType.ZIP, targetFile, null);
            mailer.addFilesToAttach(targetFile);
        }
        mailer.constructMessage();
        if (!mailer.sendIt()) {
            Mailer errorMailer = MailNotification.getMailer(emailAddresses, emailSubject);
            if (errorMailer == null) {
                return;
            }
            errorMailer.setAutoReplyText(MailNotification.getMailBody(exportParams, true));
            errorMailer.constructMessage();
            errorMailer.sendIt();
        }
    }

    private static Mailer getMailer(String mailID, String subject) {
        Mailer mailer = new Mailer();
        HashMap mailSettings = ReportTask.getMailServerDetails();
        if (mailSettings == null) {
            return null;
        }
        String smtpMailHost = (String)mailSettings.get("SmtpServer");
        String smtpMailPort = (String)mailSettings.get("SmtpServerPort");
        String smtpUserName = (String)mailSettings.get("uName");
        String smtpPassword = (String)mailSettings.get("pWord");
        String smtpTls = (String)mailSettings.get("tls");
        String frmAddress = (String)mailSettings.get("fromId");
        if (smtpUserName != null && !smtpUserName.isEmpty()) {
            mailer.setUserName(smtpUserName);
        }
        if (smtpPassword != null && !smtpPassword.isEmpty()) {
            mailer.setPassword(smtpPassword);
        }
        if (smtpMailPort != null) {
            mailer.setSmtpPort(smtpMailPort);
        }
        if (smtpTls != null) {
            mailer.setTLS(smtpTls);
        }
        mailer.setMailHost(smtpMailHost);
        mailer.setFromAddress(frmAddress);
        mailer.setToAddress(mailID);
        mailer.initialize();
        mailer.setMailSubject(subject);
        return mailer;
    }

    private static String getMailBody(TableExportParams params, boolean isError) {
        ProductBundle instance = ProductBundle.getInstance();
        StringBuilder mailBody = new StringBuilder(instance.getString("ela.exportmail.body.greeting")).append("\n\n");
        mailBody.append(instance.getString("ela.exportmail.body.description")).append("\n");
        if (isError) {
            mailBody.append(instance.getString("ela.exportmail.body.error")).append("\n");
        }
        mailBody.append("[").append(params.getStatusUpdator().getFilePath().substring(params.getStatusUpdator().getFilePath().lastIndexOf(File.separator) + 1)).append("] ");
        if (isError) {
            mailBody.append(instance.getString("ela.exportmail.body.large_file")).append("\n\n");
        } else {
            mailBody.append(instance.getString("ela.exportmail.body.attched_file")).append("\n\n");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        mailBody.append(instance.getString("ela.exportmail.body.report_details")).append("\n\n");
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("ELATableExportSchedules"));
            query.addSelectColumn(Column.getColumn((String)"ELATableExportSchedules", (String)"EXPORT_ID"));
            query.addSelectColumn(Column.getColumn((String)"ELATableExportSchedules", (String)"SCHEDULE_ID"));
            query.addSelectColumn(Column.getColumn((String)"ELATableExportSchedules", (String)"SCHEDULE_DISPLAY_NAME"));
            Criteria crit = new Criteria(Column.getColumn((String)"ELATableExportSchedules", (String)"SCHEDULE_ID"), (Object)params.getRequest().getLong("SCHEDULE_ID"), 0);
            query.setCriteria(crit);
            DataObject dObj = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
            mailBody.append(instance.getString("ela.exportmail.body.report_name")).append(": ").append(dObj.getFirstValue("ELATableExportSchedules", "SCHEDULE_DISPLAY_NAME").toString()).append("\n");
        }
        catch (DataAccessException | JSONException exp) {
            exp.printStackTrace();
        }
        mailBody.append(instance.getString("ela.exportmail.body.rule_name")).append(": ").append(params.getStatusUpdator().getReportName()).append("\n");
        mailBody.append(instance.getString("ela.exportmail.body.generated_at")).append(": ").append(dateFormat.format(new Date(params.getStatusUpdator().getStartedTime()))).append("\n");
        try {
            mailBody.append(instance.getString("ela.exportmail.body.from")).append(": ").append(dateFormat.format(new Date(params.getRequest().getLong("EXPORT_START_DATE")))).append("\n");
            mailBody.append(instance.getString("ela.exportmail.body.to")).append(": ").append(dateFormat.format(new Date(params.getRequest().getLong("EXPORT_END_DATE")))).append("\n");
        }
        catch (JSONException exp) {
            exp.printStackTrace();
        }
        return mailBody.toString();
    }
}

