/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.export.utils;

import com.adventnet.la.Reports.ReportExportData;
import com.adventnet.la.Reports.ReportExportHashImpl;
import com.adventnet.la.Reports.ReportStatusUpdater;
import com.adventnet.la.Reports.ReportsCallback;
import com.adventnet.la.Reports.ReportsExQueueImpl;
import com.adventnet.la.i18n.ResourceBundleMgr;
import com.adventnet.la.util.ProductBundle;
import com.manageengine.ela.server.common.client.structure.ClientTableStructure;
import com.manageengine.ela.server.common.client.structure.TableUniqueIdentifier;
import com.manageengine.ela.server.common.export.TableExportParams;
import com.manageengine.ela.server.common.export.callbacks.ScheduleCallBack;
import com.manageengine.ela.server.common.export.generators.MultiColumnJRXMLGenerator;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.zoho.za.ela.utils.Utils;
import java.io.File;
import java.net.URL;
import java.util.Map;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRPdfExporterParameter;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TableExportUtil {
    private static final String TABLE_WRAPPER_LOCATION = "/reports/TableExportWrapper.jasper";
    public static final Long CORRELATION_REPORT = -501L;

    public static void exportToPDF(String reportName, JSONObject request) throws BaseStatusCode {
        TableExportUtil.startExportDirect(reportName, TableExportParams.ReportExportFormat.PDF, request);
    }

    public static void exportToCSV(String reportName, JSONObject request) throws BaseStatusCode {
        TableExportUtil.startExportDynamic(reportName, TableExportParams.ReportExportFormat.CSV, request);
    }

    public static JSONArray getCurrentExportProcesses(Long userID, int limit, boolean isAdmin) {
        JSONArray array = new JSONArray();
        Map reportData = ReportExportHashImpl.getInstance().getReportsData(userID, (long)limit, isAdmin);
        reportData.values().forEach(statusUpdater -> {
            try {
                JSONObject obj = new JSONObject();
                obj.put("REPORT_ID", statusUpdater.getReportSerialID());
                obj.put("REPORT_NAME", statusUpdater.getReportName());
                obj.put("REPORT_TYPE", (Object)statusUpdater.getFileType().toLowerCase());
                obj.put("TOTAL_ENTRIES", statusUpdater.getTotalEntries());
                if (statusUpdater.getStartedTime() != 0L) {
                    obj.put("EXPORTED_ENTRIES", statusUpdater.getCompletedEntries());
                    obj.put("IS_STARTED", true);
                    obj.put("TIME_REMAINING", TableExportUtil.getTimeRemaining(statusUpdater));
                    obj.put("PERCENTAGE_COMPLETED", TableExportUtil.getPercentageCompleted(statusUpdater));
                }
                if (statusUpdater.isCompleted()) {
                    obj.put("IS_COMPLETED", true);
                    obj.put("FILE_PATH", (Object)statusUpdater.getFilePath());
                }
                if (statusUpdater.isForceStop()) {
                    obj.put("FORCE_STOPPED", true);
                }
                array.put((Object)obj);
            }
            catch (JSONException exp) {
                exp.printStackTrace();
            }
        });
        return array;
    }

    public static void clearEntry(Long reportID, Long userID, boolean isAdmin) {
        ReportExportHashImpl.getInstance().remove(reportID, userID, isAdmin);
    }

    public static void cancelExport(Long reportID, Long userID, boolean isAdmin) {
        ReportStatusUpdater statusUpdater = ReportExportHashImpl.getInstance().get(reportID, userID, isAdmin);
        if (statusUpdater != null) {
            statusUpdater.setForceStop(true);
        }
    }

    public static void clearAllEntries(Long userID, boolean isAdmin) {
        ReportExportHashImpl.getInstance().removeAll(userID, isAdmin);
    }

    private static void startExportDirect(String reportName, TableExportParams.ReportExportFormat format, JSONObject request) throws BaseStatusCode {
        try {
            TableExportParams params = new TableExportParams(reportName, format, request);
            TableExportUtil.startExport(params, format);
        }
        catch (Exception exp) {
            exp.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(65535);
        }
    }

    private static void startExportDynamic(String reportName, TableExportParams.ReportExportFormat format, JSONObject request) throws BaseStatusCode {
        try {
            TableUniqueIdentifier identifier = new TableUniqueIdentifier(request, ResourceBundleMgr.getInstance().getServerLocale());
            JSONArray columns = ClientTableStructure.getColumnDefinition(identifier);
            JSONArray exportableColumns = new JSONArray();
            for (int i = 0; i < columns.length(); ++i) {
                JSONObject obj = columns.getJSONObject(i);
                if (obj == null || !obj.optBoolean("IS_EXPORTABLE", false)) continue;
                exportableColumns.put((Object)obj);
            }
            String jasperFile = MultiColumnJRXMLGenerator.generateJRXML(identifier, reportName.replaceAll("[^a-zA-Z0-9_]", ""), exportableColumns);
            File jasperCompiled = new File(jasperFile);
            new File(MultiColumnJRXMLGenerator.EXPORT_FOLDER_TEMP_PATH).mkdirs();
            File tempFile = new File(MultiColumnJRXMLGenerator.EXPORT_FOLDER_TEMP_PATH + System.nanoTime() + ".jasper");
            tempFile.deleteOnExit();
            FileUtils.copyFile((File)jasperCompiled, (File)tempFile);
            URL dynamicTemplate = tempFile.toURI().toURL();
            TableExportParams params = new TableExportParams(reportName, format, request);
            params.setDynamicallyGenerated(true);
            params.add("DYNAMIC_TEMPLATE", dynamicTemplate);
            TableExportUtil.startExport(params, format);
        }
        catch (Exception exp) {
            exp.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(65535);
        }
    }

    private static void startExport(TableExportParams params, TableExportParams.ReportExportFormat format) {
        ReportExportData exportData = TableExportUtil.getExportData(params, format);
        exportData.setCallBack((ReportsCallback)new ScheduleCallBack(params));
        ReportsExQueueImpl.getInstance().put(exportData);
        ReportExportHashImpl.getInstance().add(Long.valueOf(params.getStatusUpdator().getReportSerialID()), params.getStatusUpdator());
    }

    private static ReportExportData getExportData(TableExportParams params, TableExportParams.ReportExportFormat format) {
        URL wrapperURL = TableExportUtil.class.getResource(TABLE_WRAPPER_LOCATION);
        ReportExportData exportData = new ReportExportData();
        exportData.setJasPertemplate(wrapperURL);
        exportData.setParams(params.getParameters());
        exportData.setExporter(TableExportUtil.getExporter(format, Utils.getExportPasswordForUser((Long)((Long)params.get("JSREPORTUSERID")))));
        return exportData;
    }

    private static JRExporter getExporter(TableExportParams.ReportExportFormat format, String exportPassword) {
        JRCsvExporter exporter = null;
        switch (format) {
            case CSV: {
                exporter = new JRCsvExporter();
                String csvExport = ProductBundle.getInstance().getString("csv.encoding");
                if (csvExport == null || csvExport.trim().equals("")) {
                    csvExport = "UTF-8";
                }
                exporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)csvExport);
                break;
            }
            default: {
                exporter = new JRPdfExporter();
                exporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)"UTF-8");
                if (exportPassword == null) break;
                exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.OWNER_PASSWORD, (Object)exportPassword);
                exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.USER_PASSWORD, (Object)exportPassword);
                exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.IS_ENCRYPTED, (Object)Boolean.TRUE);
            }
        }
        return exporter;
    }

    private static long getTimeRemaining(ReportStatusUpdater statusUpdater) {
        long timeTaken = System.currentTimeMillis() - statusUpdater.getStartedTime();
        long exportedCount = statusUpdater.getCompletedEntries();
        long totalEntries = statusUpdater.getTotalEntries();
        if (exportedCount == 0L) {
            return timeTaken * (totalEntries - exportedCount);
        }
        return timeTaken / exportedCount * (totalEntries - exportedCount);
    }

    private static double getPercentageCompleted(ReportStatusUpdater statusUpdater) {
        long exportedCount = statusUpdater.getCompletedEntries();
        long totalEntries = statusUpdater.getTotalEntries();
        if (totalEntries == 0L) {
            return 100.0;
        }
        return Math.floor((double)exportedCount / (double)totalEntries * 100.0);
    }
}

