/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.export.utils;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.la.Reports.ReportExportHashImpl;
import com.adventnet.la.Reports.ReportStatusUpdater;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.util.DBUtil;
import com.manageengine.ela.server.common.config.technician.TechnicianUtil;
import com.manageengine.ela.server.common.io.file.FileHandler;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.schedule.config.CalendarScheduleImpl;
import com.manageengine.ela.server.common.schedule.config.ELABaseScheduleImpl;
import com.manageengine.ela.server.common.schedule.config.PeriodicScheduleImpl;
import com.manageengine.ela.server.common.schedule.config.ScheduleUtil;
import com.manageengine.ela.server.common.schedule.criteria.ScheduleCriteria;
import com.manageengine.ela.server.common.schedule.export.TableBaseExportSchedule;
import com.manageengine.ela.server.common.util.DateFormatUtil;
import com.manageengine.ela.server.common.util.JSONUtil;
import java.io.File;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.io.FilenameUtils;
import org.joda.time.DateTime;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TableScheduleUtil {
    public static DataObject getNewScheduleDO(JSONObject request, Long userID, Locale locale) throws BaseStatusCode {
        try {
            JSONObject additionalParamsJSON;
            if (TableScheduleUtil.isScheduleExists(request.getString("SCHEDULE_DISPLAY_NAME"))) {
                throw BaseStatusCode.getBaseStatusCode(7432);
            }
            if (request.getInt("FREQUENCY") == 0 && request.getJSONObject("TIME").getLong("SCHEDULE_AT") < System.currentTimeMillis()) {
                throw BaseStatusCode.getBaseStatusCode(12290);
            }
            request.put("SCHEDULE_NAME", (Object)("Table Schedule : " + request.getLong("TABLE_ID") + " : " + request.getString("SCHEDULE_DISPLAY_NAME")));
            JSONObject time = request.getJSONObject("TIME");
            ELABaseScheduleImpl schedule = null;
            Integer frequency = request.getInt("FREQUENCY");
            if (frequency < Frequency.WEEKLY.ordinal()) {
                schedule = TableScheduleUtil.getPeriodicSchedule(frequency, request);
            } else if (frequency <= Frequency.MONTHLY.ordinal()) {
                schedule = TableScheduleUtil.getCalendarSchedule(frequency, request);
            } else {
                throw BaseStatusCode.getBaseStatusCode(7428);
            }
            DataObject dobj = schedule.getDataObject();
            Row row = new Row("ELATableExportSchedules");
            DataAccess.generateValues((Row)row);
            row.set("SCHEDULE_ID", schedule.getScheduleId());
            row.set("SCHEDULE_DISPLAY_NAME", (Object)request.getString("SCHEDULE_DISPLAY_NAME"));
            row.set("AUTHOR", (Object)userID);
            row.set("EMAIL_ADDRESS", (Object)request.optString("EMAIL_ADDRESS", null));
            if (request.has("EMAIL_SUBJECT")) {
                row.set("EMAIL_SUBJECT", (Object)request.getString("EMAIL_SUBJECT"));
            } else {
                row.set("EMAIL_SUBJECT", (Object)ProductBundle.getInstance().getString(locale, "ela.schedule.defaultMailSubject"));
            }
            if (request.has("ADDITIONAL_PARAMS_STR") && (additionalParamsJSON = request.getJSONObject("ADDITIONAL_PARAMS_STR")).has("RUN_ON_WEEKDAYS")) {
                frequency = Frequency.DAILY.ordinal();
            }
            row.set("EXPORT_FREQUENCY", (Object)frequency);
            row.set("EXPORT_TIME_TYPE", (Object)time.getInt("TYPE"));
            row.set("HOURS", (Object)time.optInt("HOURS", -1));
            row.set("MINUTES", (Object)time.optInt("MINUTES", -1));
            dobj.addRow(row);
            Row confRow = new Row("ELAExportScheduleConfigurations");
            confRow.set("EXPORT_ID", row.get("EXPORT_ID"));
            confRow.set("TABLE_ID", (Object)request.getInt("TABLE_ID"));
            confRow.set("REQ_UNIQUE_ID", (Object)request.getString("REQ_UNIQUE_ID"));
            confRow.set("FORMAT", (Object)request.getInt("FORMAT"));
            if (request.has("ADDITIONAL_PARAMS_STR")) {
                confRow.set("ADDITIONAL_PARAMS_STR", (Object)request.get("ADDITIONAL_PARAMS_STR").toString());
            }
            if (request.has("ADDITIONAL_PARAMS_ROW")) {
                confRow.set("ADDITIONAL_PARAMS_ROW", (Object)request.get("ADDITIONAL_PARAMS_ROW").toString());
            }
            dobj.addRow(confRow);
            return dobj;
        }
        catch (DataAccessException | JSONException exp) {
            exp.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(7937);
        }
    }

    public static DataObject getUpdatedScheduleDO(JSONObject request) throws BaseStatusCode {
        try {
            Row calendarRow;
            JSONObject time = request.getJSONObject("TIME");
            Integer frequency = request.getInt("FREQUENCY");
            if (frequency == 0 && time.getLong("SCHEDULE_AT") < System.currentTimeMillis()) {
                throw BaseStatusCode.getBaseStatusCode(12290);
            }
            SelectQuery selectQuery = TableScheduleUtil.getScheduleQuery(request.getLong("EXPORT_ID"));
            selectQuery.addSelectColumn(Column.getColumn((String)"Periodic", (String)"*"));
            selectQuery.addSelectColumn(Column.getColumn((String)"Calendar", (String)"*"));
            selectQuery.addSelectColumn(Column.getColumn((String)"Task_Input", (String)"*"));
            selectQuery.addSelectColumn(Column.getColumn((String)"ELAExportScheduleConfigurations", (String)"ADDITIONAL_PARAMS_STR"));
            DataObject dobj = PersistenceDBUtil.getPersistence().get(selectQuery);
            Row row = dobj.getRow("ELATableExportSchedules");
            Row exportConfigRow = dobj.getRow("ELAExportScheduleConfigurations");
            if (frequency < Frequency.WEEKLY.ordinal() && (Integer)row.get("EXPORT_FREQUENCY") < Frequency.WEEKLY.ordinal() && !new JSONObject((String)exportConfigRow.get("ADDITIONAL_PARAMS_STR")).has("RUN_ON_WEEKDAYS")) {
                PeriodicScheduleImpl periodicSchedule = TableScheduleUtil.getPeriodicSchedule(frequency, request);
                Row periodicRow = dobj.getRow("Periodic");
                periodicRow.set("TIME_PERIOD", (Object)periodicSchedule.getTimePeriod());
                periodicRow.set("UNIT_OF_TIME", (Object)periodicSchedule.getUnitsOfTime().getCondnString());
                periodicRow.set("START_DATE", periodicSchedule.getStartDate() != null ? ELABaseScheduleImpl.DATEFORMAT.format(periodicSchedule.getStartDate()) : null);
                periodicRow.set("END_DATE", periodicSchedule.getEndDate() != null ? ELABaseScheduleImpl.DATEFORMAT.format(periodicSchedule.getEndDate()) : null);
                periodicRow.set("EXECUTE_IMMEDIATELY", (Object)periodicSchedule.isExecuteImediately());
                Row taskInput = dobj.getRow("Task_Input");
                taskInput.set("SCHEDULE_TIME", (Object)ELABaseScheduleImpl.DATEFORMAT.format(periodicSchedule.getInitialScheduleTime()));
                dobj.updateRow(periodicRow);
                dobj.updateRow(taskInput);
            } else if (frequency >= Frequency.WEEKLY.ordinal() && (Integer)row.get("EXPORT_FREQUENCY") >= Frequency.WEEKLY.ordinal() || frequency >= Frequency.WEEKLY.ordinal() && new JSONObject((String)exportConfigRow.get("ADDITIONAL_PARAMS_STR")).has("RUN_ON_WEEKDAYS")) {
                calendarRow = dobj.getRow("Calendar");
                CalendarScheduleImpl calScheduleImpl = TableScheduleUtil.getCalendarSchedule(frequency, request);
                calendarRow.set("REPEAT_FREQUENCY", (Object)calScheduleImpl.getRepeatFrequency().getFrequency());
                calendarRow.set("TIME_OF_DAY", (Object)calScheduleImpl.getTimeOfDay());
                calendarRow.set("UNIT_OF_TIME", (Object)calScheduleImpl.getUnitsOfTime().getCondnString());
                calendarRow.set("DAY_OF_WEEK", (Object)calScheduleImpl.getDayOfWeek());
                calendarRow.set("WEEK", (Object)calScheduleImpl.getWeek());
                calendarRow.set("DATE_OF_MONTH", (Object)calScheduleImpl.getDateOfMonth());
                calendarRow.set("MONTH_OF_YEAR", (Object)calScheduleImpl.getMonthOfYear());
                calendarRow.set("YEAR_OF_DECADE", (Object)calScheduleImpl.getYearOfDecade());
                calendarRow.set("USE_DATE_IN_REVERSE", (Object)calScheduleImpl.useDateInReverse());
                dobj.updateRow(calendarRow);
            } else if (frequency >= Frequency.WEEKLY.ordinal()) {
                Row periodicRow = dobj.getRow("Periodic");
                Row calendarRow2 = TableScheduleUtil.getCalendarSchedule(frequency, request).getConfigRow();
                calendarRow2.set("SCHEDULE_ID", periodicRow.get("SCHEDULE_ID"));
                dobj.deleteRow(periodicRow);
                dobj.addRow(calendarRow2);
            } else {
                calendarRow = dobj.getRow("Calendar");
                Row periodicRow = TableScheduleUtil.getPeriodicSchedule(frequency, request).getConfigRow();
                periodicRow.set("SCHEDULE_ID", calendarRow.get("SCHEDULE_ID"));
                dobj.deleteRow(calendarRow);
                dobj.addRow(periodicRow);
            }
            if (request.has("ADDITIONAL_PARAMS_STR")) {
                JSONObject additionalParamsJSON = request.getJSONObject("ADDITIONAL_PARAMS_STR");
                if (additionalParamsJSON.has("RUN_ON_WEEKDAYS")) {
                    frequency = Frequency.DAILY.ordinal();
                }
                exportConfigRow.set("ADDITIONAL_PARAMS_STR", (Object)request.getString("ADDITIONAL_PARAMS_STR"));
            }
            row.set("EMAIL_ADDRESS", (Object)request.optString("EMAIL_ADDRESS", null));
            if (request.has("EMAIL_SUBJECT")) {
                row.set("EMAIL_SUBJECT", (Object)request.getString("EMAIL_SUBJECT"));
            }
            row.set("EXPORT_FREQUENCY", (Object)frequency);
            row.set("EXPORT_TIME_TYPE", (Object)time.getInt("TYPE"));
            row.set("HOURS", (Object)time.optInt("HOURS", -1));
            row.set("MINUTES", (Object)time.optInt("MINUTES", -1));
            dobj.updateRow(row);
            row = dobj.getRow("ELAExportScheduleConfigurations");
            exportConfigRow.set("FORMAT", (Object)request.getInt("FORMAT"));
            if (request.has("ADDITIONAL_PARAMS_ROW")) {
                exportConfigRow.set("ADDITIONAL_PARAMS_ROW", (Object)request.getString("ADDITIONAL_PARAMS_ROW"));
            }
            dobj.updateRow(exportConfigRow);
            return dobj;
        }
        catch (BaseStatusCode bs) {
            throw bs;
        }
        catch (Exception exp) {
            exp.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(7938);
        }
    }

    public static void deleteExportSchedule(JSONArray exportIDarray) throws BaseStatusCode {
        if (exportIDarray.length() != 0) {
            try {
                Object row;
                Long[] exportIDs = JSONUtil.toLongArray(exportIDarray);
                SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ELATableExportSchedules"));
                query.addJoin(new Join("ELATableExportSchedules", "ELATableExportScheduleHistory", new String[]{"EXPORT_ID"}, new String[]{"EXPORT_ID"}, 1));
                query.addSelectColumn(Column.getColumn((String)"ELATableExportSchedules", (String)"EXPORT_ID"));
                query.addSelectColumn(Column.getColumn((String)"ELATableExportSchedules", (String)"SCHEDULE_ID"));
                query.addSelectColumn(Column.getColumn((String)"ELATableExportScheduleHistory", (String)"EXPORT_ID", (String)"HISTORY_EXPORT_ID"));
                query.addSelectColumn(Column.getColumn((String)"ELATableExportScheduleHistory", (String)"DOWNLOAD_PATH"));
                query.addSelectColumn(Column.getColumn((String)"ELATableExportScheduleHistory", (String)"HISTORY_ID"));
                query.setCriteria(new Criteria(Column.getColumn((String)"ELATableExportSchedules", (String)"EXPORT_ID"), (Object)exportIDs, 8));
                JSONArray scheduleIDs = new JSONArray();
                DataObject dobj = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
                HashSet<String> deletedFiles = new HashSet<String>();
                Iterator iter = dobj.getRows("ELATableExportScheduleHistory");
                while (iter.hasNext()) {
                    row = (Row)iter.next();
                    String filePath = (String)row.get("DOWNLOAD_PATH");
                    FileHandler.deleteFile(filePath);
                    deletedFiles.add(filePath);
                    File zipArchive = new File(FilenameUtils.removeExtension((String)filePath) + ".zip");
                    if (!zipArchive.exists()) continue;
                    FileHandler.deleteFile(zipArchive);
                }
                for (ReportStatusUpdater updater : ReportExportHashImpl.getInstance().getReportsData(Long.valueOf(TechnicianUtil.getDefaultAdminUserID()), Integer.MAX_VALUE, true).values()) {
                    if (!deletedFiles.contains(updater.getFilePath())) continue;
                    ReportExportHashImpl.getInstance().remove(Long.valueOf(updater.getReportSerialID()), Long.valueOf(TechnicianUtil.getDefaultAdminUserID()), true);
                }
                iter = dobj.getRows("ELATableExportSchedules");
                while (iter.hasNext()) {
                    row = (Row)iter.next();
                    scheduleIDs.put(row.get("SCHEDULE_ID"));
                }
                ScheduleUtil.deleteSchedule(scheduleIDs);
            }
            catch (DataAccessException | JSONException exp) {
                exp.printStackTrace();
                throw BaseStatusCode.getBaseStatusCode(7939);
            }
        }
    }

    public static void enableDisableSchedule(JSONArray exportIDs, boolean isEnable) throws BaseStatusCode {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"ELATableExportSchedules", (String)"EXPORT_ID"), (Object)JSONUtil.toLongArray(exportIDs), 8);
            DataObject dobj = PersistenceDBUtil.getPersistence().get("ELATableExportSchedules", criteria);
            Iterator iter = dobj.getRows("ELATableExportSchedules");
            if (iter.hasNext()) {
                JSONArray scheduleIDs = new JSONArray();
                while (iter.hasNext()) {
                    Row row = (Row)iter.next();
                    scheduleIDs.put(row.get("SCHEDULE_ID"));
                }
                ScheduleUtil.enableDisableSchedule(scheduleIDs, isEnable);
            }
        }
        catch (DataAccessException dae) {
            dae.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(7430);
        }
        catch (JSONException je) {
            je.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(7938);
        }
    }

    public static JSONObject getScheduleInfo(Long exportID) throws BaseStatusCode {
        JSONObject schedule = new JSONObject();
        try {
            SelectQuery selectQuery = TableScheduleUtil.getScheduleQuery(exportID);
            selectQuery.addSelectColumn(Column.getColumn((String)"ELAExportScheduleConfigurations", (String)"ADDITIONAL_PARAMS_STR"));
            selectQuery.addSelectColumn(Column.getColumn((String)"ELAExportScheduleConfigurations", (String)"ADDITIONAL_PARAMS_ROW"));
            selectQuery.addSelectColumn(Column.getColumn((String)"Calendar", (String)"USE_DATE_IN_REVERSE"));
            DataObject dobj = PersistenceDBUtil.getPersistence().get(selectQuery);
            Row row = dobj.getRow("ELATableExportSchedules");
            schedule.put("SCHEDULE_ID", row.get("SCHEDULE_ID"));
            schedule.put("SCHEDULE_DISPLAY_NAME", row.get("SCHEDULE_DISPLAY_NAME"));
            schedule.put("FREQUENCY", row.get("EXPORT_FREQUENCY"));
            schedule.put("EXPORT_TIME_TYPE", row.get("EXPORT_TIME_TYPE"));
            schedule.put("HOURS", row.get("HOURS"));
            schedule.put("MINUTES", row.get("MINUTES"));
            schedule.put("EMAIL_ADDRESS", row.get("EMAIL_ADDRESS"));
            schedule.put("EMAIL_SUBJECT", row.get("EMAIL_SUBJECT"));
            row = dobj.getRow("ELAExportScheduleConfigurations");
            schedule.put("FORMAT", row.get("FORMAT"));
            schedule.put("ADDITIONAL_PARAMS_STR", row.get("ADDITIONAL_PARAMS_STR"));
            schedule.put("ADDITIONAL_PARAMS_ROW", row.get("ADDITIONAL_PARAMS_ROW"));
            row = dobj.getRow("Periodic");
            if (row != null) {
                SimpleDateFormat format = DateFormatUtil.getClientDateFormat3();
                Long scheduleTime = ((Timestamp)dobj.getRow("Periodic").get("START_DATE")).getTime();
                schedule.put("SCHEDULE_AT", (Object)format.format(new Date(scheduleTime)));
            }
            if ((row = dobj.getRow("Calendar")) != null) {
                schedule.put("DAY_OF_WEEK", row.get("DAY_OF_WEEK"));
                if (((Boolean)row.get("USE_DATE_IN_REVERSE")).booleanValue()) {
                    int dateOfMonth = (Integer)row.get("DATE_OF_MONTH");
                    schedule.put("DATE_OF_MONTH", 31 - dateOfMonth);
                } else {
                    schedule.put("DATE_OF_MONTH", row.get("DATE_OF_MONTH"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(7430);
        }
        return schedule;
    }

    private static PeriodicScheduleImpl getPeriodicSchedule(Integer frequency, JSONObject request) throws JSONException {
        JSONObject time = request.getJSONObject("TIME");
        PeriodicScheduleImpl periodicSchedule = new PeriodicScheduleImpl(request.optString("SCHEDULE_NAME"), TableScheduleUtil.getScheduleClass(request.optString("SCHEDULE_CLASS", null)));
        if (frequency.intValue() == Frequency.ONCE.ordinal()) {
            Date date = new Date(time.getLong("SCHEDULE_AT"));
            periodicSchedule.setTimePeriod(100L);
            periodicSchedule.setUnitsOfTime(ELABaseScheduleImpl.UnitofTime.SECONDS);
            periodicSchedule.setInitialScheduleTime(date);
            periodicSchedule.setStartDate(date);
            periodicSchedule.setEndDate(date);
        } else {
            DateTime date = new DateTime((Object)new Date());
            date = date.withMinuteOfHour(time.getInt("MINUTES"));
            date = date.withSecondOfMinute(0).withMillisOfSecond(0);
            periodicSchedule.setUnitsOfTime(ELABaseScheduleImpl.UnitofTime.HOURS);
            if (frequency.intValue() == Frequency.HOURLY.ordinal()) {
                periodicSchedule.setTimePeriod(1L);
            } else {
                periodicSchedule.setTimePeriod(24L);
                date = date.withHourOfDay(time.getInt("HOURS"));
            }
            periodicSchedule.setInitialScheduleTime(date.toDate());
            periodicSchedule.setStartDate(date.toDate());
        }
        periodicSchedule.setSkipMissedSchedule(true);
        return periodicSchedule;
    }

    private static CalendarScheduleImpl getCalendarSchedule(Integer frequency, JSONObject request) throws JSONException {
        JSONObject time = request.getJSONObject("TIME");
        CalendarScheduleImpl calendarSchedule = new CalendarScheduleImpl(request.optString("SCHEDULE_NAME"), TableScheduleUtil.getScheduleClass(request.optString("SCHEDULE_CLASS", null)));
        if (frequency.intValue() == Frequency.WEEKLY.ordinal()) {
            calendarSchedule.setRepeatFrequency(CalendarScheduleImpl.RepeatFrequency.WEEKLY);
            calendarSchedule.setDayOfWeek(time.getInt("DAY_OF_WEEK"));
        } else {
            calendarSchedule.setRepeatFrequency(CalendarScheduleImpl.RepeatFrequency.MONTHLY);
            calendarSchedule.setDateOfMonth(time.getInt("DATE_OF_MONTH"));
        }
        Long secondsOfDay = (long)time.getInt("HOURS") * 3600L + (long)time.getInt("MINUTES") * 60L;
        calendarSchedule.setTimeOfDay(secondsOfDay);
        calendarSchedule.setUnitsOfTime(ELABaseScheduleImpl.UnitofTime.SECONDS);
        calendarSchedule.setSkipMissedSchedule(true);
        return calendarSchedule;
    }

    private static SelectQuery getScheduleQuery(Long exportID) {
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"ELATableExportSchedules"));
        selectQuery.addJoin(new Join(Table.getTable((String)"ELATableExportSchedules"), Table.getTable((String)"ELAExportScheduleConfigurations"), new String[]{"EXPORT_ID"}, new String[]{"EXPORT_ID"}, 2));
        selectQuery.addJoin(new Join(Table.getTable((String)"ELATableExportSchedules"), Table.getTable((String)"Schedule"), new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 2));
        selectQuery.addJoin(new Join(Table.getTable((String)"Schedule"), Table.getTable((String)"Calendar"), new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 1));
        selectQuery.addJoin(new Join(Table.getTable((String)"Schedule"), Table.getTable((String)"Periodic"), new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 1));
        selectQuery.addJoin(new Join(Table.getTable((String)"Schedule"), Table.getTable((String)"Task_Input"), new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 1));
        selectQuery.addSelectColumn(Column.getColumn((String)"ELATableExportSchedules", (String)"EXPORT_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ELATableExportSchedules", (String)"SCHEDULE_ID", (String)"EXPORT_SCHEDULE_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ELATableExportSchedules", (String)"SCHEDULE_DISPLAY_NAME"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ELATableExportSchedules", (String)"EXPORT_FREQUENCY"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ELATableExportSchedules", (String)"EXPORT_TIME_TYPE"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ELATableExportSchedules", (String)"AUTHOR"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ELATableExportSchedules", (String)"HOURS"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ELATableExportSchedules", (String)"MINUTES"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ELATableExportSchedules", (String)"EMAIL_ADDRESS"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ELATableExportSchedules", (String)"EMAIL_SUBJECT"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ELAExportScheduleConfigurations", (String)"CONFIG_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ELAExportScheduleConfigurations", (String)"FORMAT"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Schedule", (String)"SCHEDULE_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Schedule", (String)"SCHEDULE_NAME"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Calendar", (String)"SCHEDULE_ID", (String)"CAL_SCH_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Calendar", (String)"DAY_OF_WEEK"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Calendar", (String)"DATE_OF_MONTH"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Periodic", (String)"SCHEDULE_ID", (String)"PER_SCH_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Periodic", (String)"START_DATE"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Task_Input", (String)"INSTANCE_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Task_Input", (String)"SCHEDULE_TIME"));
        selectQuery.setCriteria(new Criteria(Column.getColumn((String)"ELATableExportSchedules", (String)"EXPORT_ID"), (Object)exportID, 0));
        return selectQuery;
    }

    private static boolean isScheduleExists(String name) {
        Criteria criteria = new Criteria(Column.getColumn((String)"ELATableExportSchedules", (String)"SCHEDULE_DISPLAY_NAME"), (Object)name, 0);
        return DBUtil.getCountInt("ELATableExportSchedules", criteria) > 0;
    }

    private static String getScheduleClass(String className) {
        if (className == null) {
            return TableBaseExportSchedule.class.getCanonicalName();
        }
        try {
            Class.forName(className);
            return className;
        }
        catch (ClassNotFoundException exp) {
            return TableBaseExportSchedule.class.getCanonicalName();
        }
    }

    public static JSONObject loadScheduleCriteria(Long exportID) throws BaseStatusCode {
        JSONObject response = new JSONObject();
        JSONArray groups = new JSONArray();
        try {
            DataObject dataObject = TableScheduleUtil.getScheduleCriteriaDO(exportID);
            Iterator iterator = dataObject.getRows("ScheduleCriteriaGroups");
            while (iterator.hasNext()) {
                JSONObject groupEntry = new JSONObject();
                Row group = (Row)iterator.next();
                Long groupID = (Long)group.get("GROUP_ID");
                Integer groupLinkType = (Integer)group.get("LINK_TO_PREV");
                Criteria criteria = new Criteria(Column.getColumn((String)"ScheduleCriteria", (String)"GROUP_ID"), (Object)groupID, 0);
                Iterator criteriaIterator = dataObject.getRows("ScheduleCriteria", criteria);
                JSONArray conditions = new JSONArray();
                while (criteriaIterator.hasNext()) {
                    Row schCriteria = (Row)criteriaIterator.next();
                    Long fieldID = (Long)schCriteria.get("FIELD_ID");
                    String fieldVal = (String)schCriteria.get("FIELD_VAL");
                    int operation = (Integer)schCriteria.get("OPERATION");
                    int linkType = (Integer)schCriteria.get("LINK_TO_PREV");
                    if (fieldVal.isEmpty()) continue;
                    JSONObject criteriaEntry = new JSONObject();
                    criteriaEntry.put("CRITERIA_STRING", (Object)fieldVal);
                    criteriaEntry.put("OPERATION", operation);
                    criteriaEntry.put("FIELD_ID", (Object)fieldID);
                    criteriaEntry.put("LINK_TO_PREV", linkType > 0 ? linkType : 0);
                    criteriaEntry.put("TYPE", 0);
                    conditions.put((Object)criteriaEntry);
                }
                if (conditions.length() <= 0) continue;
                groupEntry.put("CONDITIONS", (Object)conditions);
                groupEntry.put("LINK_TO_PREV", groupLinkType > 0 ? groupLinkType : 0);
                groups.put((Object)groupEntry);
            }
            if (groups.length() > 0) {
                response.put("GROUPS", (Object)groups);
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
        return response;
    }

    public static DataObject getScheduleCriteriaDO(Long exportID) throws DataAccessException {
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"ScheduleCriteriaGroups"));
        selectQuery.addJoin(new Join("ScheduleCriteriaGroups", "ScheduleCriteria", new String[]{"GROUP_ID"}, new String[]{"GROUP_ID"}, 1));
        selectQuery.addJoin(new Join("ScheduleCriteria", "NoSqlIndexFields", new String[]{"FIELD_ID"}, new String[]{"FIELD_ID"}, 1));
        selectQuery.addSelectColumn(Column.getColumn((String)"ScheduleCriteriaGroups", (String)"*"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ScheduleCriteria", (String)"*"));
        selectQuery.addSelectColumn(Column.getColumn((String)"NoSqlIndexFields", (String)"FIELD_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"NoSqlIndexFields", (String)"FIELD_INDEX_NAME"));
        selectQuery.setCriteria(new Criteria(Column.getColumn((String)"ScheduleCriteriaGroups", (String)"EXPORT_ID"), (Object)exportID, 0));
        selectQuery.addSortColumn(new SortColumn("ScheduleCriteriaGroups", "GROUP_ORDER", true), 0);
        selectQuery.addSortColumn(new SortColumn("ScheduleCriteria", "CRITERIA_ORDER", true), 1);
        return PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
    }

    public static void addScheduleCriteria(Long exportID, JSONObject request) throws BaseStatusCode {
        try {
            DBUtil.deleteExistingRows("ScheduleCriteriaGroups", new Criteria(Column.getColumn((String)"ScheduleCriteriaGroups", (String)"EXPORT_ID"), (Object)exportID, 0), new boolean[0]);
            DataObject dataObject = PersistenceDBUtil.getPersistence().constructDataObject();
            if (!request.has("CRITERIA")) {
                return;
            }
            JSONArray critGroups = request.getJSONObject("CRITERIA").getJSONArray("GROUPS");
            for (int groupIndex = 0; groupIndex < critGroups.length(); ++groupIndex) {
                JSONObject groupEntry = critGroups.getJSONObject(groupIndex);
                int groupLink = groupEntry.getInt("LINK_TO_PREV");
                Row group = new Row("ScheduleCriteriaGroups");
                group.set("EXPORT_ID", (Object)exportID);
                group.set("GROUP_ORDER", (Object)groupIndex);
                if (groupIndex == 0) {
                    group.set("LINK_TO_PREV", (Object)ScheduleCriteria.ScheduleCriteriaLink.EMPTY.getValue());
                } else {
                    group.set("LINK_TO_PREV", (Object)groupLink);
                }
                dataObject.addRow(group);
                JSONArray conditions = groupEntry.getJSONArray("CONDITIONS");
                for (int criteriaIndex = 0; criteriaIndex < conditions.length(); ++criteriaIndex) {
                    JSONObject criteria = conditions.getJSONObject(criteriaIndex);
                    if (!criteria.has("CRITERIA_STRING")) continue;
                    Row scheduleCriteriaRow = new Row("ScheduleCriteria");
                    scheduleCriteriaRow.set("EXPORT_ID", (Object)exportID);
                    scheduleCriteriaRow.set("GROUP_ID", group.get("GROUP_ID"));
                    scheduleCriteriaRow.set("FIELD_ID", criteria.get("FIELD_ID"));
                    scheduleCriteriaRow.set("FIELD_VAL", criteria.get("CRITERIA_STRING"));
                    scheduleCriteriaRow.set("OPERATION", criteria.get("OPERATION"));
                    if (criteriaIndex == 0) {
                        scheduleCriteriaRow.set("LINK_TO_PREV", (Object)ScheduleCriteria.ScheduleCriteriaLink.EMPTY.getValue());
                    } else {
                        scheduleCriteriaRow.set("LINK_TO_PREV", criteria.get("LINK_TO_PREV"));
                    }
                    scheduleCriteriaRow.set("CRITERIA_ORDER", (Object)criteriaIndex);
                    dataObject.addRow(scheduleCriteriaRow);
                }
            }
            PersistenceDBUtil.getPersistence().update(dataObject);
        }
        catch (Exception exp) {
            exp.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
    }

    public static enum Frequency {
        ONCE,
        HOURLY,
        DAILY,
        WEEKLY,
        MONTHLY;

    }
}

