/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.handlers.domain;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.util.DBUtil;
import com.adventnet.sa.server.util.HostDBHandler;
import com.manageengine.ads.fw.discovery.ad.domain.DomainNativeImpl;
import com.manageengine.ads.fw.domain.ADSDomainHandler;
import com.manageengine.ads.fw.jni.ADSNativeHandler;
import com.manageengine.ads.fw.util.CommonUtil;
import com.manageengine.ela.server.common.cache.ServerDetailsBean;
import com.manageengine.ela.server.common.device.util.DeviceUtil;
import com.manageengine.ela.server.common.discovery.DiscoveryHandler;
import com.manageengine.ela.server.common.discovery.DiscoveryStatusHolder;
import com.manageengine.ela.server.common.discovery.windows.domain.DomainDiscoveryListner;
import com.manageengine.ela.server.common.ember.datasource.DefaultDataSource;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.util.Credential;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DomainHandler {
    private static final Logger LOGGER = Logger.getLogger(DomainHandler.class.getName());

    public static void addDomain(String domain, ArrayList<String> dcList, String userName, String password, boolean ... flag) throws Exception {
        DomainHandler.addDomain(domain, dcList, Credential.getCredential(userName, password, domain, null), flag);
    }

    public static JSONObject addDomainForTechnicianMigration(String domain, ArrayList<String> dcList, Credential cred, boolean ... flag) throws Exception {
        JSONObject result = new JSONObject();
        Properties domainDetails = DomainHandler.findDomainDetails(domain, dcList, cred);
        if (!ADSDomainHandler.checkDomainExists((String)domain)) {
            block9: {
                DomainNativeImpl impl = new DomainNativeImpl();
                try {
                    DomainDiscoveryListner.addDCCache(domain, dcList);
                    domainDetails = impl.getDomainDetails(domainDetails);
                    if (DomainHandler.checkISValidDomainFromNative(domainDetails, domain)) {
                        ADSDomainHandler.addDomainDetails((Properties)domainDetails, (boolean[])flag);
                        break block9;
                    }
                    throw BaseStatusCode.getBaseStatusCode(6913);
                }
                catch (BaseStatusCode exp) {
                    throw exp;
                }
                catch (Exception exp) {
                    throw BaseStatusCode.getBaseStatusCode(4097, exp.getMessage(), exp.getMessage(), "");
                }
                finally {
                    DomainDiscoveryListner.clearDCCache(domain.toUpperCase());
                }
            }
            LOGGER.info("Domain successfully configured : " + domain);
        } else {
            LOGGER.info("Domain Already configured : " + domain);
        }
        JSONObject configuredDomain = ADSDomainHandler.getDomainDetails((String)domain);
        DomainHandler.reloadDomainObjects(configuredDomain, 102, false);
        DomainHandler.reloadDomainObjects(configuredDomain, 7, false);
        DeviceUtil.updateExistingDevicesForAddedDomain(configuredDomain);
        return result;
    }

    public static JSONObject addDomain(String domain, ArrayList<String> dcList, Credential cred, boolean ... flag) throws Exception {
        JSONObject result;
        block10: {
            result = new JSONObject();
            Properties domainDetails = DomainHandler.findDomainDetails(domain, dcList, cred);
            if (ADSDomainHandler.checkDomainExists((String)domain)) {
                throw BaseStatusCode.getBaseStatusCode(7681);
            }
            DomainNativeImpl impl = new DomainNativeImpl();
            try {
                DomainDiscoveryListner.addDCCache(domain, dcList);
                domainDetails = impl.getDomainDetails(domainDetails);
                if (DomainHandler.checkISValidDomainFromNative(domainDetails, domain)) {
                    ADSDomainHandler.addDomainDetails((Properties)domainDetails, (boolean[])flag);
                    ServerDetailsBean.getInstance().setDoaminDiscoveryStatus(true);
                    com.adventnet.sa.server.util.CommonUtil.updateSysConfiguration("DOAMIN_DISCOVERY_STATUS", Boolean.TRUE, true);
                    break block10;
                }
                throw BaseStatusCode.getBaseStatusCode(6913);
            }
            catch (BaseStatusCode exp) {
                throw exp;
            }
            catch (Exception exp) {
                throw BaseStatusCode.getBaseStatusCode(4097, exp.getMessage(), exp.getMessage(), "");
            }
            finally {
                DomainDiscoveryListner.clearDCCache(domain.toUpperCase());
            }
        }
        JSONObject configuredDomain = ADSDomainHandler.getDomainDetails((String)domain);
        try {
            DomainHandler.reloadDomainObjects(configuredDomain, 3, true);
            DomainHandler.reloadDomainObjects(configuredDomain, 7, true);
        }
        catch (Exception exp) {
            exp.printStackTrace();
            LOGGER.info("Unable to start device discovery");
        }
        result.put("DOMAIN_ID", configuredDomain.getLong("DOMAIN_ID"));
        result.put("STATUS", true);
        result.put("STATUS_MESSAGE", (Object)"ads.domain_confg.native.success.configured");
        HostDBHandler.synchronizeNow("Domain Add Sync", false);
        DeviceUtil.updateExistingDevicesForAddedDomain(configuredDomain);
        return result;
    }

    public static void reloadDomainObjects(Long domainID, int flag) throws BaseStatusCode {
        JSONObject domainDetails = ADSDomainHandler.getDomainDetailsFromID((Long)domainID);
        DomainHandler.reloadDomainObjects(domainDetails, flag, true);
    }

    public static void reloadDomainObjects(String domainName, int flag) throws BaseStatusCode {
        JSONObject domainDetails = ADSDomainHandler.getDomainDetails((String)domainName);
        DomainHandler.reloadDomainObjects(domainDetails, flag, true);
    }

    public static void reloadDomainObjects(JSONObject domainDetails, int flag, boolean isTHreaded) throws BaseStatusCode {
        try {
            switch (flag) {
                case 101: {
                    DiscoveryHandler.startWindowsObjectDiscovery(domainDetails, isTHreaded, true, 101, 1);
                    break;
                }
                case 3: {
                    DiscoveryHandler.startWindowsObjectDiscovery(domainDetails, isTHreaded, true, 3, 1);
                    break;
                }
                case 7: {
                    DiscoveryHandler.startWindowsObjectDiscovery(domainDetails, isTHreaded, true, 7, 1);
                    break;
                }
                case 102: {
                    DiscoveryHandler.startWindowsObjectDiscovery(domainDetails, isTHreaded, true, 102, 1);
                    break;
                }
                case 10: {
                    DiscoveryHandler.startWindowsObjectDiscovery(domainDetails, isTHreaded, true, 3, 1);
                    DiscoveryHandler.startWindowsObjectDiscovery(domainDetails, isTHreaded, true, 101, 1);
                    DiscoveryHandler.startWindowsObjectDiscovery(domainDetails, isTHreaded, true, 7, 1);
                    DiscoveryHandler.startWindowsObjectDiscovery(domainDetails, isTHreaded, true, 102, 1);
                    break;
                }
                default: {
                    throw BaseStatusCode.getBaseStatusCode(7428);
                }
            }
        }
        catch (Exception e) {
            throw BaseStatusCode.getBaseStatusCode(6913);
        }
    }

    public static void updateDomain(String domain, ArrayList<String> dcList, String userName, String password, boolean ... flag) throws BaseStatusCode {
        DomainHandler.updateDomain(domain, dcList, Credential.getCredential(userName, password, domain, null), flag);
    }

    public static void updateDomain(String domain, ArrayList<String> dcList, Credential cred, boolean ... flag) throws BaseStatusCode {
        Properties domainDetails = DomainHandler.findDomainDetails(domain, dcList, cred);
        try {
            DomainNativeImpl ins = new DomainNativeImpl();
            Properties finalizedDomain = ins.getDomainDetails(domainDetails);
            ADSDomainHandler.updateDomainDetails((Properties)finalizedDomain, (boolean[])flag);
            DomainHandler.updateSlstate(domain);
        }
        catch (Exception exp) {
            throw BaseStatusCode.getBaseStatusCode(4097, exp.getMessage(), exp.getMessage(), "");
        }
        HostDBHandler.synchronizeNow("Domain update Sync", false);
    }

    public static Properties findDomainDetails(String domain, ArrayList<String> dcList, Credential cred) {
        Properties domainDetails = new Properties();
        domainDetails.put("DOMAIN_CONTROLLER_LIST", dcList);
        domainDetails.put("DOMAIN_NAME", domain);
        if (cred.getUserName() != null && !cred.getUserName().isEmpty() && cred.getPassword() != null) {
            domainDetails.put("IS_AUTHENTICATION_REQUIRED", "true");
            domainDetails.put("USER_DISTINGUISHED_NAME", cred.getUserName());
            domainDetails.put("PASSWORD", cred.getPassword());
        } else {
            domainDetails.put("IS_AUTHENTICATION_REQUIRED", "false");
            domainDetails.put("USER_DISTINGUISHED_NAME", "");
            domainDetails.put("PASSWORD", "");
        }
        return domainDetails;
    }

    public static synchronized void updateDiscoveryStatus(DiscoveryStatusHolder status) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ELADiscoveryStatus", (String)"DISCOVERY_TYPE"), (Object)status.getDiscoveryType(), 0);
            crit = crit.and(new Criteria(Column.getColumn((String)"ELADiscoveryStatus", (String)"CATEGORY_ID"), (Object)status.getDiscoveryCategory(), 0));
            crit = status.getDomainID() != null ? crit.and(new Criteria(Column.getColumn((String)"ELADiscoveryStatus", (String)"DOMAIN_ID"), (Object)status.getDomainID(), 0)) : (status.getWorkgroupID() != null ? crit.and(new Criteria(Column.getColumn((String)"ELADiscoveryStatus", (String)"WORKGROUP_ID"), (Object)status.getWorkgroupID(), 0)) : crit.and(new Criteria(Column.getColumn((String)"ELADiscoveryStatus", (String)"DEVICE_ID"), (Object)status.getDeviceID(), 0)));
            DataObject dobj = PersistenceDBUtil.getPersistenceLite().get("ELADiscoveryStatus", crit);
            if (!dobj.isEmpty()) {
                Row row = dobj.getFirstRow("ELADiscoveryStatus");
                row.set("STATUS_MESSAGE", (Object)status.getStatusMessage());
                row.set("STATUS_FLAG", (Object)status.isInProgress());
                if (status.getStatusCode() != null) {
                    row.set("STATUS_CODE", (Object)status.getStatusCode());
                }
                dobj.updateRow(row);
            } else {
                Row row = new Row("ELADiscoveryStatus");
                row.set("DISCOVERY_TYPE", (Object)status.getDiscoveryType());
                row.set("CATEGORY_ID", (Object)status.getDiscoveryCategory());
                row.set("DOMAIN_ID", (Object)status.getDomainID());
                row.set("WORKGROUP_ID", (Object)status.getWorkgroupID());
                row.set("DEVICE_ID", (Object)status.getDeviceID());
                row.set("STATUS_MESSAGE", (Object)status.getStatusMessage());
                row.set("STATUS_FLAG", (Object)status.isInProgress());
                if (status.getStatusCode() != null) {
                    row.set("STATUS_CODE", (Object)status.getStatusCode());
                }
                dobj.addRow(row);
            }
            PersistenceDBUtil.getPersistenceLite().update(dobj);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public static JSONArray getAllDomains() throws BaseStatusCode {
        Table table = Table.getTable((String)ADSDomainHandler.tableName);
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)table.getTableName()));
        selectQuery.addSelectColumn(Column.getColumn((String)table.getTableName(), (String)"DOMAIN_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)table.getTableName(), (String)"DOMAIN_NAME"));
        selectQuery.addSelectColumn(Column.getColumn((String)table.getTableName(), (String)"DOMAIN_FLAT_NAME"));
        JSONArray domainJsonArray = new JSONArray();
        try {
            DataObject dataObject = PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
            Iterator rowIterator = dataObject.getRows(table.getTableName());
            while (rowIterator.hasNext()) {
                Row row = (Row)rowIterator.next();
                JSONObject newDomainObject = new JSONObject();
                newDomainObject.put("DOMAIN_ID", row.get("DOMAIN_ID"));
                newDomainObject.put("DOMAIN_NAME", row.get("DOMAIN_NAME"));
                newDomainObject.put("DOMAIN_FLAT_NAME", row.get("DOMAIN_FLAT_NAME"));
                domainJsonArray.put((Object)newDomainObject);
            }
        }
        catch (DataAccessException e) {
            throw BaseStatusCode.getBaseStatusCode(7430);
        }
        catch (JSONException e) {
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
        return domainJsonArray;
    }

    private static boolean areUsersPresentForDomain(Long domainID) throws JSONException {
        String domainFlatName = ADSDomainHandler.getDomainDetailsFromID((Long)domainID).getString("DOMAIN_FLAT_NAME");
        Criteria criteria = new Criteria(Column.getColumn((String)"AaaLogin", (String)"DOMAINNAME"), (Object)domainFlatName, 0);
        return DBUtil.getCountLong("AaaLogin", criteria) != 0L;
    }

    private static boolean areDevicesPresentForDomain(Long domainID) {
        Criteria criteria = new Criteria(Column.getColumn((String)"HostDetails", (String)"DOMAIN_ID"), (Object)domainID, 0);
        return DBUtil.getCountLong("HostDetails", criteria) != 0L;
    }

    public static void deleteDomain(Long domainID) throws BaseStatusCode {
        Persistence persistenceLite = PersistenceDBUtil.getPersistenceLite();
        try {
            if (!ServerDetailsBean.getInstance().isAdminServer() && DomainHandler.areDevicesPresentForDomain(domainID)) {
                throw BaseStatusCode.getBaseStatusCode(7941);
            }
            if (DomainHandler.areUsersPresentForDomain((long)domainID)) {
                throw BaseStatusCode.getBaseStatusCode(7951);
            }
            Row row = new Row(ADSDomainHandler.tableName);
            row.set("DOMAIN_ID", (Object)domainID);
            persistenceLite.delete(row);
            HostDBHandler.synchronizeNow("Domain delete Sync", false);
        }
        catch (DataAccessException e) {
            throw BaseStatusCode.getBaseStatusCode(7430);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public static String getDomainName(Long domainID) throws BaseStatusCode {
        try {
            Persistence persistenceLite = PersistenceDBUtil.getPersistenceLite();
            Criteria criteria = new Criteria(Column.getColumn((String)ADSDomainHandler.tableName, (String)"DOMAIN_ID"), (Object)domainID, 0);
            DataObject dataObject = persistenceLite.get(ADSDomainHandler.tableName, criteria);
            Row row = dataObject.getFirstRow(ADSDomainHandler.tableName);
            return row.get("DOMAIN_NAME").toString();
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Long getDomainID(String domainName) throws BaseStatusCode {
        try {
            JSONObject domainInfo = ADSDomainHandler.getDomainDetails((String)domainName);
            if (domainInfo.has("DOMAIN_ID")) {
                return domainInfo.getLong("DOMAIN_ID");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static JSONObject getDomainDiscoveryStatus(Long domainID, Locale locale) {
        JSONObject discoveryStatus = new JSONObject();
        Criteria crit = new Criteria(Column.getColumn((String)"ELADiscoveryStatus", (String)"DOMAIN_ID"), (Object)domainID, 0);
        crit = crit.and(new Criteria(Column.getColumn((String)"ELADiscoveryStatus", (String)"DISCOVERY_TYPE"), (Object)1, 0));
        try {
            DataObject dobj = PersistenceDBUtil.getPersistenceLite().get("ELADiscoveryStatus", crit);
            Iterator itr = dobj.getRows("ELADiscoveryStatus");
            while (itr.hasNext()) {
                Row row = (Row)itr.next();
                Integer category = (Integer)row.get("CATEGORY_ID");
                JSONObject result = new JSONObject();
                DomainHandler.loadDiscoveryStatusInformation(row, result, locale);
                switch (category) {
                    case 101: {
                        discoveryStatus.put("USERS", (Object)result);
                        break;
                    }
                    case 3: {
                        discoveryStatus.put("COMPUTERS", (Object)result);
                        break;
                    }
                    case 7: {
                        discoveryStatus.put("OU", (Object)result);
                        break;
                    }
                    case 102: {
                        discoveryStatus.put("GROUPS", (Object)result);
                        break;
                    }
                    case 10: {
                        discoveryStatus.put("ALL", (Object)result);
                    }
                }
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return discoveryStatus;
    }

    public static JSONObject getObjectsDiscoveryStatus(int type, int categoryId, long identity, Locale locale) {
        JSONObject result = new JSONObject();
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ELADiscoveryStatus", (String)"DISCOVERY_TYPE"), (Object)type, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)"ELADiscoveryStatus", (String)"CATEGORY_ID"), (Object)categoryId, 0));
            crit = type == 1 ? crit.and(new Criteria(Column.getColumn((String)"ELADiscoveryStatus", (String)"DOMAIN_ID"), (Object)identity, 0)) : (type == 2 ? crit.and(new Criteria(Column.getColumn((String)"ELADiscoveryStatus", (String)"WORKGROUP_ID"), (Object)identity, 0)) : crit.and(new Criteria(Column.getColumn((String)"ELADiscoveryStatus", (String)"DEVICE_ID"), (Object)identity, 0)));
            DataObject dobj = PersistenceDBUtil.getPersistenceLite().get("ELADiscoveryStatus", crit);
            if (!dobj.isEmpty()) {
                Row row = dobj.getFirstRow("ELADiscoveryStatus");
                DomainHandler.loadDiscoveryStatusInformation(row, result, locale);
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return result;
    }

    private static JSONArray loadDiscoveryStatusInformation(Row row, JSONObject discoveryStatus, Locale locale) {
        JSONArray array = new JSONArray();
        try {
            Boolean status = (Boolean)row.get("STATUS_FLAG");
            Long status_code = (Long)row.get("STATUS_CODE");
            if (!status.booleanValue()) {
                String statusMessage = (String)row.get("STATUS_MESSAGE");
                discoveryStatus.put("STATUS_FLAG", (Object)status);
                discoveryStatus.put("STATUS_CODE", (Object)status_code);
                if (statusMessage != null) {
                    discoveryStatus.put("STATUS_MESSAGE", (Object)ProductBundle.getInstance().getString(locale, statusMessage));
                }
            } else {
                BaseStatusCode basestatuscode = BaseStatusCode.getBaseStatusCode(7682);
                discoveryStatus.put("STATUS_FLAG", (Object)status);
                discoveryStatus.put("STATUS_CODE", (Object)basestatuscode.getStatusCode());
                discoveryStatus.put("STATUS_MESSAGE", (Object)basestatuscode.resolveDisplayText(locale).getDisplayText());
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return array;
    }

    public static JSONObject getDomainDetailsJSON(Long domainID) throws Exception {
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)ADSDomainHandler.tableName));
        selectQuery.addJoin(new Join(ADSDomainHandler.tableName, ADSDomainHandler.credentialsTableName, new String[]{"CREDENTIAL_ID"}, new String[]{"CREDENTIAL_ID"}, 1));
        Criteria criteria = new Criteria(Column.getColumn((String)ADSDomainHandler.tableName, (String)"DOMAIN_ID"), (Object)domainID, 0);
        selectQuery.setCriteria(criteria);
        ArrayList<Column> columnList = new ArrayList<Column>();
        columnList.add(Column.getColumn((String)ADSDomainHandler.tableName, (String)"DOMAIN_ID"));
        columnList.add(Column.getColumn((String)ADSDomainHandler.tableName, (String)"DOMAIN_NAME"));
        columnList.add(Column.getColumn((String)ADSDomainHandler.tableName, (String)"DOMAIN_FLAT_NAME"));
        columnList.add(Column.getColumn((String)ADSDomainHandler.tableName, (String)"IS_AUTHENTICATION_REQUIRED"));
        columnList.add(Column.getColumn((String)ADSDomainHandler.credentialsTableName, (String)"CREDENTIAL_ID"));
        columnList.add(Column.getColumn((String)ADSDomainHandler.credentialsTableName, (String)"USER_NAME"));
        selectQuery.addSelectColumns(columnList);
        selectQuery.addSortColumn(new SortColumn(Column.getColumn((String)ADSDomainHandler.tableName, (String)"DOMAIN_ID"), true));
        LinkedList<HashMap<Column, Object>> result = DefaultDataSource.getRows((SelectQuery)selectQuery, 0, 1);
        JSONObject domainDetails = new JSONObject();
        if (result.size() > 0) {
            HashMap<Column, Object> hashMap = result.getFirst();
            Set<Column> keySet = hashMap.keySet();
            for (Column column : keySet) {
                domainDetails.put(column.getColumnName(), hashMap.get(column));
            }
        } else {
            throw BaseStatusCode.getBaseStatusCode(7940);
        }
        domainDetails.put("DOMAIN_CONTROLLER_LIST", (Object)DomainHandler.getDCList(domainID));
        return domainDetails;
    }

    public static JSONArray getDCList(Long domainID) {
        JSONArray dcList = new JSONArray();
        try {
            ProductBundle bundle = ProductBundle.getInstance();
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)ADSDomainHandler.tableDCName));
            sq.addSelectColumn(Column.getColumn(null, (String)"*"));
            sq.setCriteria(new Criteria(Column.getColumn((String)ADSDomainHandler.tableDCName, (String)"DOMAIN_ID"), (Object)domainID, 0));
            sq.addSortColumn(new SortColumn(Column.getColumn((String)ADSDomainHandler.tableDCName, (String)"PRIORITY_ID"), true));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
            Iterator iterator = dataObject.getRows(ADSDomainHandler.tableDCName);
            while (iterator.hasNext()) {
                JSONObject dcDetails = new JSONObject();
                Row row = (Row)iterator.next();
                dcDetails.put("PRIORITY_ID", row.get("PRIORITY_ID"));
                dcDetails.put("DOMAIN_CONTROLLER_NAME", row.get("DOMAIN_CONTROLLER_NAME"));
                String message = (String)row.get("MESSAGE");
                if (message != null) {
                    message = bundle.getString(message);
                }
                dcDetails.put("MESSAGE", (Object)message);
                dcList.put((Object)dcDetails);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, e.getMessage());
        }
        return dcList;
    }

    public static JSONArray getDiscoveredDCList(String domainName) {
        JSONArray dcList = new JSONArray();
        try {
            ArrayList list = ADSNativeHandler.GetDCName((String)domainName);
            if (list != null && list.size() > 0) {
                for (Object domainController : list) {
                    if (domainController == null) continue;
                    if (domainController instanceof Properties) {
                        Properties dcName = (Properties)domainController;
                        if (dcName.containsKey("NAME")) {
                            dcList.put(dcName.get("NAME"));
                            continue;
                        }
                        if (!dcName.containsKey("DNSNAME")) continue;
                        dcList.put(dcName.get("DNSNAME"));
                        continue;
                    }
                    if (domainController.toString().trim().isEmpty()) continue;
                    dcList.put(domainController);
                }
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return dcList;
    }

    public static void updateSlstate(String domainName) {
        try {
            DomainHandler.updateSlstate(DomainHandler.getDomainID(domainName));
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public static void updateSlstate(long domainId) throws Exception {
        Criteria domainCriteria = new Criteria(Column.getColumn((String)"HostDetails", (String)"DOMAIN_ID"), (Object)domainId, 0);
        DeviceUtil.handleSLUpdateForUpdateDevice(domainCriteria);
    }

    public static boolean checkISValidDomainFromNative(Properties prop, String domainName) {
        List<String> domainList = DomainHandler.collectDCListFromNativeProperties(prop, domainName);
        return DomainHandler.checkISValidDomainFromNative(prop, domainList);
    }

    public static boolean checkISValidDomainFromNative(Properties prop, List<String> domainList) {
        return domainList != null && domainList.size() > 0 && prop.containsKey("DEFAULT_NAMING_CONTEXT");
    }

    public static List<String> collectDCListFromNativeProperties(Properties prop, String domainName) {
        ArrayList<String> domainControllerList;
        block5: {
            domainControllerList = new ArrayList<String>();
            try {
                try {
                    ArrayList dcList = (ArrayList)prop.get("DOMAIN_CONTROLLER_LIST");
                    if (dcList.get(0) instanceof Properties) {
                        DomainHandler.collectDCNamesFromProp(dcList, domainControllerList);
                        break block5;
                    }
                    DomainHandler.collectDCNames(dcList, domainControllerList);
                }
                catch (Exception e) {
                    List dcList = (List)prop.get("DOMAIN_CONTROLLER_LIST");
                    DomainHandler.collectDCNames(dcList, domainControllerList);
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        }
        return domainControllerList;
    }

    private static void collectDCNamesFromProp(List<?> dcData, List<String> domainControllerList) {
        for (int index = 0; index < dcData.size(); ++index) {
            Properties prop = (Properties)dcData.get(index);
            domainControllerList.add(prop.getProperty("DOMAIN_CONTROLLER_NAME"));
        }
    }

    private static void collectDCNames(List<?> dcData, List<String> domainControllerList) {
        for (int index = 0; index < dcData.size(); ++index) {
            Object dcName = dcData.get(index);
            if (dcName == null) continue;
            domainControllerList.add(dcName.toString());
        }
    }
}

