/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.handlers.workgroup;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.util.DBUtil;
import com.manageengine.ads.fw.domain.ADSDomainHandler;
import com.manageengine.ads.fw.util.CommonUtil;
import com.manageengine.ela.server.common.device.util.DeviceUtil;
import com.manageengine.ela.server.common.discovery.DiscoveryHandler;
import com.manageengine.ela.server.common.ember.datasource.DefaultDataSource;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WorkgroupHandler {
    private static final Logger LOGGER = Logger.getLogger(WorkgroupHandler.class.getName());

    public static void updateWorkgroup(Properties properties) throws BaseStatusCode {
        try {
            String workgroupName = properties.getProperty("WORKGROUP_NAME");
            String username = properties.getProperty("USERNAME");
            String password = properties.getProperty("PASSWORD");
            Boolean authenticationRequired = Boolean.parseBoolean(properties.getProperty("IS_AUTH_REQUIRED"));
            Row row = new Row("ELAWorkgroupConfiguration");
            row.set("WORKGROUP_NAME", (Object)workgroupName);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ELAWorkgroupConfiguration", row);
            if (dataObject.isEmpty()) {
                throw BaseStatusCode.getBaseStatusCode(7431);
            }
            UpdateQueryImpl updateQuery = new UpdateQueryImpl("ELAWorkgroupConfiguration");
            updateQuery.setCriteria(new Criteria(Column.getColumn((String)"ELAWorkgroupConfiguration", (String)"WORKGROUP_NAME"), (Object)workgroupName, 0));
            updateQuery.setUpdateColumn("IS_AUTHENTICATION_REQUIRED", (Object)authenticationRequired);
            if (authenticationRequired.booleanValue()) {
                Long credentialId = ADSDomainHandler.getCredentialId((String)username, (String)password, (String)workgroupName);
                updateQuery.setUpdateColumn("CREDENTIAL_ID", (Object)credentialId);
            }
            CommonUtil.getPersistenceLite().update((UpdateQuery)updateQuery);
            WorkgroupHandler.updateSlstate(workgroupName);
        }
        catch (DataAccessException e) {
            throw BaseStatusCode.getBaseStatusCode(7431);
        }
    }

    public static Long getWorkgroupID(String workgroupName) throws Exception {
        Criteria crit = new Criteria(Column.getColumn((String)"ELAWorkgroupConfiguration", (String)"WORKGROUP_NAME"), (Object)workgroupName, 0);
        DataObject dobj = PersistenceDBUtil.getPersistence().get("ELAWorkgroupConfiguration", crit);
        if (dobj.isEmpty()) {
            LOGGER.info("Unknown Workgroup  : " + workgroupName);
            return null;
        }
        return (Long)dobj.getFirstValue("ELAWorkgroupConfiguration", "WORKGROUP_ID");
    }

    public static void deleteWorkgroup(Integer workgroupId) throws BaseStatusCode {
        Persistence persistenceLite = PersistenceDBUtil.getPersistenceLite();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"HostDetails", (String)"WORKGROUP_ID"), (Object)workgroupId, 0);
            DataObject dataObject = persistenceLite.get("HostDetails", criteria);
            if (!dataObject.isEmpty()) {
                throw BaseStatusCode.getBaseStatusCode(7941);
            }
            Row row = new Row("ELAWorkgroupConfiguration");
            row.set("WORKGROUP_ID", (Object)workgroupId);
            persistenceLite.delete(row);
        }
        catch (DataAccessException e) {
            throw BaseStatusCode.getBaseStatusCode(7430);
        }
    }

    public static JSONObject getWorkgroupDetails(Long workgroupId) throws Exception {
        Criteria criteria = new Criteria(Column.getColumn((String)"ELAWorkgroupConfiguration", (String)"WORKGROUP_ID"), (Object)workgroupId, 0);
        return WorkgroupHandler.getWorkgroupDetails(criteria);
    }

    public static JSONObject getWorkgroupDetails(String workgroupName) throws Exception {
        Criteria criteria = new Criteria(Column.getColumn((String)"ELAWorkgroupConfiguration", (String)"WORKGROUP_NAME"), (Object)workgroupName, 0);
        return WorkgroupHandler.getWorkgroupDetails(criteria);
    }

    private static JSONObject getWorkgroupDetails(Criteria criteria) throws Exception {
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"ELAWorkgroupConfiguration"));
        selectQuery.addJoin(new Join("ELAWorkgroupConfiguration", ADSDomainHandler.credentialsTableName, new String[]{"CREDENTIAL_ID"}, new String[]{"CREDENTIAL_ID"}, 1));
        selectQuery.setCriteria(criteria);
        ArrayList<Column> columnList = new ArrayList<Column>();
        columnList.add(Column.getColumn((String)"ELAWorkgroupConfiguration", (String)"WORKGROUP_ID"));
        columnList.add(Column.getColumn((String)"ELAWorkgroupConfiguration", (String)"WORKGROUP_NAME"));
        columnList.add(Column.getColumn((String)"ELAWorkgroupConfiguration", (String)"IS_AUTHENTICATION_REQUIRED"));
        columnList.add(Column.getColumn((String)ADSDomainHandler.credentialsTableName, (String)"CREDENTIAL_ID"));
        columnList.add(Column.getColumn((String)ADSDomainHandler.credentialsTableName, (String)"USER_NAME"));
        selectQuery.addSelectColumns(columnList);
        selectQuery.addSortColumn(new SortColumn(Column.getColumn((String)"ELAWorkgroupConfiguration", (String)"WORKGROUP_ID"), true));
        LinkedList<HashMap<Column, Object>> result = DefaultDataSource.getRows((SelectQuery)selectQuery, 0, 1);
        JSONObject workGroupDetails = new JSONObject();
        if (result.size() > 0) {
            HashMap<Column, Object> hashMap = result.getFirst();
            Set<Column> keySet = hashMap.keySet();
            for (Column column : keySet) {
                workGroupDetails.put(column.getColumnName(), hashMap.get(column));
            }
        } else {
            throw BaseStatusCode.getBaseStatusCode(7940);
        }
        return workGroupDetails;
    }

    public static boolean reloadWorkgroupDetails() throws BaseStatusCode {
        try {
            DiscoveryHandler.startWorkGroupDiscovery(true);
            return true;
        }
        catch (Exception e) {
            throw BaseStatusCode.getBaseStatusCode(7938);
        }
    }

    public static boolean reloadWorkgroupDevices(Long workgroupId) throws BaseStatusCode {
        try {
            DiscoveryHandler.startWindowsObjectDiscovery(WorkgroupHandler.getWorkgroupDetails(workgroupId).get("WORKGROUP_NAME").toString(), true, true, 8, 2);
            return true;
        }
        catch (Exception e) {
            throw BaseStatusCode.getBaseStatusCode(7938);
        }
    }

    public static JSONObject getWorkGroupDetailsJSON(String workgroup) {
        JSONObject workgrpDetails = new JSONObject();
        Criteria criteria = new Criteria(Column.getColumn((String)"ELAWorkgroupConfiguration", (String)"WORKGROUP_NAME"), (Object)workgroup, 0);
        try {
            DataObject dobj = PersistenceDBUtil.getPersistenceLite().get("ELAWorkgroupConfiguration", criteria);
            if (!dobj.isEmpty() && dobj.containsTable("ELAWorkgroupConfiguration")) {
                Row row = dobj.getFirstRow("ELAWorkgroupConfiguration");
                if (row.get("WORKGROUP_ID") != null) {
                    workgrpDetails.put("WORKGROUP_ID", (Object)row.get("WORKGROUP_ID").toString());
                }
                if (row.get("WORKGROUP_NAME") != null) {
                    workgrpDetails.put("WORKGROUP_NAME", (Object)row.get("WORKGROUP_NAME").toString());
                }
                if (row.get("WORKGROUP_PATH") != null) {
                    workgrpDetails.put("WORKGROUP_PATH", (Object)row.get("WORKGROUP_PATH").toString());
                }
                if (row.get("IS_AUTHENTICATION_REQUIRED") != null) {
                    workgrpDetails.put("IS_AUTHENTICATION_REQUIRED", (Object)row.get("IS_AUTHENTICATION_REQUIRED").toString());
                }
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return workgrpDetails;
    }

    public static JSONObject getWorkGroupDetails(Long workgroup) {
        JSONObject workgroupDetails = new JSONObject();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"ELAWorkgroupConfiguration", (String)"WORKGROUP_NAME"), (Object)workgroup, 0);
            DataObject dobj = PersistenceDBUtil.getPersistenceLite().get("ELAWorkgroupConfiguration", criteria);
            Row row = dobj.getFirstRow("ELAWorkgroupConfiguration");
            if (row != null) {
                return row.getAsJSON();
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return workgroupDetails;
    }

    public static Properties getWorkGroupDetails(String workgroup) {
        Properties workgrpDetails = new Properties();
        Criteria criteria = new Criteria(Column.getColumn((String)"ELAWorkgroupConfiguration", (String)"WORKGROUP_NAME"), (Object)workgroup, 0);
        try {
            DataObject dobj = PersistenceDBUtil.getPersistenceLite().get("ELAWorkgroupConfiguration", criteria);
            if (!dobj.isEmpty() && dobj.containsTable("ELAWorkgroupConfiguration")) {
                JSONObject credential;
                Row row = dobj.getFirstRow("ELAWorkgroupConfiguration");
                if (row.get("CREDENTIAL_ID") != null && (credential = ADSDomainHandler.getCredential((Long)((Long)row.get("CREDENTIAL_ID")))) != null) {
                    if (credential.has("USER_NAME")) {
                        workgrpDetails.setProperty("USERNAME", credential.getString("USER_NAME"));
                    }
                    if (credential.has("PASSWORD")) {
                        workgrpDetails.setProperty("USERNAME", credential.getString("PASSWORD"));
                    }
                }
                if (row.get("WORKGROUP_ID") != null) {
                    workgrpDetails.setProperty("WORKGROUP_ID", row.get("WORKGROUP_ID").toString());
                }
                if (row.get("WORKGROUP_NAME") != null) {
                    workgrpDetails.setProperty("WORKGROUP_NAME", row.get("WORKGROUP_NAME").toString());
                }
                if (row.get("WORKGROUP_PATH") != null) {
                    workgrpDetails.setProperty("WORKGROUP_PATH", row.get("WORKGROUP_PATH").toString());
                }
                if (row.get("IS_AUTHENTICATION_REQUIRED") != null) {
                    workgrpDetails.setProperty("IS_AUTHENTICATION_REQUIRED", row.get("IS_AUTHENTICATION_REQUIRED").toString());
                }
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return workgrpDetails;
    }

    public static boolean checkAndADDWorkgroupDetails(Properties workgroupDetails) {
        boolean status = false;
        String workGroupName = workgroupDetails.getProperty("WORKGROUP_NAME");
        LOGGER.info("Started configuration for workgroup : " + workGroupName);
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"ELAWorkgroupConfiguration", (String)"WORKGROUP_NAME"), (Object)workGroupName, 0);
            DataObject dobj = PersistenceDBUtil.getPersistenceLite().get("ELAWorkgroupConfiguration", criteria);
            if (dobj.isEmpty()) {
                Row row = WorkgroupHandler.createWorkGroupRow(workgroupDetails);
                dobj.addRow(row);
                PersistenceDBUtil.getPersistenceLite().update(dobj);
                status = true;
            } else {
                status = true;
                LOGGER.info("Selected workgroup already exists");
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return status;
    }

    private static Row createWorkGroupRow(Properties workgroupDetails) {
        String workGroupName = workgroupDetails.getProperty("WORKGROUP_NAME");
        Row row = new Row("ELAWorkgroupConfiguration");
        row.set("WORKGROUP_NAME", (Object)workGroupName);
        row.set("WORKGROUP_PATH", (Object)workgroupDetails.getProperty("WORKGROUP_PATH"));
        if (workgroupDetails.containsKey("IS_AUTHENTICATION_REQUIRED") && workgroupDetails.getProperty("IS_AUTHENTICATION_REQUIRED").equalsIgnoreCase("TRUE")) {
            row.set("IS_AUTHENTICATION_REQUIRED", (Object)Boolean.TRUE);
            String userName = workgroupDetails.getProperty("USERNAME");
            String password = workgroupDetails.getProperty("PASSWORD");
            Long credentialId = ADSDomainHandler.getCredentialId((String)userName, (String)password, (String)workGroupName);
            row.set("CREDENTIAL_ID", (Object)credentialId);
        }
        Boolean isDefault = WorkgroupHandler.checkISDefaultWorkgroup();
        LOGGER.info("Isdefault workgroup : + " + isDefault);
        row.set("IS_DEFAULT_WORKGROUP", (Object)isDefault);
        row.set("STATUS_MESSAGE", (Object)"ads.domain_confg.native.success");
        return row;
    }

    private static Boolean checkISDefaultWorkgroup() {
        Boolean result = Boolean.TRUE;
        try {
            int count = DBUtil.getCountInt("ELAWorkgroupConfiguration", null);
            LOGGER.info("Existing workgroups count : " + count);
            if (count > 0) {
                result = Boolean.FALSE;
            }
        }
        catch (Exception xp) {
            xp.printStackTrace();
        }
        return result;
    }

    public static JSONArray getAllWorkGroup() throws BaseStatusCode {
        Table table = Table.getTable((String)"ELAWorkgroupConfiguration");
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)table.getTableName()));
        selectQuery.addSelectColumn(Column.getColumn((String)table.getTableName(), (String)"WORKGROUP_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)table.getTableName(), (String)"WORKGROUP_NAME"));
        JSONArray workgroupJsonArray = new JSONArray();
        try {
            DataObject dataObject = PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
            Iterator rowIterator = dataObject.getRows(table.getTableName());
            while (rowIterator.hasNext()) {
                Row row = (Row)rowIterator.next();
                JSONObject newDomainObject = new JSONObject();
                newDomainObject.put("WORKGROUP_ID", row.get("WORKGROUP_ID"));
                newDomainObject.put("WORKGROUP_NAME", row.get("WORKGROUP_NAME"));
                workgroupJsonArray.put((Object)newDomainObject);
            }
        }
        catch (DataAccessException e) {
            throw BaseStatusCode.getBaseStatusCode(7430);
        }
        catch (JSONException e) {
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
        return workgroupJsonArray;
    }

    public static void updateSlstate(String workgroupName) {
        try {
            WorkgroupHandler.updateSlstate(WorkgroupHandler.getWorkgroupID(workgroupName));
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public static void updateSlstate(long workgroupID) throws Exception {
        Criteria domainCriteria = new Criteria(Column.getColumn((String)"HostDetails", (String)"WORKGROUP_ID"), (Object)workgroupID, 0);
        DeviceUtil.handleSLUpdateForUpdateDevice(domainCriteria);
    }
}

