/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.io.file;

import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.util.IOUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.model.ZipParameters;

public class FileHandler {
    private static final Logger LOGGER = Logger.getLogger(FileHandler.class.getName());

    public static void createNewFile(String filepath) throws IOException {
        FileHandler.createNewFile(new File(filepath));
    }

    public static void createNewFile(File file) throws IOException {
        file.createNewFile();
    }

    public static String getTempFilePath(String absolutePath) {
        String extension = FileHandler.getFileExtension(absolutePath);
        String fileName = FileHandler.getFileNamewithoutExtension(absolutePath);
        return fileName + "_" + System.nanoTime() + "." + extension;
    }

    private static String getFileExtension(String absolutePath) {
        int index = FileHandler.indexOfExtension(absolutePath);
        String extension = index == -1 ? "" : absolutePath.substring(index + 1);
        return extension;
    }

    private static String getFileNamewithoutExtension(String fileNameInput) {
        int index = FileHandler.indexOfExtension(fileNameInput);
        String fileName = index == -1 ? fileNameInput : fileNameInput.substring(0, index);
        return fileName;
    }

    public static int indexOfExtension(String filename) {
        if (filename == null) {
            return -1;
        }
        int extensionPos = filename.lastIndexOf(46);
        int lastSeparator = filename.lastIndexOf(File.separator);
        return lastSeparator > extensionPos ? -1 : extensionPos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File source, File dest) {
        boolean result = true;
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            int length;
            is = new FileInputStream(source);
            os = new FileOutputStream(dest);
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)is).read(buffer)) > 0) {
                ((OutputStream)os).write(buffer, 0, length);
            }
        }
        catch (IOException exp) {
            try {
                result = false;
                LOGGER.info("Exception in copy file, Details : " + exp.getMessage());
            }
            catch (Throwable throwable) {
                IOUtil.closeIOStream(is, os);
                throw throwable;
            }
            IOUtil.closeIOStream(is, os);
        }
        IOUtil.closeIOStream(is, os);
        return result;
    }

    public static void copyDirectory(File source, File dest) throws IOException {
        if (source.isDirectory() && source.exists()) {
            String[] files;
            if (!dest.exists()) {
                dest.mkdir();
            }
            for (String file : files = source.list()) {
                FileHandler.copyDirectory(new File(source, file), new File(dest, file));
            }
        } else {
            FileHandler.copyFile(source, dest);
        }
    }

    public static boolean deleteFile(String file) {
        return FileHandler.deleteFile(new File(file));
    }

    public static boolean deleteFile(File file) {
        boolean result = true;
        if (file.exists()) {
            LOGGER.info("Removing Unwanted File ::: " + file.getAbsolutePath());
            FileHandler.deleteIndividualFile(file);
            return true;
        }
        LOGGER.info("File Not Exists ::: " + file.getAbsolutePath());
        result = false;
        return result;
    }

    private static boolean deleteIndividualFile(File file) {
        boolean result = true;
        try {
            file.delete();
        }
        catch (Exception exp) {
            LOGGER.info("Delete File throws follwing exception Exception : " + exp.getMessage());
            result = false;
        }
        return result;
    }

    public static boolean deleteFiles(File file) {
        boolean result = true;
        if (file.isDirectory()) {
            File[] files;
            for (File slcFile : files = file.listFiles()) {
                result = !FileHandler.deleteFiles(slcFile) ? false : result;
            }
            FileHandler.deleteIndividualFile(file);
        } else {
            result = !FileHandler.deleteIndividualFile(file) ? false : result;
        }
        return result;
    }

    public static boolean renameFile(File source, File dest) {
        boolean result = false;
        if (source.exists() && !dest.exists()) {
            result = source.renameTo(dest);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean storeObjectInFIle(Object dataContainer, File file) {
        FileOutputStream fout = null;
        ObjectOutputStream out = null;
        try {
            fout = new FileOutputStream(file);
            out = new ObjectOutputStream(fout);
            out.writeObject(dataContainer);
            out.flush();
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fout != null) {
                    fout.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        out = null;
        fout = null;
        return true;
    }

    public static Properties filetoProperties(String filepath) throws BaseStatusCode {
        return FileHandler.fileToProperties(new File(filepath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties fileToProperties(File file) {
        FileInputStream fIStream;
        Properties eProps;
        block4: {
            eProps = new Properties();
            fIStream = null;
            try {
                if (!file.exists()) break block4;
                fIStream = new FileInputStream(file);
                eProps.load(fIStream);
            }
            catch (Exception exp) {
                try {
                    exp.printStackTrace();
                }
                catch (Throwable throwable) {
                    IOUtil.closeIOStream(fIStream, null);
                    throw throwable;
                }
                IOUtil.closeIOStream(fIStream, null);
            }
        }
        IOUtil.closeIOStream(fIStream, null);
        return eProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object readObjectFromFile(File file) {
        FileInputStream fin = null;
        ObjectInputStream oin = null;
        Object fromFIle = null;
        try {
            fin = new FileInputStream(file);
            oin = new ObjectInputStream(fin);
            fromFIle = oin.readObject();
        }
        catch (Exception ee) {
        }
        finally {
            try {
                if (oin != null) {
                    oin.close();
                }
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        return fromFIle;
    }

    public static boolean compressFiles(String[] sourceFiles, CompressType type, String targetFile, String password) {
        boolean returnValue = false;
        switch (type) {
            case ZIP: {
                returnValue = FileHandler.compressToZip(sourceFiles, targetFile, password);
            }
        }
        return returnValue;
    }

    private static boolean compressToZip(String[] sourceFiles, String targetFile, String password) {
        boolean returnValue = false;
        try {
            ArrayList<File> zipFileIncludeList = new ArrayList<File>();
            for (String fileName : sourceFiles) {
                zipFileIncludeList.add(new File(fileName));
            }
            ZipFile zipFileObject = new ZipFile(targetFile);
            ZipParameters zipParameters = new ZipParameters();
            zipParameters.setCompressionMethod(8);
            zipParameters.setCompressionLevel(5);
            if (password != null && !password.trim().isEmpty()) {
                zipParameters.setEncryptFiles(true);
                zipParameters.setEncryptionMethod(99);
                zipParameters.setAesKeyStrength(3);
                zipParameters.setPassword(password);
            }
            zipFileObject.addFiles(zipFileIncludeList, zipParameters);
            returnValue = true;
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception while creating zip file with password : {0}", e.getMessage());
            e.printStackTrace();
        }
        return returnValue;
    }

    public static enum CompressType {
        ZIP;

    }
}

