/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.io.file;

import com.adventnet.sa.server.imp.ImportEvtLogs;
import com.manageengine.ela.server.common.device.LogSourceCategoryContainer;
import com.manageengine.ela.server.common.device.util.DeviceUtil;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.importlog.ImportFileProperties;
import com.manageengine.ela.server.importlog.LogProperties;
import com.manageengine.ela.server.importlog.datasource.FileSource;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipFile;
import org.elasticsearch.common.Strings;

public class FileUtils {
    private static final Logger LOGGER = Logger.getLogger(FileUtils.class.getName());
    public static String location = System.getProperty("server.dir") + File.separator + "server" + File.separator + "imported_files";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isUTF16(File location) {
        FileInputStream fis = null;
        boolean isUTF16 = false;
        try {
            fis = new FileInputStream(location);
            byte[] buffer = new byte[128];
            fis.read(buffer);
            isUTF16 = buffer[0] == -1 && buffer[1] == -2 || buffer[0] == -2 && buffer[1] == -1;
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException iOException) {}
        }
        return isUTF16;
    }

    /*
     * Unable to fully structure code
     */
    public static synchronized FileSource getBufferReaderList(InputStream inputStream, ImportFileProperties importFileProperties, LogProperties logProperties) throws IOException, BaseStatusCode {
        isLocal = importFileProperties.getLocal();
        localFilePath = importFileProperties.getLocalFilePath();
        bufferedReaders = new ArrayList<BufferedReader>();
        filePathMap = new HashMap<BufferedReader, String>();
        fileSource = new FileSource();
        if (FileUtils.isSupportedCompression(localFilePath)) {
            if (!isLocal) {
                FileUtils.copyToLocalServer(inputStream, Paths.get(localFilePath, new String[0]));
                FileUtils.LOGGER.info("IMPLOG : Compressed File(" + localFilePath + ") Copied to server folder");
            }
            inputStream.close();
            if (localFilePath.endsWith(".zip")) {
                zipFile = new ZipFile(localFilePath);
                entries = zipFile.entries();
                fileSize = 0L;
                while (entries.hasMoreElements()) {
                    entry = entries.nextElement();
                    if (entry.getName().endsWith(".properties")) continue;
                    stream = zipFile.getInputStream(entry);
                    bufferedReader = FileUtils.getBufferedReader(stream);
                    bufferedReaders.add(bufferedReader);
                    filePathMap.put(bufferedReader, entry.getName());
                    fileSize += entry.getSize();
                }
                futureTask = new FutureTask<Object>((Callable<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$getBufferReaderList$15(java.util.zip.ZipFile ), ()Ljava/lang/Object;)((ZipFile)zipFile));
                fileSource.setFileSize(fileSize);
                fileSource.addFutureTasks(futureTask);
            } else if (localFilePath.endsWith(".gz")) {
                while ((extractedFile = new File(extractLocation = FileUtils.location + File.separator + "gz_unzipped" + new Random().nextInt(100))).exists()) {
                }
                if (FileUtils.extractGZIPFile(new File(localFilePath), extractedFile)) {
                    fileSource.setFileSize(extractedFile.length());
                    bufferedReader = FileUtils.getBufferedReader(new FileInputStream(extractedFile));
                    bufferedReaders.add(bufferedReader);
                    filePathMap.put(bufferedReader, extractedFile.getAbsolutePath());
                }
            }
            futureTask = new FutureTask<Object>((Callable<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$getBufferReaderList$16(boolean java.lang.String ), ()Ljava/lang/Object;)((boolean)isLocal, (String)localFilePath));
            fileSource.addFutureTasks(futureTask);
        } else if (localFilePath.toLowerCase().endsWith(".evtx") || localFilePath.toLowerCase().endsWith(".evt")) {
            FileUtils.LOGGER.info("IMPLOG : EVTX FILE FOUND");
            try {
                if (!isLocal) {
                    FileUtils.copyToLocalServer(inputStream, Paths.get(localFilePath, new String[0]));
                    FileUtils.LOGGER.info("IMPLOG : Evtx File(" + localFilePath + ") Copied to server folder");
                }
                inputStream.close();
                importEvtLogs = new ImportEvtLogs();
                logType = importFileProperties.getWindowsLogType();
                details = importEvtLogs.getDetails(localFilePath, logType, 0);
                if (details == null || details.size() <= 2) ** GOTO lbl109
                deviceName = (String)details.get(0);
                minTime = (Long)details.get(1);
                maxTime = (Long)details.get(2);
                hostId = DeviceUtil.getDeviceIdByDNSNameFullName(deviceName);
                if (hostId < 0L) {
                    hostId = DeviceUtil.addAndGetDeviceId(deviceName, LogSourceCategoryContainer.DeviceCategory.WINDOWS);
                }
                if (hostId == -1L) {
                    FileUtils.LOGGER.info("IMPLOG : Exception occured during adding new device from Evtx File");
                    throw BaseStatusCode.getBaseStatusCode(12037);
                }
                logProperties.setLinkedDeviceName(deviceName);
                fName = "evt_" + hostId + "_" + System.currentTimeMillis();
                timeCrit = new ArrayList<Long>();
                timeCrit.add(0, minTime);
                timeCrit.add(1, maxTime);
                result = importEvtLogs.importEvt(localFilePath, new ArrayList<E>(), new ArrayList<E>(), logType, Math.toIntExact(hostId), fName, 0, 0, timeCrit);
                commaIndex = result.indexOf(44);
                fcount = Integer.parseInt(result.substring(0, commaIndex));
                errMessage = result.substring(commaIndex + 1);
                tempBuf = new StringBuilder();
                tempBuf.append(System.getProperty("server.home"));
                tempBuf.append(File.separator);
                tempBuf.append("bin");
                tempBuf.append(File.separator);
                tempBuf.append(fName);
                tempBuf.append('_');
                fileSize = 0L;
                for (i = 0; i <= fcount; ++i) {
                    file = new File(tempBuf.toString() + i);
                    inputStream = new FileInputStream(file);
                    bufferedReader = FileUtils.getBufferedReader(inputStream);
                    bufferedReaders.add(bufferedReader);
                    filePathMap.put(bufferedReader, file.getAbsolutePath());
                    fileSize += file.length();
                }
                fileSource.setFileSize(fileSize);
                if (isLocal) ** GOTO lbl109
                futureTask = new FutureTask<Object>((Callable<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$getBufferReaderList$19(java.util.HashMap java.lang.String ), ()Ljava/lang/Object;)(filePathMap, (String)localFilePath));
                fileSource.addFutureTasks(futureTask);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw BaseStatusCode.getBaseStatusCode(12037);
            }
        } else {
            bufferedReader = FileUtils.getBufferedReader(inputStream);
            bufferedReaders.add(bufferedReader);
            filePathMap.put(bufferedReader, localFilePath);
        }
lbl109:
        // 5 sources

        fileSource.setBufferedReaders(bufferedReaders);
        fileSource.setFilePathMap(filePathMap);
        return fileSource;
    }

    private static void copyToLocalServer(InputStream inputStream, Path path) throws IOException {
        if (!Files.exists(path.getParent(), new LinkOption[0])) {
            Files.createDirectory(path.getParent(), new FileAttribute[0]);
        }
        Files.copy(inputStream, path, StandardCopyOption.REPLACE_EXISTING);
    }

    private static synchronized BufferedReader getBufferedReader(InputStream inputStream) {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        Charset charset = Charset.forName("UTF8");
        try {
            boolean isUTF16;
            byte[] buffer = new byte[32];
            bufferedInputStream.mark(32);
            bufferedInputStream.read(buffer);
            bufferedInputStream.reset();
            boolean bl = isUTF16 = buffer[0] == -1 && buffer[1] == -2 || buffer[0] == -2 && buffer[1] == -1;
            if (isUTF16) {
                charset = Charset.forName("UTF-16");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new BufferedReader(new InputStreamReader((InputStream)bufferedInputStream, charset));
    }

    private static boolean isSupportedCompression(String filename) {
        if (Strings.isNullOrEmpty((String)filename)) {
            return false;
        }
        return filename.endsWith(".zip") || filename.endsWith(".gz");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean extractGZIPFile(File inputGZFile, File outputFile) {
        GZIPInputStream in = null;
        try {
            in = new GZIPInputStream(new FileInputStream(inputGZFile));
            FileUtils.copyToLocalServer(in, outputFile.toPath());
            LOGGER.info("IMPLOG : Compressed Gzip File(" + outputFile.getAbsolutePath() + ") Extracted to server folder");
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private static /* synthetic */ Object lambda$getBufferReaderList$19(HashMap hashMap, String string) throws Exception {
        hashMap.values().stream().map(x$0 -> Paths.get(x$0, new String[0])).forEach(path -> {
            try {
                Files.deleteIfExists(path);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        Files.deleteIfExists(Paths.get(string, new String[0]));
        return null;
    }

    private static /* synthetic */ Object lambda$getBufferReaderList$16(boolean bl, String string) throws Exception {
        if (!bl) {
            Path localPath = Paths.get(string, new String[0]);
            Files.deleteIfExists(localPath);
        }
        return null;
    }

    private static /* synthetic */ Object lambda$getBufferReaderList$15(ZipFile zipFile) throws Exception {
        zipFile.close();
        return null;
    }
}

