/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.io.file.parser;

import com.manageengine.ela.server.common.io.file.parser.ExtractedResultListener;
import com.manageengine.ela.server.common.io.file.parser.FileDetailsBean;
import com.manageengine.ela.server.common.io.file.pattern.DynamicPattern;
import com.manageengine.ela.server.common.io.file.pattern.PatternUtils;
import com.manageengine.ela.server.importlog.ImportFile;
import com.manageengine.ela.server.importlog.ImportUtils;
import com.manageengine.ela.server.importlog.LogBuilder;
import com.manageengine.ela.server.importlog.LogProperties;
import com.manageengine.ela.server.importlog.parser.field.extractor.BaseFieldExtractor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class FileParser {
    private final ExtractedResultListener resultHandlerInterface;

    public FileParser(ExtractedResultListener resultHandlerInterface) throws Exception {
        this.resultHandlerInterface = resultHandlerInterface;
    }

    public ArrayList<FileDetailsBean> parseFile(LogProperties logProperties, Long skipLine, ArrayList<DynamicPattern> dynamicPatterns) throws Exception {
        this.resultHandlerInterface.initialProcessor(logProperties);
        ArrayList<FileDetailsBean> fileDetailsBeans = new ArrayList<FileDetailsBean>();
        ImportFile importFile = new ImportFile(logProperties.getCompleteFilePath(), logProperties.getFileSourceType());
        importFile.setFilename(logProperties.getFileName());
        logProperties.setImportFile(importFile);
        fileDetailsBeans.add(this.processLog(logProperties, skipLine));
        if (dynamicPatterns != null && dynamicPatterns.size() > 0) {
            List<String> newFileList = PatternUtils.getNewFileList(dynamicPatterns, logProperties);
            for (String newFileName : newFileList) {
                if (newFileName.equals(logProperties.getFileName())) continue;
                importFile.setFilename(newFileName);
                logProperties.setImportFile(importFile);
                logProperties.setLineCount(0L);
                fileDetailsBeans.add(this.processLog(logProperties, 0L));
            }
        }
        this.resultHandlerInterface.closeProcessor(fileDetailsBeans, logProperties);
        return fileDetailsBeans;
    }

    private FileDetailsBean processLog(LogProperties logProperties, Long skipLine) throws Exception {
        String lastLine = null;
        Long lineCount = skipLine;
        FileDetailsBean fileDetailsBean = new FileDetailsBean(logProperties.getFileName());
        logProperties.setSourceId(-1L);
        LogBuilder logBuilder = new LogBuilder(logProperties);
        boolean isOpen = logBuilder.open();
        Iterator iterator = logBuilder.iterator();
        BaseFieldExtractor baseFieldExtractor = ExtractedResultListener.getFieldExtractor(logProperties.getLogFormatId(), logBuilder);
        baseFieldExtractor.setTimeZone(logProperties.getTimeZone());
        this.resultHandlerInterface.forEachFileBean(logProperties);
        if (baseFieldExtractor != null) {
            while (isOpen && iterator.hasNext()) {
                HashMap<String, Object> extractedFields;
                String line = iterator.next().toString();
                Long l = lineCount;
                Long l2 = lineCount = Long.valueOf(lineCount + 1L);
                lastLine = line;
                if (line == null || (extractedFields = baseFieldExtractor.getFieldsAsMap(line)) == null || extractedFields.size() == 0 && !ImportUtils.hasAlphanumericCharacter(lastLine) || extractedFields.containsKey("SKIP_THIS_LOG") && extractedFields.get("SKIP_THIS_LOG").equals("1")) continue;
                extractedFields.put("RAWLOG", lastLine);
                this.resultHandlerInterface.processResult(extractedFields, logBuilder, logProperties);
            }
            logProperties.setHeaderLine(baseFieldExtractor.getHeaderLine());
        }
        fileDetailsBean.setLastLine(lastLine);
        fileDetailsBean.setLineCount(lineCount);
        return fileDetailsBean;
    }

    public ExtractedResultListener getResultHandlerInterface() {
        return this.resultHandlerInterface;
    }
}

