/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.io.file.pattern;

import com.adventnet.persistence.DataAccessException;
import com.manageengine.ela.server.common.io.file.pattern.PatternUtils;
import java.util.TimeZone;
import org.elasticsearch.common.Strings;

public class DynamicPattern {
    private static final TimeZone DEFAULT_TIMEZONE = TimeZone.getDefault();
    private String dynamicPattern;
    private TimeZone timeZone = DEFAULT_TIMEZONE;
    private Long patternResolverId = null;

    public DynamicPattern() {
        this(null, DEFAULT_TIMEZONE);
    }

    public DynamicPattern(String dynamicPattern) {
        this(dynamicPattern, DEFAULT_TIMEZONE);
    }

    public DynamicPattern(String dynamicPattern, String timeZoneID) {
        this.dynamicPattern = dynamicPattern;
        if (timeZoneID != null) {
            this.timeZone = TimeZone.getTimeZone(timeZoneID);
        }
    }

    public DynamicPattern(String dynamicPattern, TimeZone timeZone) {
        this.dynamicPattern = dynamicPattern;
        if (timeZone != null) {
            this.timeZone = timeZone;
        }
    }

    public Long getPatternResolverId() throws DataAccessException {
        if (this.patternResolverId == null && !Strings.isNullOrEmpty((String)this.dynamicPattern)) {
            this.patternResolverId = PatternUtils.getDynamicPatternResolverId(this.dynamicPattern);
        }
        return this.patternResolverId;
    }

    public void setPatternResolverId(Long patternResolverId) {
        this.patternResolverId = patternResolverId;
    }

    public String getDynamicPattern() {
        return this.dynamicPattern;
    }

    public void setDynamicPattern(String dynamicPattern) {
        this.dynamicPattern = dynamicPattern;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        if (timeZone == null) {
            timeZone = DEFAULT_TIMEZONE;
        }
        this.timeZone = timeZone;
    }
}

