/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.io.file.pattern;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.common.cache.Cache;
import com.manageengine.ela.server.common.constants.RegularExpressionConstants;
import com.manageengine.ela.server.common.io.file.pattern.DynamicPattern;
import com.manageengine.ela.server.common.io.file.pattern.filter.DynamicFileNameFilter;
import com.manageengine.ela.server.common.io.file.pattern.handler.PatternHandler;
import com.manageengine.ela.server.importlog.LogProperties;
import com.manageengine.ela.server.importlog.protocols.BaseProtocolHandler;
import com.manageengine.ela.server.importlog.protocols.ImportFileNameBean;
import com.manageengine.ela.server.importlog.protocols.ImportProtocolBean;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.math.NumberUtils;
import org.elasticsearch.common.Strings;
import org.json.JSONObject;

public class PatternUtils {
    private static Cache<Long, String> patternHandlerClass = new Cache();
    private static Cache<Long, String> resolverIdPatternNameMap = new Cache();
    private static final String SIMPLE_DATE_PATTERN = "SimpleDatePatternHandler";
    private static final String DATE_PATTERN = "DatePatternHandler";
    private static final String INCREMENT_PATTERN = "IncrementPatternHandler";
    private static final String DATE_INCREMENT_PATTERN = "DateAndIncrementPatternHandler";

    public static Pattern getDynamicDateFilePatternRegex() {
        return RegularExpressionConstants.dynamicDateFilePatternRegex;
    }

    public static Pattern getDynamicKeywordFilePatternRegex() {
        return RegularExpressionConstants.dynamicKeywordFilePatternRegex;
    }

    public static String generateNewFileName(DynamicPattern dynamicPattern, String oldName) throws Exception {
        if (dynamicPattern == null || Strings.isNullOrEmpty((String)dynamicPattern.getDynamicPattern())) {
            return oldName;
        }
        String dynamicPatternValue = dynamicPattern.getDynamicPattern();
        try {
            String patternHandler = PatternUtils.getPatternHandler(dynamicPattern);
            if (patternHandler != null) {
                Class<?> dynamicClass = Class.forName(patternHandler);
                PatternHandler handler = (PatternHandler)dynamicClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                return handler.resolvePattern(dynamicPattern, oldName);
            }
        }
        catch (Exception e) {
            throw new Exception("Invalid Dynamic Pattern");
        }
        return dynamicPatternValue;
    }

    public static boolean matchAnyStarPattern(ArrayList<String> starPatterns, String fileName) {
        for (String starPattern : starPatterns) {
            boolean status = false;
            if (starPattern.length() == fileName.length()) {
                status = true;
                for (int i = 0; i < starPattern.toCharArray().length && status; ++i) {
                    if (starPattern.charAt(i) == '*') continue;
                    status = starPattern.charAt(i) == fileName.charAt(i);
                }
            }
            if (!status) continue;
            return true;
        }
        return false;
    }

    public static String generateStarPattern(DynamicPattern dynamicPattern, String oldName) throws Exception {
        if (dynamicPattern == null || Strings.isNullOrEmpty((String)dynamicPattern.getDynamicPattern())) {
            return oldName;
        }
        String dynamicPatternValue = dynamicPattern.getDynamicPattern();
        try {
            String patternHandler = PatternUtils.getPatternHandler(dynamicPattern);
            if (patternHandler != null) {
                Class<?> dynamicClass = Class.forName(patternHandler);
                PatternHandler handler = (PatternHandler)dynamicClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                return handler.generateStarPattern(dynamicPattern, oldName);
            }
        }
        catch (Exception e) {
            throw new Exception("Invalid Dynamic Pattern");
        }
        return dynamicPatternValue;
    }

    public static String getPatternHandler(DynamicPattern dynamicPattern) throws DataAccessException {
        Long patternResolverId = dynamicPattern.getPatternResolverId();
        if (!patternHandlerClass.containsKey(patternResolverId) || patternHandlerClass.get(patternResolverId) == null) {
            Criteria criteria = new Criteria(Column.getColumn((String)"ELAFileNamePatternResolver", (String)"RESOLVER_ID"), (Object)patternResolverId, 0);
            DataObject dataObject = PersistenceDBUtil.getPersistence().get("ELAFileNamePatternResolver", criteria);
            if (!dataObject.isEmpty()) {
                String patternHandler = (String)dataObject.getFirstValue("ELAFileNamePatternResolver", "PATTERN_RESOLVE_HANDLER");
                patternHandlerClass.put(patternResolverId, patternHandler);
            }
        }
        return patternHandlerClass.get(patternResolverId);
    }

    public static String getPatternName(Long resolverId) throws DataAccessException {
        if (resolverIdPatternNameMap.containsKey(resolverId) && resolverIdPatternNameMap.get(resolverId) != null) {
            return resolverIdPatternNameMap.get(resolverId);
        }
        Criteria criteria = new Criteria(Column.getColumn((String)"ELAFileNamePatternResolver", (String)"RESOLVER_ID"), (Object)resolverId, 0);
        DataObject dataObject = PersistenceDBUtil.getPersistence().get("ELAFileNamePatternResolver", criteria);
        String patternName = (String)dataObject.getFirstValue("ELAFileNamePatternResolver", "PATTERN_NAME");
        resolverIdPatternNameMap.put(resolverId, patternName);
        return patternName;
    }

    public static Long getDynamicPatternResolverId(String dynamicPattern) throws DataAccessException {
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"ELAFileNamePatternResolver"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ELAFileNamePatternResolver", (String)"*"));
        selectQuery.addSortColumn(new SortColumn(Column.getColumn((String)"ELAFileNamePatternResolver", (String)"PRIORITY"), false));
        DataObject dataObject = PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
        if (!dataObject.isEmpty()) {
            Iterator iterator = dataObject.getRows("ELAFileNamePatternResolver");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                String basePattern = (String)row.get("BASE_PATTERN");
                Pattern pattern = Pattern.compile(basePattern);
                Matcher matcher = pattern.matcher(dynamicPattern);
                if (!matcher.find()) continue;
                return NumberUtils.toLong((String)String.valueOf(row.get("RESOLVER_ID")));
            }
        }
        return 1L;
    }

    public static List<DynamicPattern> getDynamicPatternList(DataObject dataObject) throws DataAccessException {
        ArrayList<DynamicPattern> dynamicPatterns = new ArrayList<DynamicPattern>();
        Iterator importLogDynamicPatternsIterator = dataObject.getRows("ELADynamicPatterns");
        while (importLogDynamicPatternsIterator.hasNext()) {
            Row importLogDynamicPatternRow = (Row)importLogDynamicPatternsIterator.next();
            String dynamicPatternStr = (String)importLogDynamicPatternRow.get("DYNAMIC_PATTERN");
            Long patterResolverId = (Long)importLogDynamicPatternRow.get("RESOLVER_ID");
            TimeZone timeZone = TimeZone.getTimeZone((String)importLogDynamicPatternRow.get("TIME_ZONE"));
            DynamicPattern dynamicPattern = new DynamicPattern(dynamicPatternStr, timeZone);
            dynamicPattern.setPatternResolverId(patterResolverId);
            dynamicPatterns.add(dynamicPattern);
        }
        return dynamicPatterns;
    }

    public static List<String> getNewFileList(ArrayList<DynamicPattern> dynamicPatterns, LogProperties logProperties) throws Exception {
        ImportProtocolBean importProtocolBean = logProperties.getImportProtocolBean();
        JSONObject returnObject = new JSONObject();
        String oldName = logProperties.getFileName();
        String filePath = logProperties.getFileDirectory();
        Class<?> dynamicClass = Class.forName(importProtocolBean.getProtocolHandlerClass());
        BaseProtocolHandler model = (BaseProtocolHandler)dynamicClass.getConstructor(String.class, ImportProtocolBean.class, LogProperties.class).newInstance(filePath, importProtocolBean, null);
        DynamicFileNameFilter dynamicFileNameFilter = new DynamicFileNameFilter(oldName, dynamicPatterns);
        ArrayList<ImportFileNameBean> fileList = model.listFiles(logProperties.getLinkedDeviceName(), filePath, returnObject, dynamicFileNameFilter);
        return fileList.stream().filter(importFileNameBean -> !importFileNameBean.isDirectory()).map(ImportFileNameBean::getFileName).collect(Collectors.toList());
    }

    public static List<String> sortFileListForWeekDayPattern(List<String> fileList) {
        Comparator<String> fileNameComparator = new Comparator<String>(){

            @Override
            public int compare(String fileName1, String fileName2) {
                SimpleDateFormat format = new SimpleDateFormat("EEE");
                try {
                    Date d1 = format.parse(fileName1);
                    Date d2 = format.parse(fileName2);
                    Date d3 = new Date();
                    Calendar cal1 = Calendar.getInstance();
                    Calendar cal2 = Calendar.getInstance();
                    Calendar cal3 = Calendar.getInstance();
                    cal1.setTime(d1);
                    cal2.setTime(d2);
                    cal3.setTime(d3);
                    int currentDay = cal3.get(7);
                    if (cal1.get(7) > currentDay) {
                        return cal1.get(7) - cal2.get(7) - currentDay;
                    }
                    return cal1.get(7) - cal2.get(7) - currentDay + 7;
                }
                catch (ParseException e) {
                    return -1;
                }
            }
        };
        try {
            Collections.sort(fileList, fileNameComparator);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileList;
    }

    public static boolean isWeekDayPattern(List<DynamicPattern> patterns) {
        for (DynamicPattern pattern : patterns) {
            String patternName;
            try {
                patternName = PatternUtils.getPatternName(pattern.getPatternResolverId());
            }
            catch (DataAccessException e) {
                patternName = null;
                e.printStackTrace();
            }
            if (patternName == null || Objects.equals(patternName, SIMPLE_DATE_PATTERN)) {
                return pattern.getDynamicPattern().contains("EEE");
            }
            if (!Objects.equals(patternName, DATE_INCREMENT_PATTERN) && !Objects.equals(patternName, DATE_PATTERN)) continue;
            return pattern.getDynamicPattern().contains("${EEE}") || pattern.getDynamicPattern().contains("${EEEE}");
        }
        return false;
    }
}

