/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.io.file.pattern.filter;

import com.manageengine.ela.server.common.io.file.pattern.DynamicPattern;
import com.manageengine.ela.server.common.io.file.pattern.PatternUtils;
import com.manageengine.ela.server.importlog.datasource.comparator.NaturalComparator;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFilenameFilter;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileFilter;

public class DynamicFileNameFilter
implements SmbFilenameFilter,
FilenameFilter,
FTPFileFilter {
    private final String oldName;
    private final ArrayList<DynamicPattern> dynamicPatterns;
    private final HashMap<DynamicPattern, String> dynamicPatternToNewNameMap = new HashMap();
    private final HashMap<DynamicPattern, ArrayList<String>> dynamicPatternToStarPatternMap = new HashMap();

    public DynamicFileNameFilter(String oldName, ArrayList<DynamicPattern> patternArrayList) throws Exception {
        this.oldName = oldName.toLowerCase();
        this.dynamicPatterns = patternArrayList;
        for (DynamicPattern dynamicPattern : patternArrayList) {
            String newName = PatternUtils.generateNewFileName(dynamicPattern, oldName);
            this.dynamicPatternToNewNameMap.put(dynamicPattern, newName);
        }
    }

    @Override
    public boolean accept(File dir, String fileName) {
        return this.accept(fileName);
    }

    public boolean accept(SmbFile smbFile, String fileName) throws SmbException {
        return this.accept(fileName);
    }

    public boolean accept(FTPFile ftpFile) {
        return this.accept(ftpFile.getName());
    }

    public ArrayList<String> getProjectedFileNameList() {
        ArrayList<String> fileNameList = new ArrayList<String>();
        if (this.dynamicPatternToNewNameMap != null && this.dynamicPatternToNewNameMap.size() > 0) {
            fileNameList.addAll(this.dynamicPatternToNewNameMap.values());
        }
        return fileNameList;
    }

    public boolean accept(String fileName) {
        fileName = fileName.toLowerCase();
        NaturalComparator naturalComparator = new NaturalComparator();
        for (DynamicPattern dynamicPattern : this.dynamicPatterns) {
            String newName = this.dynamicPatternToNewNameMap.get(dynamicPattern).toLowerCase();
            if (naturalComparator.compare(fileName, newName) == 0) {
                return true;
            }
            if (naturalComparator.compare(fileName, this.oldName) <= 0 || naturalComparator.compare(fileName, newName) >= 0) continue;
            return true;
        }
        return false;
    }
}

