/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.io.file.pattern.handler;

import com.manageengine.ela.server.common.io.file.pattern.DynamicPattern;
import com.manageengine.ela.server.common.io.file.pattern.PatternUtils;
import com.manageengine.ela.server.common.io.file.pattern.handler.PatternHandler;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class IncrementPatternHandler
implements PatternHandler {
    @Override
    public String resolvePattern(DynamicPattern dynamicPattern, String oldName) throws Exception {
        int count;
        String dynamicPatternValue = dynamicPattern.getDynamicPattern();
        Matcher keywordMatcher = PatternUtils.getDynamicKeywordFilePatternRegex().matcher(dynamicPatternValue);
        int nextNumber = IncrementPatternHandler.getNextNumber(dynamicPatternValue, oldName);
        for (count = 0; keywordMatcher.find() && count < 100; ++count) {
            String key = keywordMatcher.group(1).toUpperCase();
            if (key.startsWith("NUMBER_")) {
                int numberOfDigits = NumberUtils.toInt((String)key.substring(7), (int)0);
                dynamicPatternValue = dynamicPatternValue.replaceAll("\\$\\{\\{" + key + "\\}\\}", String.format("%0" + numberOfDigits + "d", nextNumber));
            }
            keywordMatcher.reset(dynamicPatternValue);
        }
        if (count >= 100) {
            throw new Exception("Invalid Dynamic Pattern");
        }
        return dynamicPatternValue;
    }

    private static int getNextNumber(String dynamicPattern, String oldName) {
        int nextNumber = 0;
        if (oldName != null && StringUtils.difference((String)oldName, (String)dynamicPattern).startsWith("$")) {
            int diffIndex = StringUtils.indexOfDifference((CharSequence)dynamicPattern, (CharSequence)oldName);
            StringBuilder numberStringBuilder = new StringBuilder();
            for (int i = diffIndex; i < oldName.length() && StringUtils.isNumeric((CharSequence)String.valueOf(oldName.charAt(i))); ++i) {
                numberStringBuilder.append(oldName.charAt(i));
            }
            nextNumber = NumberUtils.toInt((String)numberStringBuilder.toString(), (int)0);
        }
        return nextNumber + 1;
    }
}

