/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.io.file.pattern.handler;

import com.manageengine.ela.server.common.io.file.pattern.DynamicPattern;
import com.manageengine.ela.server.common.io.file.pattern.PatternUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import org.apache.commons.lang3.math.NumberUtils;
import org.elasticsearch.common.Strings;

public interface PatternHandler {
    public String resolvePattern(DynamicPattern var1, String var2) throws Exception;

    default public String resolvePattern(DynamicPattern dynamicPattern) throws Exception {
        return this.resolvePattern(dynamicPattern, null);
    }

    default public String generateStarPattern(DynamicPattern dynamicPattern, String oldName) throws Exception {
        if (dynamicPattern == null || Strings.isNullOrEmpty((String)dynamicPattern.getDynamicPattern())) {
            return null;
        }
        String starPattern = dynamicPattern.getDynamicPattern();
        Matcher keywordMatcher = PatternUtils.getDynamicKeywordFilePatternRegex().matcher(starPattern);
        Matcher dateMatcher = PatternUtils.getDynamicDateFilePatternRegex().matcher(starPattern);
        try {
            String key;
            Calendar calendar = Calendar.getInstance(dynamicPattern.getTimeZone());
            Date date = calendar.getTime();
            dateMatcher = dateMatcher.reset(starPattern);
            while (dateMatcher.find()) {
                key = dateMatcher.group(1);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(key);
                String starFormat = simpleDateFormat.format(date).replaceAll(".", "*");
                starPattern = starPattern.replaceAll("\\$\\{" + key + "\\}", starFormat);
                dateMatcher.reset(starPattern);
            }
            keywordMatcher = keywordMatcher.reset(starPattern);
            while (keywordMatcher.find()) {
                key = keywordMatcher.group(1).toUpperCase();
                if (key.startsWith("NUMBER_")) {
                    int numberOfDigits = NumberUtils.toInt((String)key.substring(7), (int)0);
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 0; i < numberOfDigits; ++i) {
                        stringBuilder.append("*");
                    }
                    starPattern = starPattern.replaceAll("\\$\\{\\{" + key + "\\}\\}", stringBuilder.toString());
                }
                keywordMatcher.reset(starPattern);
            }
        }
        catch (Exception e) {
            throw new Exception("Invalid Dynamic Pattern");
        }
        return starPattern;
    }
}

