/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.io.file.pattern.handler;

import com.manageengine.ela.server.common.io.file.pattern.DynamicPattern;
import com.manageengine.ela.server.common.io.file.pattern.handler.PatternHandler;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class SimpleDatePatternHandler
implements PatternHandler {
    @Override
    public String resolvePattern(DynamicPattern dynamicPattern, String oldName) {
        String pattern = dynamicPattern.getDynamicPattern();
        Calendar calendar = Calendar.getInstance(dynamicPattern.getTimeZone());
        Date date = calendar.getTime();
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        String currentFormat = format.format(date);
        StringBuffer regex = new StringBuffer();
        if (pattern.equals("EEE")) {
            regex.append("(Mon|Tue|Wed|Thu|Fri|Sat|Sun)");
            return oldName.replaceAll(regex.toString(), currentFormat);
        }
        if (oldName.indexOf(currentFormat) < 0) {
            int length = pattern.length();
            block4: for (int i = 0; i < length; ++i) {
                char c = pattern.charAt(i);
                switch (c) {
                    case 'E': 
                    case 'M': {
                        regex.append("[A-Za-z0-9]");
                        continue block4;
                    }
                    case 'D': 
                    case 'F': 
                    case 'H': 
                    case 'K': 
                    case 'S': 
                    case 'W': 
                    case 'd': 
                    case 'h': 
                    case 'k': 
                    case 'm': 
                    case 's': 
                    case 'w': 
                    case 'y': {
                        regex.append("\\d");
                        continue block4;
                    }
                    default: {
                        regex.append(c);
                    }
                }
            }
            return oldName.replaceAll(regex.toString(), currentFormat);
        }
        return oldName;
    }

    @Override
    public String generateStarPattern(DynamicPattern dynamicPattern, String oldName) throws Exception {
        String pattern = dynamicPattern.getDynamicPattern();
        Calendar calendar = Calendar.getInstance(dynamicPattern.getTimeZone());
        Date date = calendar.getTime();
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        String currentFormat = format.format(date).replaceAll(".", "*");
        StringBuffer regex = new StringBuffer();
        if (pattern.equals("EEE")) {
            regex.append("(Mon|Tue|Wed|Thu|Fri|Sat|Sun)");
            return oldName.replaceAll(regex.toString(), currentFormat);
        }
        if (oldName.indexOf(currentFormat) < 0) {
            int length = pattern.length();
            block4: for (int i = 0; i < length; ++i) {
                char c = pattern.charAt(i);
                switch (c) {
                    case 'E': 
                    case 'M': {
                        regex.append("[A-Za-z0-9]");
                        continue block4;
                    }
                    case 'D': 
                    case 'F': 
                    case 'H': 
                    case 'K': 
                    case 'S': 
                    case 'W': 
                    case 'd': 
                    case 'h': 
                    case 'k': 
                    case 'm': 
                    case 's': 
                    case 'w': 
                    case 'y': {
                        regex.append("\\d");
                        continue block4;
                    }
                    default: {
                        regex.append(c);
                    }
                }
            }
            return oldName.replaceAll(regex.toString(), currentFormat);
        }
        return oldName;
    }
}

