/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.io.file.writer;

import com.manageengine.ela.server.common.cache.ServerDetailsBean;
import com.manageengine.ela.server.common.database.DefaultValueProvider;
import com.manageengine.ela.server.common.io.file.writer.FileFieldsProcessor;
import java.util.List;

public final class DefaultFieldProcessor
implements FileFieldsProcessor {
    private List<String> fileds = null;
    private static String lineDelimiter = null;
    private DefaultValueProvider defaulltValueProvider = null;
    private String fieldDelimiter = null;

    public DefaultFieldProcessor(List<String> fields, DefaultValueProvider defaulltValueProvider) throws IllegalArgumentException {
        if (fields == null || defaulltValueProvider == null) {
            throw new IllegalArgumentException("Fields or validator has null value");
        }
        this.fileds = fields;
        this.defaulltValueProvider = defaulltValueProvider;
        this.init();
    }

    private void init() {
        this.fieldDelimiter = this.defaulltValueProvider.getFieldDelimiter();
    }

    @Override
    public CharSequence process() throws Exception {
        CharSequence data = this.extractFields();
        return data;
    }

    private CharSequence extractFields() {
        int index;
        StringBuffer buffer = new StringBuffer();
        int fieldsSize = this.fileds.size() - 1;
        for (index = 0; index < fieldsSize; ++index) {
            buffer.append(this.getValueBasedOnValidator(this.fileds.get(index), this.defaulltValueProvider)).append(this.fieldDelimiter);
        }
        buffer.append(this.getValueBasedOnValidator(this.fileds.get(index), this.defaulltValueProvider));
        return buffer;
    }

    private String getValueBasedOnValidator(String field, DefaultValueProvider validator) {
        String result = null;
        result = field != null ? validator.getEscapedString(field) : validator.getNullValue();
        return result;
    }

    public String getFieldelimiter() {
        return this.fieldDelimiter;
    }

    public void setFieldelimiter(String fieldDelimiter) throws IllegalArgumentException {
        if (fieldDelimiter == null) {
            throw new IllegalArgumentException("FieldDelimiter has invalid value");
        }
        this.fieldDelimiter = fieldDelimiter;
    }

    @Override
    public String getLineDelimiter() {
        return lineDelimiter;
    }

    public void setLineDelimiter(String lineDelimiter) throws IllegalArgumentException {
        if (lineDelimiter == null) {
            throw new IllegalArgumentException("LineSeparator has invalid value");
        }
        DefaultFieldProcessor.lineDelimiter = lineDelimiter;
    }

    public String toString() {
        return this.fileds == null ? "null" : this.fileds.toString();
    }

    static {
        lineDelimiter = ServerDetailsBean.getLineSeparator();
    }
}

