/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.io.file.writer;

import com.manageengine.ela.server.common.callback.CallBackArguments;
import com.manageengine.ela.server.common.callback.CommonCallBack;
import com.manageengine.ela.server.common.executors.processor.ConcurrentQueueProcessor;
import com.manageengine.ela.server.common.executors.queue.ConcurrentQueue;
import com.manageengine.ela.server.common.io.file.FileHandler;
import com.manageengine.ela.server.common.io.file.writer.FileFieldsProcessor;
import com.manageengine.ela.server.common.io.file.writer.FileWriterConstants;
import com.manageengine.ela.server.common.io.file.writer.QueueProcessorParams;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.util.IOUtil;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class FileIOQueueProcessor
extends ConcurrentQueueProcessor<FileFieldsProcessor>
implements Flushable,
Closeable {
    private volatile boolean isFileOpened = false;
    private Writer out = null;
    private AtomicInteger overHeadLimit = new AtomicInteger();
    private String file = null;
    private File processingFile = null;
    private QueueProcessorParams processorParams = null;
    private List<File> processedFiles = new ArrayList<File>();
    private static final Logger LOGGER = Logger.getLogger(FileIOQueueProcessor.class.getName());

    public FileIOQueueProcessor(ConcurrentQueue<FileFieldsProcessor> queue, String file, QueueProcessorParams params) throws IllegalArgumentException, IOException {
        super(queue);
        if (!this.justify(file, params)) {
            throw new IllegalArgumentException("Invalid parameters");
        }
        this.file = file;
        this.processorParams = params;
        if (!this.isFileOpened) {
            this.initTempFile();
        }
    }

    private boolean justify(String file, QueueProcessorParams params) {
        boolean result = true;
        if (file == null || params == null) {
            result = false;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initTempFile() throws IOException {
        block6: {
            boolean errorFlag = true;
            this.processingFile = new File(FileHandler.getTempFilePath(this.file));
            if (!this.processingFile.exists()) {
                this.processingFile.createNewFile();
            }
            OutputStreamWriter oStreamWriter = null;
            FileOutputStream fStream = null;
            try {
                fStream = new FileOutputStream(this.processingFile, false);
                oStreamWriter = new OutputStreamWriter((OutputStream)fStream, this.processorParams.getFileEncoding());
                this.out = new BufferedWriter(oStreamWriter, this.processorParams.getBufferSize());
                errorFlag = false;
                if (!errorFlag) break block6;
            }
            catch (IOException exp) {
                try {
                    throw exp;
                }
                catch (Throwable throwable) {
                    if (errorFlag) {
                        IOUtil.closeIOStream(null, fStream);
                        IOUtil.closeReaderWriter(null, oStreamWriter);
                        IOUtil.closeReaderWriter(null, this.out);
                    }
                    throw throwable;
                }
            }
            IOUtil.closeIOStream(null, fStream);
            IOUtil.closeReaderWriter(null, oStreamWriter);
            IOUtil.closeReaderWriter(null, this.out);
        }
        this.processedFiles.add(this.processingFile);
        this.isFileOpened = true;
    }

    @Override
    public void process(FileFieldsProcessor data) throws Exception {
        try {
            this.callSingleWrite(data);
        }
        catch (Exception exp) {
            LOGGER.fine("Unable to Process request , Details \nDataSource : " + data + "  Exception  : " + exp.getMessage());
        }
    }

    private void callSingleWrite(FileFieldsProcessor fileFieldsProcessor) throws Exception {
        CharSequence charSeq = fileFieldsProcessor.process();
        this.lock.lock();
        try {
            this.checkFileOverHeadLimit();
            if (this.overHeadLimit.get() != 0) {
                this.out.append(fileFieldsProcessor.getLineDelimiter());
            }
            this.out.append(charSeq);
            this.overHeadLimit.incrementAndGet();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void checkFileOverHeadLimit() throws IOException {
        if (this.processorParams.isFilerotationNeeded()) {
            int completedEntries = this.overHeadLimit.get();
            if (this.processorParams.getFileOverHeadLimit() <= completedEntries) {
                LOGGER.info("File OverHeadLimit Reached : " + this.overHeadLimit.get() + "  File : " + this.file);
                this.handleOverHeadStack(false);
                this.overHeadLimit.set(0);
            }
        }
    }

    private void handleOverHeadStack(boolean nextFileNeeded) throws IOException {
        this.closeFileWriter();
        CommonCallBack callBack = this.processorParams.getFileProcessorCallBack();
        if (callBack != null) {
            CallBackArguments args = this.processorParams.getFileProcessorCallBackArgs();
            args.put(FileWriterConstants.CURRENT_FILEPATH, this.processingFile.getAbsolutePath());
            args.put(FileWriterConstants.ALL_PROCESSED_FILES, this.processedFiles);
            args.put(FileWriterConstants.ISFINALCALL, nextFileNeeded ? Boolean.TRUE : Boolean.FALSE);
            callBack.callBack(args);
        }
        if (!nextFileNeeded) {
            this.initTempFile();
        }
    }

    @Override
    public void flush() {
        LOGGER.info("closeProcessorInterrupt raised going to stop processors ifQueue Empty");
        super.stopIfQueueIsEmpty();
    }

    @Override
    public void close() throws IOException {
        this.handleOverHeadStack(true);
    }

    private void closeFileWriter() {
        this.isFileOpened = false;
        try {
            this.out.flush();
        }
        catch (Exception exp) {
            LOGGER.info(BaseStatusCode.getBaseStatusCode(6663).toString());
        }
        try {
            this.out.close();
        }
        catch (Exception exp) {
            LOGGER.info(BaseStatusCode.getBaseStatusCode(6663).toString());
        }
    }

    public long getBufferSize() {
        return this.processorParams.getBufferSize();
    }

    public QueueProcessorParams getProcessorParams() {
        return this.processorParams;
    }
}

