/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.io.file.writer;

import com.manageengine.ela.server.common.executors.processor.ProcessorPoolExecutor;
import com.manageengine.ela.server.common.executors.processor.ProcessorPoolExecutorImpl;
import com.manageengine.ela.server.common.executors.queue.CommonQueue;
import com.manageengine.ela.server.common.executors.queue.CommonQueueImpl;
import com.manageengine.ela.server.common.executors.queue.ConcurrentQueue;
import com.manageengine.ela.server.common.io.file.writer.FileFieldsProcessor;
import com.manageengine.ela.server.common.io.file.writer.FileIOQueueProcessor;
import com.manageengine.ela.server.common.io.file.writer.QueueProcessorParams;
import java.io.IOException;
import java.util.logging.Logger;

public class TempFileWriter
implements CommonQueue<FileFieldsProcessor> {
    private FileIOQueueProcessor processor = null;
    private ConcurrentQueue<FileFieldsProcessor> queue = null;
    private ProcessorPoolExecutor processorPlExecutor = null;
    private static final Logger LOGGER = Logger.getLogger(TempFileWriter.class.getName());

    public TempFileWriter(String filePath, QueueProcessorParams params) throws IllegalArgumentException, IOException {
        if (!this.justify(filePath, params, params)) {
            throw new IllegalArgumentException("Invalid parameters");
        }
        this.queue = new CommonQueueImpl<FileFieldsProcessor>();
        this.processor = new FileIOQueueProcessor(this.queue, filePath, params);
        this.processorPlExecutor = new ProcessorPoolExecutorImpl<FileFieldsProcessor>(this.processor, params.getMaxProcessor());
    }

    private boolean justify(String filePath, QueueProcessorParams params2, QueueProcessorParams queueProcessorparams2) {
        boolean result = true;
        if (filePath == null || params2 == null || queueProcessorparams2 == null) {
            result = false;
        }
        return result;
    }

    public TempFileWriter start() throws IllegalAccessException {
        this.addProcessor();
        return this;
    }

    public void addProcessor() throws IllegalAccessException {
        this.processorPlExecutor.addProcessor();
    }

    @Override
    public void add(FileFieldsProcessor data) throws Exception {
        this.queue.add(data);
    }

    @Override
    public void put(FileFieldsProcessor data) throws Exception {
        this.queue.put(data);
    }

    public void finalizeWriter() {
        try {
            LOGGER.info("Finalize called in TempFileWriter");
            this.processor.flush();
            this.processorPlExecutor.shutdown();
            this.processor.close();
            LOGGER.info("Exited from finalizeWriter");
        }
        catch (Exception exp) {
            LOGGER.info("Exception occurred in finalizeWriter , details " + exp.getMessage());
        }
    }
}

