/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.jni.windows;

import com.manageengine.ads.fw.ldap.ad.ADSADErrorHandler;
import com.manageengine.ela.server.common.jni.listner.ELANativeListner;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.elasticsearch.common.Strings;

public class ELANativeHandler {
    private static boolean isLibLoaded = false;
    private static final Logger LOGGER = Logger.getLogger(ELANativeHandler.class.getName());

    private static native void DiscoverWorkGroups();

    private static native void InitializeClassIDs();

    private static native void CleanupClassIDs();

    private static native void GetWorkgroupObjects(Properties var0, String var1, ArrayList<String> var2, ELANativeListner var3, ADSADErrorHandler var4);

    private static native Properties queryRegistry(Properties var0, boolean var1);

    public static void discoverWorkGroups() {
        ELANativeHandler.DiscoverWorkGroups();
    }

    public static ADSADErrorHandler getWorkGroupObjects(Properties domainDetails, String objectClass, ArrayList<String> attributeList, ELANativeListner listener) throws Exception {
        ADSADErrorHandler errHdlr = new ADSADErrorHandler();
        ELANativeHandler.GetWorkgroupObjects(domainDetails, objectClass, attributeList, listener, errHdlr);
        return errHdlr;
    }

    public static Properties queryRegistry(String device, String username, String password, boolean isDefaultAuthentication, String queryPath, String queryKey) {
        Properties args = new Properties();
        args.setProperty("QUERY_PATH", queryPath);
        args.setProperty("QUERY_VALUE", queryKey);
        args.setProperty("DEVICE_NAME", device);
        if (username != null) {
            String domain = "";
            if (!Strings.isNullOrEmpty((String)username) && username.contains("\\") && !username.endsWith("\\")) {
                domain = username.substring(0, username.lastIndexOf("\\"));
                username = username.substring(username.lastIndexOf("\\") + 1);
            } else if (!Strings.isNullOrEmpty((String)username) && username.contains("@") && !username.endsWith("@")) {
                domain = username.substring(username.lastIndexOf("@") + 1);
                username = username.substring(0, username.lastIndexOf("@"));
            } else {
                domain = device;
            }
            args.setProperty("DOMAIN", domain);
            args.setProperty("USERNAME", username);
            args.setProperty("PASSWORD", password);
        }
        return ELANativeHandler.queryRegistry(args, isDefaultAuthentication);
    }

    private static void loadLibrary() {
        try {
            System.loadLibrary("ElaUtil");
            ELANativeHandler.InitializeClassIDs();
            isLibLoaded = true;
        }
        catch (Exception exp) {
            LOGGER.info("Unable to load Eventlog library");
            exp.printStackTrace();
        }
    }

    private static native int discoverEvtFiles(boolean var0, String var1, String var2, String var3, String var4, String var5, ELANativeListner var6);

    public static int discoverEvtFiles(boolean isLocal, Map<String, String> machineInfo, ELANativeListner listener) {
        return ELANativeHandler.discoverEvtFiles(isLocal, machineInfo.get("DEVICE_NAME"), machineInfo.get("DOMAIN_NAME"), machineInfo.get("USERNAME"), machineInfo.get("PASSWORD"), "SYSTEM\\CurrentControlSet\\Services\\EventLog\\", listener);
    }

    public static native int configureRegistryKey(boolean var0, String var1, String var2, String var3, String var4, String var5, List<String> var6, List<String> var7);

    public static int configureRegistryKey(boolean islocal, Map<String, String> machineInfo, List<String> addKeyList, List<String> deleteKeyList) {
        return ELANativeHandler.configureRegistryKey(islocal, machineInfo.get("DEVICE_NAME"), machineInfo.get("DOMAIN_NAME"), machineInfo.get("USERNAME"), machineInfo.get("PASSWORD"), "SYSTEM\\CurrentControlSet\\Services\\EventLog\\", addKeyList, deleteKeyList);
    }

    private static native ArrayList listSharedFolders(String var0);

    public static ArrayList listDeviceShares(String dnsName) {
        return ELANativeHandler.listSharedFolders(dnsName);
    }

    private static native long getFileHandleWithGenericWrite(String var0);

    public static long getFileHandleForWriteStream(String filename) {
        return ELANativeHandler.getFileHandleWithGenericWrite(filename);
    }

    static {
        ELANativeHandler.loadLibrary();
    }
}

