/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.license;

import com.adventnet.ds.query.Criteria;
import com.adventnet.la.enterprise.EnterpriseException;
import com.adventnet.la.enterprise.dc.SyncUtil;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.sa.server.EAService;
import com.adventnet.sa.server.util.CommonUtil;
import com.adventnet.sa.server.util.HostDBHandler;
import com.adventnet.sa.server.util.InheritedHostHandler;
import com.adventnet.tools.prevalent.CMDClass;
import com.adventnet.tools.prevalent.LUtil;
import com.adventnet.tools.prevalent.Validation;
import com.adventnet.tools.prevalent.Wield;
import com.manageengine.ads.fw.license.LicenseManager;
import com.manageengine.ads.fw.license.LicenseXMLParser;
import com.manageengine.ela.server.common.cache.ServerDetailsBean;
import com.manageengine.ela.server.common.executors.processor.extended.CommonFixedThreadExecutor;
import com.manageengine.ela.server.common.executors.queue.priority.PriorityQueueFieldRunnable;
import com.manageengine.ela.server.common.license.LicenseComponents;
import com.manageengine.ela.server.common.license.ProductsAndComponents;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.util.Priority;
import java.io.File;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

final class LicenseActions {
    private static final ReentrantReadWriteLock LICENSELOCK = new ReentrantReadWriteLock(true);
    private static final Logger LOGGER = Logger.getLogger(LicenseActions.class.getName());
    private static final long MAX_DELAY = 20L;

    LicenseActions() {
    }

    public static boolean upgradeLicenseContentNewFromat(String licenseContent) throws BaseStatusCode {
        return LicenseActions.upgrade(ProductsAndComponents.EVENTLOG_ANALYZER, licenseContent, false);
    }

    public static boolean upgradeLicenseContentOldFromat(String licenseContent) throws BaseStatusCode {
        return LicenseActions.upgrade(ProductsAndComponents.OLD_EVENTLOG_ANALYZER, licenseContent, false);
    }

    public static boolean upgradeLicenseContentLog360Fromat(String licenseContent) throws BaseStatusCode {
        return LicenseActions.upgrade(ProductsAndComponents.EVENTLOG_ANALYZER, licenseContent, true);
    }

    private static boolean upgrade(ProductsAndComponents component, String licenseContent, boolean isMixedType) throws BaseStatusCode {
        try {
            if (isMixedType) {
                return LicenseActions.upgradeFromMixedContent(component, licenseContent);
            }
            return LicenseActions.upgradeFromContent(component, licenseContent);
        }
        catch (BaseStatusCode statuscode) {
            throw statuscode;
        }
        catch (Exception exp) {
            LOGGER.info("Exception occurred while trying to apply license details : " + exp.getMessage());
            throw BaseStatusCode.getBaseStatusCode(8001);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean upgradeFromContent(ProductsAndComponents identity, String content) throws Exception {
        boolean result = false;
        LICENSELOCK.writeLock().lock();
        try {
            LicenseManager licenseManager = new LicenseManager(identity.getProductName(), content);
            if (!new File(licenseManager.getLicenseFileLocation()).exists()) {
                throw BaseStatusCode.getBaseStatusCode(8002);
            }
            result = LicenseActions.validateAndApply(licenseManager, 20L);
            if (result) {
                LicenseActions.takeLicenseBackUpUsingReflection();
            }
        }
        finally {
            LICENSELOCK.writeLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean upgradeFromMixedContent(ProductsAndComponents identity, String content) throws Exception {
        boolean result;
        block6: {
            result = false;
            LICENSELOCK.writeLock().lock();
            try {
                String licenseContent = LicenseActions.getLicenseFromMixedContent(identity, content);
                if (licenseContent != null) {
                    LOGGER.log(Level.INFO, "Log360 License : Ela License is available! Going to upgrade ELA");
                    LicenseManager licenseManager = new LicenseManager(identity.getProductName(), licenseContent);
                    if (!new File(licenseManager.getLicenseFileLocation()).exists()) {
                        throw BaseStatusCode.getBaseStatusCode(8002);
                    }
                    result = LicenseActions.validateAndApply(licenseManager, 20L);
                    if (result) {
                        LicenseActions.takeLicenseBackUpUsingReflection();
                    }
                    break block6;
                }
                LOGGER.log(Level.INFO, "Log360 License : ELA License is Not available!");
                throw BaseStatusCode.getBaseStatusCode(8001);
            }
            finally {
                LICENSELOCK.writeLock().unlock();
            }
        }
        return result;
    }

    public static void takeLicenseBackUpUsingReflection() {
        String mainHome = System.getProperty("server.dir");
        String licenseFileLocation = mainHome + File.separator + "lib" + File.separator + "AdventNetLicense.xml";
        try {
            Wield object = Wield.getInstance();
            Method dynamicMethod = object.getClass().getDeclaredMethod("copyLicenseFiles", String.class, String.class);
            dynamicMethod.setAccessible(true);
            dynamicMethod.invoke((Object)object, mainHome, licenseFileLocation);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Boolean validateAndApply(final LicenseManager licenseManager, long timeLimit) throws BaseStatusCode, Exception {
        return Executors.newSingleThreadExecutor().submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (!licenseManager.isValidateLicense()) {
                    LOGGER.log(Level.INFO, "ELA License : Invalid ELA License recived!");
                    throw BaseStatusCode.getBaseStatusCode(8001);
                }
                licenseManager.applyLicense();
                return Boolean.TRUE;
            }
        }).get(timeLimit, TimeUnit.SECONDS);
    }

    private static String getLicenseFromMixedContent(ProductsAndComponents identity, String content) throws Exception {
        LicenseManager licenseManager = new LicenseManager(identity.getProductName(), content);
        if (!new File(licenseManager.getLicenseFileLocation()).exists()) {
            throw BaseStatusCode.getBaseStatusCode(8002);
        }
        LicenseXMLParser xmlParser = new LicenseXMLParser(licenseManager.getLicenseFileLocation());
        if (!xmlParser.isComponentPresent(identity.getProductName())) {
            return null;
        }
        return xmlParser.getComponentLicense(identity.getProductName());
    }

    @Deprecated
    public static boolean upgradeLog360License(String licensePath) {
        boolean upgradeStatus = false;
        try {
            String productName = ProductsAndComponents.EVENTLOG_ANALYZER.getProductName();
            LicenseXMLParser xmlParser = new LicenseXMLParser(licensePath);
            if (xmlParser.isComponentPresent(productName)) {
                LOGGER.log(Level.INFO, "Log360 License : Log License is available! Going to upgrade ELA");
                String elaLicense = xmlParser.getComponentLicense(productName);
                LicenseManager licenseManager = new LicenseManager(productName, elaLicense);
                return LicenseActions.upgradeELALicense(licenseManager.getLicenseFileLocation());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Error while applying Log360 license : " + e.getMessage());
        }
        return upgradeStatus;
    }

    @Deprecated
    public static boolean upgradeELALicense(String licensePath) {
        return LicenseActions.upgradeUnsafeELALicense(licensePath);
    }

    @Deprecated
    private static boolean upgradeUnsafeELALicense(String licensePath) {
        Wield wield = Wield.getInstance();
        String productHome = System.getProperty("server.home");
        CMDClass cmd = new CMDClass();
        boolean success = false;
        Validation valid = Validation.getInstance();
        try {
            String user = (String)cmd.getUserList(licensePath).elementAt(0);
            LUtil.setISMP((boolean)true);
            success = wield.doValidation(productHome, user, licensePath, false, true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            success = false;
        }
        if (success) {
            valid.copyLicenseFile(productHome, licensePath);
            wield.validateInvoke("EventLog License", false);
            wield.reloadXmlFile();
            return true;
        }
        wield.validateInvoke("EventLog License");
        return false;
    }

    public static void postLicenseAction(final LicenseComponents.LicenseType oldtype, final LicenseComponents.LicenseType type, final LicenseComponents.LicenseCategory category) {
        if (ServerDetailsBean.getInstance().isAdminServer()) {
            try {
                SyncUtil.getInstance().reApplyLicense();
            }
            catch (EnterpriseException e) {
                e.printStackTrace();
            }
        }
        EAService.getInstance().resetLicense();
        if (InheritedHostHandler.publishLicenseStatus()) {
            HostDBHandler.synchronizeNow("License Upgrade", true);
        }
        CommonFixedThreadExecutor.getInstance().execute(new PriorityQueueFieldRunnable(Priority.HIGH){

            @Override
            public void run() {
                try {
                    Executors.newSingleThreadExecutor().submit(new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            LicenseActions.delayedLicensePostAction(oldtype, type, category);
                            return Boolean.TRUE;
                        }
                    }).get(10L, TimeUnit.SECONDS);
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                }
            }
        });
    }

    public static void delayedLicensePostAction(LicenseComponents.LicenseType oldtype, LicenseComponents.LicenseType type, LicenseComponents.LicenseCategory category) throws InterruptedException, ExecutionException, TimeoutException {
        if (LicenseComponents.LicenseType.TRIAL == oldtype && LicenseComponents.LicenseType.REGISTERED == type && LicenseComponents.LicenseCategory.PREMIUM == category) {
            SimpleDateFormat displayFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date today = new Date();
            String time_now = displayFormat.format(today.getTime());
            CommonUtil.updateSysConfiguration("CorrelationEngine_Time", time_now, true);
            CommonUtil.updateSysConfiguration("CorrelationEngine", "Off", true);
        }
        if (LicenseComponents.LicenseCategory.PREMIUM != category) {
            try {
                DataObject d = DataAccess.get((String)"UsertoSelGroupType", (Criteria)null);
                d.deleteRows("UsertoSelGroupType", (Criteria)null);
                DataAccess.update((DataObject)d);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static JSONObject collectLicenseDetails() {
        JSONObject license_cache = null;
        LICENSELOCK.readLock().lock();
        try {
            license_cache = LicenseManager.getLicenseDetails();
        }
        finally {
            LICENSELOCK.readLock().unlock();
        }
        return license_cache;
    }
}

