/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.license;

public final class LicenseComponents {

    public static enum LicenseCategory {
        PREMIUM,
        PROFESSIONAL,
        PROFESSIONALNG,
        FREEEDITION,
        TRIAL,
        UNKNOWN;


        public static LicenseCategory get(String type) {
            if (type == null) {
                return UNKNOWN;
            }
            switch (type) {
                case "Premium": {
                    return PREMIUM;
                }
                case "Trial License": 
                case "ads.header.tab_component.license.eval_edition": {
                    return TRIAL;
                }
                case "Free Edition": 
                case "ads.header.tab_component.license.free_edition": {
                    return FREEEDITION;
                }
                case "Professional-NG": {
                    return PROFESSIONALNG;
                }
                case "Professional": {
                    return PROFESSIONAL;
                }
            }
            return UNKNOWN;
        }

        public String getCategoryName() {
            switch (this) {
                case PREMIUM: {
                    return "Premium";
                }
                case TRIAL: {
                    return "ads.header.tab_component.license.eval_edition";
                }
                case FREEEDITION: {
                    return "ads.header.tab_component.license.free_edition";
                }
                case PROFESSIONALNG: {
                    return "Professional-NG";
                }
                case PROFESSIONAL: {
                    return "Professional";
                }
            }
            return "Unknown";
        }
    }

    public static enum LicenseType {
        FREE,
        TRIAL,
        EXTENDEDTRIAL,
        REGISTERED,
        UNKNOWN;


        public String getLicenseCode() {
            switch (this) {
                case TRIAL: {
                    return "T";
                }
                case FREE: {
                    return "F";
                }
                case REGISTERED: {
                    return "R";
                }
                case EXTENDEDTRIAL: {
                    return "ET";
                }
            }
            return "Unk";
        }

        public static LicenseType get(String licenseCode) {
            if (licenseCode == null) {
                return UNKNOWN;
            }
            switch (licenseCode) {
                case "T": {
                    return TRIAL;
                }
                case "F": {
                    return FREE;
                }
                case "R": {
                    return REGISTERED;
                }
            }
            return EXTENDEDTRIAL;
        }
    }
}

