/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.license;

import com.adventnet.la.util.ProductBundle;
import com.enterprisedt.util.debug.Logger;
import com.manageengine.ads.fw.util.CommonUtil;
import com.manageengine.ela.server.common.cache.ServerDetailsBean;
import com.manageengine.ela.server.common.delegation.info.UserAccessResource;
import com.manageengine.ela.server.common.device.LogSourceCategoryContainer;
import com.manageengine.ela.server.common.license.LicenseActions;
import com.manageengine.ela.server.common.license.LicenseComponents;
import com.manageengine.ela.server.common.license.LicenseUtil;
import com.manageengine.ela.server.common.license.ProductsAndComponents;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import java.util.Date;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LicenseHandler {
    private static LicenseHandler instance = null;
    private static final Logger LOGGER = Logger.getLogger((String)LicenseHandler.class.getName());
    private JSONObject license_cache = null;
    private long loadedTime = System.currentTimeMillis();
    private long timeOut = 86400000L;
    private static final LogSourceCategoryContainer.DeviceCategory[] NONCATEGORIZED_CONDN = new LogSourceCategoryContainer.DeviceCategory[]{LogSourceCategoryContainer.DeviceCategory.WINDOWS};

    private LicenseHandler() {
        this.initializeLicenseCache();
        LOGGER.info("License Manager Initialized");
    }

    public static synchronized LicenseHandler getInstance() {
        if (instance == null) {
            instance = new LicenseHandler();
        }
        return instance;
    }

    public boolean reLoadLicenseCache() {
        return this.initializeLicenseCache();
    }

    private boolean initializeLicenseCache() {
        this.license_cache = LicenseActions.collectLicenseDetails();
        return true;
    }

    public JSONObject getLicenseCache() {
        if (this.loadedTime + this.timeOut < System.currentTimeMillis()) {
            this.initializeLicenseCache();
            this.loadedTime = System.currentTimeMillis();
        }
        return this.license_cache;
    }

    public boolean upgradeLicenseContentNewFromat(String licenseContent) throws BaseStatusCode {
        return this.handleLicenseCache(LicenseActions.upgradeLicenseContentNewFromat(licenseContent));
    }

    public boolean upgradeLicenseContentOldFromat(String licenseContent) throws BaseStatusCode {
        return this.handleLicenseCache(LicenseActions.upgradeLicenseContentOldFromat(licenseContent));
    }

    public boolean upgradeLicenseContentLog360Fromat(String licenseContent) throws BaseStatusCode {
        return this.handleLicenseCache(LicenseActions.upgradeLicenseContentLog360Fromat(licenseContent));
    }

    @Deprecated
    public boolean applyLicense(String licensePath) {
        boolean status = this.applyELALicense(licensePath);
        if (!status) {
            return this.applyLog360License(licensePath);
        }
        return this.handleLicenseCache(status);
    }

    @Deprecated
    public boolean applyLog360License(String licensePath) {
        return this.handleLicenseCache(LicenseActions.upgradeLog360License(licensePath));
    }

    @Deprecated
    public boolean applyELALicense(String licensePath) {
        return this.handleLicenseCache(LicenseActions.upgradeELALicense(licensePath));
    }

    private boolean handleLicenseCache(boolean status) {
        if (status) {
            LicenseComponents.LicenseType oldType = this.getLicenseType();
            UserAccessResource.removeAllCache();
            this.initializeLicenseCache();
            try {
                LicenseActions.postLicenseAction(oldType, this.getLicenseType(), this.getLicenseCategory());
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        }
        return status;
    }

    public int getnoOfLogSources() throws JSONException {
        return LicenseUtil.getnoOfLogSources(this.getLicenseCache());
    }

    public int getnoOfConfiguredLogSources(boolean isApplicationIncluded) {
        if (isApplicationIncluded) {
            return LicenseUtil.getConfiguredSourceCount(0, new LogSourceCategoryContainer.DeviceCategory[0]) + this.getConfiguredApplications();
        }
        return LicenseUtil.getConfiguredSourceCount(0, new LogSourceCategoryContainer.DeviceCategory[0]);
    }

    public int getnoOfConfiguredELALogSources(boolean isApplicationIncluded) {
        if (isApplicationIncluded) {
            return LicenseUtil.getConfiguredSourceCount(2, new LogSourceCategoryContainer.DeviceCategory[0]) + this.getConfiguredApplications();
        }
        return LicenseUtil.getConfiguredSourceCount(2, new LogSourceCategoryContainer.DeviceCategory[0]);
    }

    public int getnoOfConfiguredNonELALogSources(boolean isApplicationIncluded) throws JSONException {
        if (isApplicationIncluded) {
            return LicenseUtil.getConfiguredSourceCount(1, new LogSourceCategoryContainer.DeviceCategory[0]) + this.getConfiguredApplications();
        }
        return LicenseUtil.getConfiguredSourceCount(1, new LogSourceCategoryContainer.DeviceCategory[0]);
    }

    public int getnoOfDevices() throws JSONException {
        return LicenseUtil.getnoOfDeviceFromLicense(this.getLicenseCache(), true);
    }

    public int getConfiguredDevices() {
        return LicenseUtil.getConfiguredDeviceSourceCount(0, true);
    }

    public int getConfiguredELADevices() {
        return LicenseUtil.getConfiguredDeviceSourceCount(2, true);
    }

    public int getConfiguredNonELADevices() {
        return LicenseUtil.getConfiguredDeviceSourceCount(1, true);
    }

    public int getnoOfDevicesExcludingAPP() throws JSONException {
        return LicenseUtil.getnoOfDeviceFromLicense(this.getLicenseCache(), false);
    }

    public int getConfiguredDevicesExcludingAPP() {
        return LicenseUtil.getConfiguredDeviceSourceCount(0, false);
    }

    public int getConfiguredELADevicesExcludingAPP() {
        return LicenseUtil.getConfiguredDeviceSourceCount(2, false);
    }

    public int getConfiguredNonELADevicesExcludingAPP() {
        return LicenseUtil.getConfiguredDeviceSourceCount(1, false);
    }

    public int getnoOfApplications() throws JSONException {
        return LicenseUtil.getnoOfApplications(this.getLicenseCache());
    }

    public int getConfiguredApplications() {
        LicenseUtil.TempLicenseVersion version = LicenseUtil.getLicenseVersion(this.getLicenseCache());
        if (version == LicenseUtil.TempLicenseVersion.VERSION7 || version == LicenseUtil.TempLicenseVersion.VERSION5) {
            return LicenseUtil.getConfiguredApplications() + LicenseUtil.getConfiguredAddons();
        }
        if (version == LicenseUtil.TempLicenseVersion.VERSION6) {
            return LicenseUtil.getConfiguredApplications() + LicenseUtil.getConfiguredAddons() + LicenseUtil.getConfiguredSQLApplications();
        }
        return LicenseUtil.getConfiguredApplications() + LicenseUtil.getConfiguredIISApplications() / 2 + LicenseUtil.getConfiguredSQLApplications();
    }

    public int getnoOfSQLServer() throws JSONException {
        return LicenseUtil.getnoOfSQLServers(this.getLicenseCache());
    }

    public int getConfiguredSQLServers() {
        LicenseUtil.TempLicenseVersion version = LicenseUtil.getLicenseVersion(this.getLicenseCache());
        if (version == LicenseUtil.TempLicenseVersion.VERSION7 || version == LicenseUtil.TempLicenseVersion.VERSION5) {
            return LicenseUtil.getConfiguredSQLServers();
        }
        return 0;
    }

    public int getnoOfSites() throws JSONException {
        return LicenseUtil.getnoOfSites(this.getLicenseCache());
    }

    public int getConfiguredSites() {
        LicenseUtil.TempLicenseVersion version = LicenseUtil.getLicenseVersion(this.getLicenseCache());
        if (version == LicenseUtil.TempLicenseVersion.VERSION7 || version == LicenseUtil.TempLicenseVersion.VERSION6 || version == LicenseUtil.TempLicenseVersion.VERSION5) {
            return LicenseUtil.getConfiguredSites();
        }
        return 0;
    }

    public int getnoOfWindowsServerDevices() throws JSONException {
        return LicenseUtil.getnoOfWindowsServerDevices(this.getLicenseCache());
    }

    public int getConfiguredWindowsServerDevices() {
        return LicenseUtil.getConfiguredWindowsServers(0);
    }

    public int getConfiguredELAWindowsServerDevices() {
        return LicenseUtil.getConfiguredWindowsServers(2);
    }

    public int getConfiguredNonELAWindowsServerDevices() {
        return LicenseUtil.getConfiguredWindowsServers(1);
    }

    public int getnoOfWindowsServerDevicesForADAP() throws JSONException {
        LicenseComponents.LicenseCategory category = this.getLicenseCategory();
        if (category == LicenseComponents.LicenseCategory.TRIAL) {
            return Integer.MAX_VALUE;
        }
        if (category == LicenseComponents.LicenseCategory.FREEEDITION) {
            return 5;
        }
        return this.getnoOfWindowsServerDevices();
    }

    public int getnoOfWindowsWorkstationDevicesForADAP() throws JSONException {
        LicenseComponents.LicenseCategory category = this.getLicenseCategory();
        if (category == LicenseComponents.LicenseCategory.TRIAL) {
            return Integer.MAX_VALUE;
        }
        if (category == LicenseComponents.LicenseCategory.FREEEDITION) {
            return 5;
        }
        return this.getnoOfWindowsWorkstations();
    }

    public int getnoOfWindowsWorkstations() throws JSONException {
        return LicenseUtil.getnoOfWindowsWorkstations(this.getLicenseCache());
    }

    public int getConfiguredWindowsWorkstations() {
        return LicenseUtil.getConfigureWindowsWorkstations(0);
    }

    public int getConfiguredELAWindowsWorkstations() {
        return LicenseUtil.getConfigureWindowsWorkstations(2);
    }

    public int getConfiguredNonELAWindowsWorkstations() {
        return LicenseUtil.getConfigureWindowsWorkstations(1);
    }

    public int getnoOfNonCategorizedDevices() throws JSONException {
        return LicenseUtil.getnoOfNonCategorizedDevices(this.getLicenseCache());
    }

    public int getConfiguredNonCategorizedDevices() {
        return LicenseUtil.getConfiguredSourceCount_reverse(0, NONCATEGORIZED_CONDN);
    }

    public int getConfiguredNonCategorizedELADevices() {
        return LicenseUtil.getConfiguredSourceCount_reverse(2, NONCATEGORIZED_CONDN);
    }

    public int getConfiguredNonCategorizedNonELADevices() {
        return LicenseUtil.getConfiguredSourceCount_reverse(1, NONCATEGORIZED_CONDN);
    }

    public int getTotalLicensesForOldCheck() {
        try {
            return this.getnoOfLogSources();
        }
        catch (JSONException e) {
            e.printStackTrace();
            return Integer.MAX_VALUE;
        }
    }

    public int getTotalConfiguredELADevice() {
        return this.getnoOfConfiguredELALogSources(false);
    }

    public int getTotalConfiguredNonELADevices() {
        return this.getConfiguredSyncedDevice();
    }

    public int getTotalConfiguredWorksStationELADevice() {
        return this.getConfiguredELAWindowsWorkstations();
    }

    public int getTotalConfiguredELAApplicationDevice() {
        return this.getConfiguredApplications();
    }

    public int getConfiguredWindowsDevices() {
        return LicenseUtil.getConfiguredSourceCount(0, LogSourceCategoryContainer.DeviceCategory.WINDOWS);
    }

    public int getConfiguredELAWindowsDevices() {
        return LicenseUtil.getConfiguredSourceCount(2, LogSourceCategoryContainer.DeviceCategory.WINDOWS);
    }

    public int getConfiguredNonELAWindowsDevices() {
        return LicenseUtil.getConfiguredSourceCount(1, LogSourceCategoryContainer.DeviceCategory.WINDOWS);
    }

    public int getConfiguredSyncedDevice() {
        return LicenseUtil.getConfiguredSourceCount(1, new LogSourceCategoryContainer.DeviceCategory[0]);
    }

    public int getConfiguredUnknownDevices() {
        return LicenseUtil.getConfiguredSourceCount(0, LogSourceCategoryContainer.DeviceCategory.UNKNOWN);
    }

    public LicenseComponents.LicenseType getLicenseType() {
        return LicenseComponents.LicenseType.get(LicenseUtil.getLicenseType(this.getLicenseCache()));
    }

    public LicenseComponents.LicenseCategory getLicenseCategory() {
        return LicenseComponents.LicenseCategory.get(LicenseUtil.getLicenseCategory(this.getLicenseCache()));
    }

    public String getLicensedCompany() throws JSONException {
        return LicenseUtil.getCompanyName(this.getLicenseCache());
    }

    public Date getExpiryDate() throws JSONException {
        return LicenseUtil.getLicenseExpiryDate(this.getLicenseCache());
    }

    public String getExpiryDateString() throws JSONException {
        return LicenseUtil.getLicenseExpiryDateString(this.getLicenseCache());
    }

    public Date getAMSExpiryDate() throws JSONException {
        return LicenseUtil.getAMSExpiryDate(this.getLicenseCache());
    }

    public String getAMSExpiryDateString() throws JSONException {
        return LicenseUtil.getAMSExpiryDateString(this.getLicenseCache());
    }

    public int getRemainingDays() throws JSONException {
        String expiryDate = this.getExpiryDateString();
        if (expiryDate != null && expiryDate.equalsIgnoreCase("never")) {
            return 365;
        }
        String days = LicenseUtil.getNumberOfDays(this.getLicenseCache());
        if (days == null) {
            return -1;
        }
        return Integer.valueOf(days);
    }

    public boolean isADServerReportsEnabled() throws JSONException {
        return LicenseUtil.isADReportsEnabled(this.getLicenseCache());
    }

    public JSONObject getFormatedLicenseDetails(Locale locale) {
        JSONObject licenseDetails = new JSONObject();
        ProductBundle bundle = ProductBundle.getInstance();
        LicenseUtil.TempLicenseVersion version = LicenseUtil.getLicenseVersion(this.getLicenseCache());
        try {
            LicenseComponents.LicenseCategory license = this.getLicenseCategory();
            JSONArray array = new JSONArray();
            if (license == LicenseComponents.LicenseCategory.TRIAL) {
                array.put((Object)this.getWindowsServerProperty(bundle, locale, true));
                array.put((Object)this.getNewFormattedDeviceProperty(bundle, locale, true));
                array.put((Object)this.getApplicationDetailsProperty(bundle, locale, true));
                array.put((Object)this.getWindowsWorkstationProperty(bundle, locale, true));
                array.put((Object)this.getSiteDetailsProperty(bundle, locale, true));
                array.put((Object)this.getSQLDetailsProperty(bundle, locale, true));
            } else if (license == LicenseComponents.LicenseCategory.FREEEDITION) {
                array.put((Object)this.getLogSourceProperty(bundle, locale, true));
            } else {
                switch (version) {
                    case VERSION1: {
                        array.put((Object)this.getLogSourceProperty(bundle, locale, false));
                        break;
                    }
                    case VERSION2: {
                        array.put((Object)this.getDeviceProperty(bundle, locale, false));
                        array.put((Object)this.getWindowsWorkstationProperty(bundle, locale, false));
                        break;
                    }
                    case VERSION3: {
                        array.put((Object)this.getDeviceProperty(bundle, locale, true));
                        array.put((Object)this.getApplicationDetailsProperty(bundle, locale, false));
                        array.put((Object)this.getWindowsWorkstationProperty(bundle, locale, false));
                        break;
                    }
                    case VERSION4: {
                        array.put((Object)this.getWindowsServerProperty(bundle, locale, false));
                        array.put((Object)this.getNewFormattedDeviceProperty(bundle, locale, false));
                        array.put((Object)this.getApplicationDetailsProperty(bundle, locale, false));
                        array.put((Object)this.getWindowsWorkstationProperty(bundle, locale, false));
                        break;
                    }
                    case VERSION5: {
                        array.put((Object)this.getWindowsServerProperty(bundle, locale, true));
                        array.put((Object)this.getNewFormattedDeviceProperty(bundle, locale, true));
                        array.put((Object)this.getApplicationDetailsProperty(bundle, locale, true));
                        array.put((Object)this.getWindowsWorkstationProperty(bundle, locale, true));
                        array.put((Object)this.getSiteDetailsProperty(bundle, locale, true));
                        array.put((Object)this.getSQLDetailsProperty(bundle, locale, true));
                        array.put((Object)this.getLogSourceProperty(bundle, locale, false));
                        break;
                    }
                    case VERSION6: {
                        array.put((Object)this.getWindowsServerProperty(bundle, locale, false));
                        array.put((Object)this.getNewFormattedDeviceProperty(bundle, locale, false));
                        array.put((Object)this.getApplicationDetailsProperty(bundle, locale, false));
                        array.put((Object)this.getWindowsWorkstationProperty(bundle, locale, false));
                        array.put((Object)this.getSiteDetailsProperty(bundle, locale, false));
                        array.put((Object)this.getLogSourceProperty(bundle, locale, false));
                        break;
                    }
                    case VERSION7: {
                        array.put((Object)this.getWindowsServerProperty(bundle, locale, false));
                        array.put((Object)this.getNewFormattedDeviceProperty(bundle, locale, false));
                        array.put((Object)this.getApplicationDetailsProperty(bundle, locale, false));
                        array.put((Object)this.getWindowsWorkstationProperty(bundle, locale, false));
                        array.put((Object)this.getSiteDetailsProperty(bundle, locale, false));
                        array.put((Object)this.getSQLDetailsProperty(bundle, locale, false));
                        array.put((Object)this.getLogSourceProperty(bundle, locale, false));
                        break;
                    }
                    default: {
                        array.put((Object)this.getLogSourceProperty(bundle, locale, false));
                    }
                }
            }
            licenseDetails.put("COMPONENTS", (Object)array);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        try {
            ServerDetailsBean bean = ServerDetailsBean.getInstance();
            LicenseComponents.LicenseCategory category = this.getLicenseCategory();
            licenseDetails.put("TYPE", (Object)bundle.getString(locale, category.getCategoryName()));
            licenseDetails.put("LICENSED_TO", (Object)this.getLicensedCompany());
            String expiryDate = this.getExpiryDateString();
            if (LicenseComponents.LicenseCategory.FREEEDITION == category) {
                licenseDetails.put("EXPIRY_DATE", (Object)"never");
            } else {
                if (expiryDate != null && expiryDate.equalsIgnoreCase("NEVER")) {
                    licenseDetails.put("AMS_EXPIRY_DATE", (Object)this.getAMSExpiryDateString());
                }
                licenseDetails.put("EXPIRY_DATE", (Object)expiryDate);
                licenseDetails.put("REMAININGDAYS", this.getRemainingDays());
            }
            licenseDetails.put("PRODUCT_NAME", (Object)bean.getProductName());
            licenseDetails.put("PRODUCT_VERSION", (Object)bean.getProductVersion());
            licenseDetails.put("PRODUCT_BUILD_NUMBER", (Object)bean.getProductbuildNumber());
            licenseDetails.put("ISADAPALLOWED", CommonUtil.isProductIntegrated((String)ProductsAndComponents.LOG360.getProductName()));
            licenseDetails.put("ISCXDETAILSALLOWED", LicenseComponents.LicenseCategory.FREEEDITION != category && category != LicenseComponents.LicenseCategory.TRIAL);
            licenseDetails.put("ISLIMITALLOWED", LicenseComponents.LicenseCategory.TRIAL != category && version != LicenseUtil.TempLicenseVersion.VERSION5);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return licenseDetails;
    }

    private JSONObject getLogSourceProperty(ProductBundle bundle, Locale locale, boolean isFree) {
        JSONObject details = new JSONObject();
        try {
            details.put("TEXT", (Object)bundle.getString(locale, "ela.statuscode.displaytext.license.component.count.logsources"));
            if (isFree) {
                details.put("PURCHASED", LicenseUtil.getFreeEditionLogsource());
            } else {
                details.put("PURCHASED", this.getnoOfLogSources());
            }
            details.put("INUSE", this.getnoOfConfiguredELALogSources(false) + this.getConfiguredApplications() + this.getConfiguredSites() + this.getConfiguredSQLServers());
            details.put("ADAP", this.getnoOfConfiguredNonELALogSources(false));
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return details;
    }

    private JSONObject getDeviceProperty(ProductBundle bundle, Locale locale, boolean isExcludingAPP) {
        JSONObject details = new JSONObject();
        try {
            details.put("TEXT", (Object)bundle.getString(locale, "ela.statuscode.displaytext.license.component.count.devices"));
            if (isExcludingAPP) {
                details.put("PURCHASED", this.getnoOfDevicesExcludingAPP());
                details.put("INUSE", this.getConfiguredELADevicesExcludingAPP());
                details.put("ADAP", this.getConfiguredNonELADevicesExcludingAPP());
            } else {
                details.put("PURCHASED", this.getnoOfDevices());
                details.put("INUSE", this.getConfiguredELADevices());
                details.put("ADAP", this.getConfiguredNonELADevicesExcludingAPP());
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return details;
    }

    private JSONObject getNewFormattedDeviceProperty(ProductBundle bundle, Locale locale, boolean isUnlimited) {
        JSONObject details = new JSONObject();
        try {
            details.put("TEXT", (Object)bundle.getString(locale, "ela.statuscode.displaytext.license.component.count.devices"));
            if (isUnlimited) {
                details.put("PURCHASED", Integer.MAX_VALUE);
            } else {
                details.put("PURCHASED", this.getnoOfNonCategorizedDevices());
            }
            details.put("INUSE", this.getConfiguredNonCategorizedELADevices());
            details.put("ADAP", this.getConfiguredNonCategorizedNonELADevices());
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return details;
    }

    private JSONObject getWindowsServerProperty(ProductBundle bundle, Locale locale, boolean isUnlimited) {
        JSONObject details = new JSONObject();
        try {
            details.put("TEXT", (Object)bundle.getString(locale, "ela.statuscode.displaytext.license.component.count.windowsservers"));
            if (isUnlimited) {
                details.put("PURCHASED", Integer.MAX_VALUE);
            } else {
                details.put("PURCHASED", this.getnoOfWindowsServerDevices());
            }
            details.put("INUSE", this.getConfiguredELAWindowsServerDevices());
            details.put("ADAP", this.getConfiguredNonELAWindowsServerDevices());
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return details;
    }

    private JSONObject getApplicationDetailsProperty(ProductBundle bundle, Locale locale, boolean isUnlimited) {
        JSONObject details = new JSONObject();
        try {
            details.put("TEXT", (Object)bundle.getString(locale, "ela.statuscode.displaytext.license.component.count.applications"));
            if (isUnlimited) {
                details.put("PURCHASED", Integer.MAX_VALUE);
            } else {
                details.put("PURCHASED", this.getnoOfApplications());
            }
            details.put("INUSE", this.getConfiguredApplications());
            details.put("ADAP", (Object)0);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return details;
    }

    private JSONObject getSQLDetailsProperty(ProductBundle bundle, Locale locale, boolean isUnlimited) {
        JSONObject details = new JSONObject();
        try {
            details.put("TEXT", (Object)bundle.getString(locale, "ela.statuscode.displaytext.license.component.count.sql.servers"));
            if (isUnlimited) {
                details.put("PURCHASED", Integer.MAX_VALUE);
            } else {
                details.put("PURCHASED", this.getnoOfSQLServer());
            }
            details.put("INUSE", this.getConfiguredSQLServers());
            details.put("ADAP", (Object)0);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return details;
    }

    private JSONObject getSiteDetailsProperty(ProductBundle bundle, Locale locale, boolean isUnlimited) {
        JSONObject details = new JSONObject();
        try {
            details.put("TEXT", (Object)bundle.getString(locale, "ela.statuscode.displaytext.license.component.count.iis.sites"));
            if (isUnlimited) {
                details.put("PURCHASED", Integer.MAX_VALUE);
            } else {
                details.put("PURCHASED", this.getnoOfSites());
            }
            details.put("INUSE", this.getConfiguredSites());
            details.put("ADAP", (Object)0);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return details;
    }

    private JSONObject getWindowsWorkstationProperty(ProductBundle bundle, Locale locale, boolean isUnlimited) {
        JSONObject details = new JSONObject();
        try {
            details.put("TEXT", (Object)bundle.getString(locale, "ela.statuscode.displaytext.license.component.count.windowsworkstations"));
            if (isUnlimited) {
                details.put("PURCHASED", Integer.MAX_VALUE);
            } else {
                details.put("PURCHASED", this.getnoOfWindowsWorkstations());
            }
            details.put("INUSE", this.getConfiguredELAWindowsWorkstations());
            details.put("ADAP", this.getConfiguredNonELAWindowsWorkstations());
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return details;
    }
}

