/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.license;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.sa.server.util.DBUtil;
import com.manageengine.ela.server.common.device.LogSourceCategoryContainer;
import com.manageengine.ela.server.common.license.LicenseHandler;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

final class LicenseUtil {
    public static final int MAX_LOGSOURCE = Integer.MAX_VALUE;
    public static final int MAX_WINDOWS_SERVER_TRIAL = Integer.MAX_VALUE;
    public static final int MAX_WINDOWS_WORKSTATION_TRIAL = Integer.MAX_VALUE;
    public static final int MAX_SYSLOG_DEVICE_TRIAL = Integer.MAX_VALUE;
    public static final int MAX_APPLICATION_TRIAL = Integer.MAX_VALUE;
    public static final int MAX_FREE_LOGSOURCE = 5;
    public static final int SYNCEDDEVICE = 1;
    public static final int NONSYNCEDDEVICE = 2;
    public static final int ALL_DEVICE = 0;
    private static final String[] LICENSE_DEVICEKEYS = new String[]{"NA"};
    private static final String LICENSE_CONFIGURATION_KEY = "ELAConfigurations";
    private static final String LICENSE_AMS_KEY = "AMS";
    private static final String LICENSE_AMS_EXPIRYDATE_KEY = "Expiry";
    private static final String LICENSEWORKSTATION_COUNTKEY = "NumberOfWorkStations";
    private static final String LICENSE_WINDOWSSERVER_COUNTKEY = "NumberOfServers";
    private static final String LICENSE_SYSLOGSERVER_COUNTKEY = "NumberOfSyslogDevices";
    private static final String LICENSE_APPLICATION_COUNTKEY = "NumberOfApplications";
    private static final String DEFAULTLICENSEDEVICEKEY = "NumberOfHosts";
    private static final String LICENSE_SITE_COUNTKEY = "NumberOfIISSites";
    private static final String LICENSE_SQLSERVERS_COUNTKEY = "NumberOfSQLServers";
    private static final String IIS_WEB_FORMAT = "iis_w3cweb";
    private static final String IIS_FTP_FORMAT = "iis_w3cftp";
    private static final String MSSQL = "MSSQL";
    private static final Long IMPORT_DISABLED = 12193L;
    private static final String AD_REPORTS_STATUSKEY = "showServerReports";
    private static final Logger LOGGER = Logger.getLogger(LicenseUtil.class.getName());

    LicenseUtil() {
    }

    public static int getFreeEditionLogsource() {
        return 5;
    }

    public static TempLicenseVersion getLicenseVersion(JSONObject licenseDetails) {
        try {
            JSONObject components = licenseDetails.getJSONObject("COMPONENT_DETAILS");
            String[] stringArray = LICENSE_DEVICEKEYS;
            int n = stringArray.length;
            int n2 = 0;
            if (n2 < n) {
                String element = stringArray[n2];
                JSONObject jsonObj = new JSONObject(components.getString(element));
                if (!jsonObj.isNull(DEFAULTLICENSEDEVICEKEY) && jsonObj.getString(DEFAULTLICENSEDEVICEKEY).equalsIgnoreCase("unlimited")) {
                    return TempLicenseVersion.VERSION5;
                }
                if (!jsonObj.isNull(LICENSE_SQLSERVERS_COUNTKEY)) {
                    return TempLicenseVersion.VERSION7;
                }
                if (!jsonObj.isNull(LICENSE_SITE_COUNTKEY)) {
                    return TempLicenseVersion.VERSION6;
                }
                if (!jsonObj.isNull(LICENSE_SYSLOGSERVER_COUNTKEY)) {
                    return TempLicenseVersion.VERSION4;
                }
                if (!jsonObj.isNull(LICENSE_APPLICATION_COUNTKEY)) {
                    return TempLicenseVersion.VERSION3;
                }
                if (!jsonObj.isNull(LICENSE_WINDOWSSERVER_COUNTKEY)) {
                    return TempLicenseVersion.VERSION2;
                }
                return TempLicenseVersion.VERSION1;
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return TempLicenseVersion.VERSION1;
    }

    private static boolean isVersion7AboveOrFreeVersionCheck() {
        TempLicenseVersion currVersion = LicenseUtil.getLicenseVersion(LicenseHandler.getInstance().getLicenseCache());
        return TempLicenseVersion.isLicenseGreater(currVersion, TempLicenseVersion.VERSION7) || currVersion == TempLicenseVersion.VERSION5;
    }

    private static int getApplicationCountForLicense() {
        TempLicenseVersion currVersion = LicenseUtil.getLicenseVersion(LicenseHandler.getInstance().getLicenseCache());
        int deviceTotalCount = 0;
        deviceTotalCount = TempLicenseVersion.isLicenseGreater(currVersion, TempLicenseVersion.VERSION7) || currVersion == TempLicenseVersion.VERSION5 ? (deviceTotalCount += LicenseUtil.getConfiguredSQLServers() + LicenseUtil.getConfiguredSites()) : (TempLicenseVersion.isLicenseGreater(currVersion, TempLicenseVersion.VERSION6) ? (deviceTotalCount += LicenseUtil.getConfiguredSites() + LicenseUtil.getConfiguredSQLApplications()) : (deviceTotalCount += LicenseUtil.getConfiguredIISApplications() / 2 + LicenseUtil.getConfiguredSQLApplications()));
        return deviceTotalCount;
    }

    public static int getDevicesRunningSQLServers(Criteria crit) {
        int count = 0;
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"AppResources"));
            sq.addJoin(new Join("AppResources", "HostDetails", new String[]{"HOSTID"}, new String[]{"HOST_ID"}, 1));
            sq.addJoin(new Join("AppResources", "SQLServerDetails", new String[]{"APPID"}, new String[]{"APPID"}, 1));
            sq.addSelectColumn(Column.getColumn((String)"AppResources", (String)"APPID").distinct().count());
            Criteria enabledCriteria = new Criteria(Column.getColumn((String)"SQLServerDetails", (String)"IS_ENABLED"), (Object)true, 0);
            if (crit != null) {
                enabledCriteria = crit.and(enabledCriteria);
            }
            sq.setCriteria(enabledCriteria);
            count = LicenseUtil.getValidCount(DBUtil.getTotalIntCountNonMickey((SelectQuery)sq));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return count;
    }

    public static int getnoOfLogSources(JSONObject licenseDetails) throws JSONException {
        int count = LicenseUtil.findDeviceCount(licenseDetails, LICENSE_WINDOWSSERVER_COUNTKEY, LICENSEWORKSTATION_COUNTKEY, LICENSE_SYSLOGSERVER_COUNTKEY, LICENSE_APPLICATION_COUNTKEY, LICENSE_SITE_COUNTKEY);
        if (count == 0) {
            count = LicenseUtil.findDeviceCount(licenseDetails, DEFAULTLICENSEDEVICEKEY);
        }
        return count;
    }

    public static int getnoOfDeviceFromLicense(JSONObject licenseDetails, boolean isAppincluded) throws JSONException {
        if (isAppincluded) {
            return LicenseUtil.findDeviceCount(licenseDetails, LICENSE_WINDOWSSERVER_COUNTKEY, LICENSE_SYSLOGSERVER_COUNTKEY, LICENSE_APPLICATION_COUNTKEY);
        }
        return LicenseUtil.findDeviceCount(licenseDetails, LICENSE_WINDOWSSERVER_COUNTKEY, LICENSE_SYSLOGSERVER_COUNTKEY);
    }

    public static int getConfiguredDeviceSourceCount(int requestType, boolean isAppincluded) {
        Criteria criteria = new Criteria(Column.getColumn((String)"HostDetails", (String)"SUBTYPE"), (Object)"*WKS*", 3);
        criteria = criteria.or(new Criteria(Column.getColumn((String)"HostDetails", (String)"SUBTYPE"), null, 0));
        int deviceTotalCount = 0;
        if (isAppincluded) {
            criteria = LicenseUtil.addCriteriaBasedOnRequest(requestType, criteria);
            deviceTotalCount = LicenseUtil.getValidCount(DBUtil.getCountInt("HostDetails", criteria)) + LicenseUtil.getConfiguredApplications();
            if (LicenseUtil.isVersion7AboveOrFreeVersionCheck()) {
                deviceTotalCount -= LicenseUtil.getValidCount(LicenseUtil.getDevicesRunningSQLServers(criteria));
            }
            deviceTotalCount += LicenseUtil.getApplicationCountForLicense();
        } else {
            deviceTotalCount = LicenseUtil.getValidCount(DBUtil.getCountInt("HostDetails", LicenseUtil.addCriteriaBasedOnRequest(requestType, criteria)));
        }
        return deviceTotalCount;
    }

    public static int getnoOfApplications(JSONObject licenseDetails) throws JSONException {
        return LicenseUtil.findDeviceCount(licenseDetails, LICENSE_APPLICATION_COUNTKEY);
    }

    public static int getConfiguredApplications() {
        Criteria notInCriteria = new Criteria(Column.getColumn((String)"AppResources", (String)"FGROUP"), (Object)new String[]{IIS_WEB_FORMAT, IIS_FTP_FORMAT, MSSQL}, 9);
        return LicenseUtil.getValidCount(DBUtil.getCountInt("AppResources", notInCriteria));
    }

    public static int getConfiguredAddons() {
        return LicenseUtil.getValidCount(DBUtil.getCountInt("AddOnHosts", null)) + LicenseUtil.getValidCount(DBUtil.getCountInt("SyslogAddons", null)) + LicenseUtil.getValidCount(DBUtil.getCountInt("VulnAppDetails", null));
    }

    public static int getConfiguredIISApplications() {
        Criteria iisCriteria = new Criteria(Column.getColumn((String)"AppResources", (String)"FGROUP"), (Object)new String[]{IIS_WEB_FORMAT, IIS_FTP_FORMAT}, 8);
        return LicenseUtil.getValidCount(DBUtil.getCountInt("AppResources", iisCriteria));
    }

    public static int getnoOfSites(JSONObject licenseDetails) throws JSONException {
        return LicenseUtil.findDeviceCount(licenseDetails, LICENSE_SITE_COUNTKEY);
    }

    public static int getConfiguredSites() {
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"ELAImportLogConfigurations"));
        selectQuery.addJoin(new Join("ELAImportLogConfigurations", "Parser_LogFormats", new String[]{"FORMAT_LOCALE_MAP_ID"}, new String[]{"FORMAT_ID"}, 2));
        selectQuery.addSelectColumn(Column.getColumn((String)"ELAImportLogConfigurations", (String)"*"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Parser_LogFormats", (String)"*"));
        selectQuery.setCriteria(new Criteria(Column.getColumn((String)"ELAImportLogConfigurations", (String)"IMPORT_STATUS"), (Object)IMPORT_DISABLED, 1).and(new Criteria(Column.getColumn((String)"Parser_LogFormats", (String)"FORMAT_NAME"), (Object)new String[]{IIS_WEB_FORMAT, IIS_FTP_FORMAT}, 8)));
        Criteria criteria = new Criteria(Column.getColumn((String)"IISConfiguredSites", (String)"STATUS"), (Object)true, 0);
        return LicenseUtil.getValidCount(DBUtil.getCountInt("IISConfiguredSites", criteria)) + LicenseUtil.getValidCount(DBUtil.getTotalIntCount((SelectQuery)selectQuery));
    }

    public static int getConfiguredSQLApplications() {
        Criteria sqlCriteria = new Criteria(Column.getColumn((String)"AppResources", (String)"FGROUP"), (Object)new String[]{MSSQL}, 8);
        return LicenseUtil.getValidCount(DBUtil.getCountInt("AppResources", sqlCriteria));
    }

    public static int getnoOfSQLServers(JSONObject licenseDetails) throws JSONException {
        return LicenseUtil.findDeviceCount(licenseDetails, LICENSE_SQLSERVERS_COUNTKEY);
    }

    public static int getConfiguredSQLServers() {
        SelectQueryImpl sql = new SelectQueryImpl(Table.getTable((String)"AppResources"));
        sql.addJoin(new Join("AppResources", "SQLServerDetails", new String[]{"APPID"}, new String[]{"APPID"}, 1));
        sql.addSelectColumn(Column.getColumn((String)"AppResources", (String)"APPID").distinct().count());
        sql.setCriteria(new Criteria(Column.getColumn((String)"SQLServerDetails", (String)"IS_ENABLED"), (Object)true, 0));
        return LicenseUtil.getValidCount(DBUtil.getTotalIntCountNonMickey((SelectQuery)sql));
    }

    public static int getnoOfWindowsServerDevices(JSONObject licenseDetails) throws JSONException {
        return LicenseUtil.findDeviceCount(licenseDetails, LICENSE_WINDOWSSERVER_COUNTKEY);
    }

    public static int getConfiguredWindowsServers(int requestType) {
        Criteria criteria = new Criteria(Column.getColumn((String)"HostDetails", (String)"TYPE"), (Object)LogSourceCategoryContainer.DeviceCategory.WINDOWS.getCategoryName(), 0);
        Criteria type = new Criteria(Column.getColumn((String)"HostDetails", (String)"SUBTYPE"), (Object)"*WKS*", 3);
        type = type.or(new Criteria(Column.getColumn((String)"HostDetails", (String)"SUBTYPE"), null, 0));
        criteria = LicenseUtil.addCriteriaBasedOnRequest(requestType, criteria.and(type));
        int deviceCount = LicenseUtil.getValidCount(DBUtil.getCountInt("HostDetails", criteria));
        if (LicenseUtil.isVersion7AboveOrFreeVersionCheck()) {
            deviceCount -= LicenseUtil.getValidCount(LicenseUtil.getDevicesRunningSQLServers(criteria));
        }
        return deviceCount;
    }

    public static int getnoOfWindowsWorkstations(JSONObject licenseDetails) throws JSONException {
        return LicenseUtil.findDeviceCount(licenseDetails, LICENSEWORKSTATION_COUNTKEY);
    }

    public static int getConfigureWindowsWorkstations(int requestType) {
        Criteria criteria = new Criteria(Column.getColumn((String)"HostDetails", (String)"TYPE"), (Object)LogSourceCategoryContainer.DeviceCategory.WINDOWS.getCategoryName(), 0);
        criteria = criteria.and(new Criteria(Column.getColumn((String)"HostDetails", (String)"SUBTYPE"), (Object)"*WKS*", 2));
        criteria = LicenseUtil.addCriteriaBasedOnRequest(requestType, criteria);
        int deviceCount = LicenseUtil.getValidCount(DBUtil.getCountInt("HostDetails", criteria));
        if (LicenseUtil.isVersion7AboveOrFreeVersionCheck()) {
            deviceCount -= LicenseUtil.getValidCount(LicenseUtil.getDevicesRunningSQLServers(criteria));
        }
        return deviceCount;
    }

    public static int getnoOfNonCategorizedDevices(JSONObject licenseDetails) throws JSONException {
        return LicenseUtil.findDeviceCount(licenseDetails, LICENSE_SYSLOGSERVER_COUNTKEY);
    }

    public static int getConfiguredSourceCount(int requestType, LogSourceCategoryContainer.DeviceCategory ... types) {
        return LicenseUtil.getConfiguredSourceCount(requestType, 8, types);
    }

    public static int getConfiguredSourceCount_reverse(int requestType, LogSourceCategoryContainer.DeviceCategory ... types) {
        return LicenseUtil.getConfiguredSourceCount(requestType, 9, types);
    }

    private static int getConfiguredSourceCount(int requestType, int codn, LogSourceCategoryContainer.DeviceCategory ... types) {
        Criteria criteria = null;
        if (types != null && types.length > 0) {
            String[] typeString = new String[types.length];
            for (int index = 0; index < types.length; ++index) {
                typeString[index] = types[index].getCategoryName();
            }
            criteria = new Criteria(Column.getColumn((String)"HostDetails", (String)"TYPE"), (Object)typeString, codn);
        }
        criteria = LicenseUtil.addCriteriaBasedOnRequest(requestType, criteria);
        int deviceCount = LicenseUtil.getValidCount(DBUtil.getCountInt("HostDetails", criteria));
        if (LicenseUtil.isVersion7AboveOrFreeVersionCheck()) {
            deviceCount -= LicenseUtil.getValidCount(LicenseUtil.getDevicesRunningSQLServers(criteria));
        }
        return deviceCount;
    }

    private static int findDeviceCount(JSONObject licenseDetails, String ... keyList) throws JSONException {
        JSONObject components = licenseDetails.getJSONObject("COMPONENT_DETAILS");
        Integer deviceCount = 0;
        for (int index = 0; index < LICENSE_DEVICEKEYS.length; ++index) {
            deviceCount = deviceCount + LicenseUtil.getChildComponentCount(components, LICENSE_DEVICEKEYS[index], keyList);
        }
        return deviceCount;
    }

    private static int getChildComponentCount(JSONObject obj, String compKey, String[] countKeys) throws JSONException {
        int device_count = 0;
        try {
            if (obj.has(compKey)) {
                JSONObject jsonObj = new JSONObject(obj.getString(compKey));
                for (String key : countKeys) {
                    if (jsonObj.isNull(key)) continue;
                    if (jsonObj.getString(key).equalsIgnoreCase("unlimited")) {
                        device_count += Integer.MAX_VALUE;
                        continue;
                    }
                    device_count += jsonObj.getInt(key);
                }
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return device_count;
    }

    private static Criteria addCriteriaBasedOnRequest(int requestType, Criteria parentCriteria) {
        Criteria criteria = new Criteria(Column.getColumn((String)"HostDetails", (String)"TYPE"), (Object)LogSourceCategoryContainer.DeviceCategory.UNKNOWN.getCategoryName(), 1);
        criteria = criteria.and(new Criteria(Column.getColumn((String)"HostDetails", (String)"LOG_COLLECTION_STATUS"), (Object)0, 1));
        criteria = criteria.and(new Criteria(Column.getColumn((String)"HostDetails", (String)"TYPE"), (Object)LogSourceCategoryContainer.DeviceCategory.UNKNOWNCATEGORY.getCategoryName(), 1));
        switch (requestType) {
            case 1: {
                criteria = criteria.and(new Criteria(Column.getColumn((String)"HostDetails", (String)"ISINHERITED"), (Object)1, 0));
                break;
            }
            case 2: {
                criteria = criteria.and(new Criteria(Column.getColumn((String)"HostDetails", (String)"ISINHERITED"), (Object)0, 0));
            }
        }
        if (parentCriteria != null) {
            return parentCriteria.and(criteria);
        }
        return criteria;
    }

    private static int getValidCount(int number) {
        if (number < 0) {
            return 0;
        }
        return number;
    }

    public static boolean isADReportsEnabled(JSONObject licenseDetails) throws JSONException {
        String paramvalue = LicenseUtil.findOtherDetails(licenseDetails, LICENSE_CONFIGURATION_KEY, AD_REPORTS_STATUSKEY);
        return Boolean.valueOf(paramvalue);
    }

    public static String getLicenseCategory(JSONObject licenseDetails) {
        return LicenseUtil.get(licenseDetails, "LICENSE_TYPE");
    }

    public static String getLicenseType(JSONObject licenseDetails) {
        return LicenseUtil.get(licenseDetails, "LICENSE_TYPE_CODE");
    }

    public static String getCompanyName(JSONObject licenseDetails) {
        return LicenseUtil.get(licenseDetails, "LICENSE_TO");
    }

    public static String getNumberOfDays(JSONObject licenseDetails) {
        return LicenseUtil.get(licenseDetails, "DAYS_TO_EXPIRE");
    }

    public static String getProductVersion(JSONObject licenseDetails) {
        return LicenseUtil.get(licenseDetails, "VERSION");
    }

    public static String getProductName(JSONObject licenseDetails) {
        return LicenseUtil.get(licenseDetails, "PRODUCT_NAME");
    }

    public static String getProductBuildNumber(JSONObject licenseDetails) {
        return LicenseUtil.get(licenseDetails, "BUILD_NO");
    }

    public static String getPrimaryEmailID(JSONObject licenseDetails) {
        return LicenseUtil.get(licenseDetails, "LICENSE_MAIL_ID");
    }

    public static String getLicenseExpiryDateString(JSONObject licenseDetails) {
        return LicenseUtil.get(licenseDetails, "EXPIRY_DATE");
    }

    public static String getLicensedUserEmail(JSONObject licenseDetails) {
        return LicenseUtil.get(licenseDetails, "LICENSE_MAIL_ID");
    }

    public static String getLicensedUserCountry(JSONObject licenseDetails) {
        try {
            JSONObject license = licenseDetails.getJSONObject("LicenseDetails");
            return LicenseUtil.get(license, "country");
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return null;
        }
    }

    public static String getAMSExpiryDateString(JSONObject licenseDetails) throws JSONException {
        return LicenseUtil.findOtherDetails(licenseDetails, LICENSE_AMS_KEY, LICENSE_AMS_EXPIRYDATE_KEY);
    }

    public static Date getAMSExpiryDate(JSONObject licenseDetails) throws JSONException {
        String expiryDate = LicenseUtil.findOtherDetails(licenseDetails, LICENSE_AMS_KEY, LICENSE_AMS_EXPIRYDATE_KEY);
        if (expiryDate == null) {
            return null;
        }
        Date date = null;
        try {
            date = new SimpleDateFormat("yyyy-MM-dd").parse(expiryDate);
        }
        catch (Exception exp) {
            LOGGER.log(Level.INFO, "In getAMSExpiryDate() method. Error occurred while parsing expiryDate: " + expiryDate);
        }
        return date;
    }

    public static Date getLicenseExpiryDate(JSONObject licenseDetails) {
        String expiryDate = LicenseUtil.get(licenseDetails, "EXPIRY_DATE");
        if (expiryDate == null) {
            return null;
        }
        Date date = null;
        try {
            try {
                date = new SimpleDateFormat("MMM dd, yyyy").parse(expiryDate);
            }
            catch (Exception exp) {
                LOGGER.log(Level.INFO, "Trial 1 - In getLicenseExpiryDate() method. Error occurred while parsing expiryDate: " + expiryDate);
                date = new SimpleDateFormat("yyyy MM dd").parse(expiryDate);
            }
        }
        catch (Exception exp) {
            LOGGER.log(Level.INFO, "Trial 2 - In getLicenseExpiryDate() method. Error occurred while parsing expiryDate: " + expiryDate);
        }
        return date;
    }

    private static String findOtherDetails(JSONObject licenseDetails, String componentKey, String paramKey) throws JSONException {
        JSONObject components = licenseDetails.getJSONObject("COMPONENT_DETAILS");
        return LicenseUtil.getLicenseDetails(components, componentKey, paramKey);
    }

    private static String getLicenseDetails(JSONObject obj, String compKey, String paramKey) throws JSONException {
        JSONObject jsonObj;
        String reqValue = null;
        if (obj.has(compKey) && !(jsonObj = new JSONObject(obj.getString(compKey))).isNull(paramKey)) {
            reqValue = jsonObj.getString(paramKey);
        }
        return reqValue;
    }

    private static String get(JSONObject licenseDetails, String key) {
        if (licenseDetails.isNull(key)) {
            return null;
        }
        try {
            return licenseDetails.getString(key);
        }
        catch (Exception exp) {
            return null;
        }
    }

    public static enum TempLicenseVersion {
        VERSION1,
        VERSION2,
        VERSION3,
        VERSION4,
        VERSION5,
        VERSION6,
        VERSION7;


        public static boolean isLicenseGreater(TempLicenseVersion incomingLicense, TempLicenseVersion targetLicense) {
            return TempLicenseVersion.getValue(incomingLicense) >= TempLicenseVersion.getValue(targetLicense);
        }

        private static int getValue(TempLicenseVersion version) {
            switch (version) {
                case VERSION1: {
                    return 1;
                }
                case VERSION2: {
                    return 2;
                }
                case VERSION3: {
                    return 3;
                }
                case VERSION4: {
                    return 4;
                }
                case VERSION5: {
                    return 5;
                }
                case VERSION6: {
                    return 6;
                }
                case VERSION7: {
                    return 7;
                }
            }
            return 5;
        }
    }
}

