/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.logforwarder;

import com.manageengine.ads.fw.logforward.LogForwardHandler;
import com.manageengine.ads.fw.logforward.impl.SyslogForwarder;
import com.manageengine.ela.server.common.device.util.DeviceUtil;
import com.manageengine.ela.server.common.logforwarder.LogForwarderConstants;
import com.manageengine.ela.server.common.logforwarder.LogForwarderFilterhandler;
import com.manageengine.ela.server.common.logforwarder.LogForwarderUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class LogForwarder
extends SyslogForwarder {
    private static final Logger LOGGER = Logger.getLogger(LogForwarder.class.getName());
    private int logcount = 0;
    private ScheduledFuture statusChecker = null;
    private ScheduledExecutorService statusScheduler = Executors.newScheduledThreadPool(1);
    public String failedHost = "";
    public String profile = "";

    public boolean sendMessage(JSONObject log, JSONObject config) {
        String message = "";
        boolean retval = true;
        try {
            String hostType = (String)log.opt("HOSTTYPE");
            String rawlog = (String)log.opt("FULLLOG");
            message = hostType != null && rawlog != null ? this.rawFormatMessage(log, config) : (hostType != null && LogForwarderUtils.isApplicationOrWindows(hostType) ? this.windowsFormatMessage(log, config) : this.defaultFormatMessage(log, config));
            JSONObject params = config.getJSONObject("PARAMS");
            if (params.getString("protocol").equalsIgnoreCase("tcp")) {
                retval = super.tcpSend(message, config);
            } else if (params.getString("protocol").equalsIgnoreCase("udp")) {
                retval = super.udpSend(message, config);
            }
        }
        catch (UnknownHostException e) {
            try {
                if (this.logcount >= 100) {
                    this.failedHost = config.get("HOST").toString();
                    this.profile = config.get("FORWARDER_NAME").toString();
                    String[] profilearray = this.profile.split(",");
                    LogForwardHandler.getInstance().enableDisableProfiles(profilearray, false);
                    LogForwarderFilterhandler.updateProfileMapping();
                    this.restartServerDownStatusCheck();
                }
            }
            catch (JSONException ex) {
                LOGGER.log(Level.INFO, "LogForwarder.UnknownHostException", ex);
            }
            ++this.logcount;
            retval = false;
        }
        catch (JSONException e) {
            LOGGER.log(Level.INFO, "LogForwarder.sendMessage", e);
            retval = false;
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "LogForwarder.sendMessage", e);
            retval = false;
        }
        return retval;
    }

    private void restartServerDownStatusCheck() {
        this.statusChecker.cancel(false);
        this.startStatusCheckTask();
    }

    private void startStatusCheckTask() {
        this.statusChecker = this.statusScheduler.scheduleAtFixedRate(new StatusChecker(), LogForwarderConstants.STATUS_SCHEDULE_RATE, LogForwarderConstants.STATUS_SCHEDULE_RATE, TimeUnit.SECONDS);
    }

    public void checkAndResetHostStatus() {
        InetAddress inetAddress = DeviceUtil.resolveDNSForDevice(this.failedHost);
        if (inetAddress == null) {
            LOGGER.log(Level.INFO, "Device Not Reachable");
        } else {
            String[] profilearray = this.profile.split(",");
            LogForwardHandler.getInstance().enableDisableProfiles(profilearray, true);
            LogForwarderFilterhandler.updateProfileMapping();
            this.statusChecker.cancel(true);
        }
    }

    public String defaultFormatMessage(JSONObject log, JSONObject config) {
        StringBuilder retString = new StringBuilder();
        try {
            JSONObject dataFormat = config.getJSONObject("PARAMS");
            retString.append("<").append(dataFormat.get("severity")).append(">");
            String version = dataFormat.getString("version");
            Date date = null;
            String hourInMillis = (String)log.opt("HOURINMILLIS");
            Object timeField = log.opt("TIME");
            if (hourInMillis != null) {
                Long epoch = Long.parseLong(hourInMillis);
                date = new Date(epoch);
            } else if (timeField != null) {
                Long epoch = Long.parseLong(timeField.toString());
                date = new Date(epoch);
            }
            if (version.equalsIgnoreCase("RFC5424")) {
                String time = LogForwarderConstants.FORMATTER5424.format(date);
                retString.append("1").append(" ").append(time);
            } else {
                String time = LogForwarderConstants.FORMATTER3164.format(date);
                retString.append(time);
            }
            LogForwarderUtils.appendHostNameField(log, retString);
            LogForwarderUtils.appendStringFieldDefault(log, "SOURCE", retString);
            if (version.equalsIgnoreCase("RFC5424")) {
                retString.append(" - - - ");
            } else {
                retString.append(":");
            }
            String msg = (String)log.opt("MESSAGE");
            String importMsg = (String)log.opt("FULLLOG");
            if (msg != null) {
                retString.append(" ").append(msg);
            } else if (importMsg != null) {
                retString.append(" ").append(importMsg);
            } else {
                retString.append(" ").append("-");
            }
            retString.append("\n");
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "LogForwarder.formatMessage", e);
        }
        return retString.toString();
    }

    public String rawFormatMessage(JSONObject log, JSONObject config) {
        StringBuilder retString = new StringBuilder();
        try {
            String rawlog = (String)log.opt("FULLLOG");
            if (rawlog != null) {
                retString.append(rawlog);
                retString.append("\n");
                return retString.toString();
            }
            return this.defaultFormatMessage(log, config);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "LogForwarder.rawFormatMessage", e);
            return retString.toString();
        }
    }

    public String windowsFormatMessage(JSONObject log, JSONObject config) {
        StringBuilder retString = new StringBuilder();
        try {
            String time;
            JSONObject dataFormat = config.getJSONObject("PARAMS");
            int priority = LogForwarderUtils.priorityCalculator(log);
            retString.append("<").append(priority).append(">");
            String version = dataFormat.getString("version");
            Long epoch = Long.parseLong(log.get("TIME").toString());
            Date date = new Date(epoch);
            if (version.equalsIgnoreCase("RFC5424")) {
                time = LogForwarderConstants.FORMATTER5424.format(date);
                retString.append("1").append(" ").append(time);
            } else {
                time = LogForwarderConstants.FORMATTER3164.format(date);
                retString.append(time);
            }
            LogForwarderUtils.appendHostNameField(log, retString);
            retString.append(" ").append("MSWinEventLog").append("\t");
            LogForwarderUtils.appendStringFieldWindows(log, "CRITICALITY", "0", retString);
            LogForwarderUtils.appendStringFieldWindows(log, "TYPE", "-", retString);
            LogForwarderUtils.appendStringFieldWindows(log, "COUNTER", "-", retString);
            time = LogForwarderConstants.WINDOWS_FORMATTER.format(date);
            retString.append(time).append("\t");
            Object strEventID = log.opt("EVENTID");
            if (strEventID != null) {
                int eventID = Integer.parseInt(strEventID.toString());
                retString.append(eventID).append("\t");
            } else {
                retString.append("-").append("\t");
            }
            LogForwarderUtils.appendStringFieldWindows(log, "SOURCE", "-", retString);
            LogForwarderUtils.appendStringFieldWindows(log, "USERNAME", "-", retString);
            LogForwarderUtils.appendStringFieldWindows(log, "SIDTYPE", "N/A", retString);
            String severityText = (String)log.opt("SEVERITY_TEXT");
            Object strAuditType = log.opt("AUDITTYPE");
            if (severityText != null) {
                retString.append(severityText).append("\t");
            } else if (strAuditType != null) {
                String auditStr = strAuditType.toString();
                if (!auditStr.equalsIgnoreCase("-")) {
                    int auditType = Integer.parseInt(auditStr);
                    switch (auditType) {
                        case 0: {
                            retString.append("Failure Audit").append("\t");
                            break;
                        }
                        case 1: {
                            retString.append("Success Audit").append("\t");
                            break;
                        }
                        default: {
                            retString.append("Success Audit").append("\t");
                            break;
                        }
                    }
                } else {
                    retString.append("-").append("\t");
                }
            } else {
                retString.append("-").append("\t");
            }
            String computer = (String)log.opt("COMPUTER");
            String hostname = (String)log.opt("HOSTNAME");
            if (computer != null) {
                retString.append(computer).append("\t");
            } else if (hostname != null) {
                retString.append(hostname).append("\t");
            } else {
                retString.append("-").append("\t");
            }
            LogForwarderUtils.appendStringFieldWindows(log, "CATEGORY", "-", retString);
            String msg = (String)log.opt("MESSAGE");
            if (msg != null) {
                msg = msg.replace("\r\n", " ").replace("\n", " ");
                retString.append(msg);
            } else {
                retString.append("-");
            }
            retString.append("\n");
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "LogForwarder.windowsFormatMessage", e);
        }
        return retString.toString();
    }

    private class StatusChecker
    implements Runnable {
        private StatusChecker() {
        }

        @Override
        public void run() {
            LogForwarder.this.checkAndResetHostStatus();
        }
    }
}

