/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.logforwarder;

import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.manageengine.ads.fw.logforward.LogForwarderAPI;
import com.manageengine.ela.server.common.logforwarder.LogForwarderFilterhandler;
import com.manageengine.ela.server.common.logforwarder.LogForwarderUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class LogForwarderFilter {
    private static LogForwarderFilter instance = null;
    private Map<Long, Long> hosttogroupmap = new ConcurrentHashMap<Long, Long>();
    private Map<Long, Long> apptohostmap = new ConcurrentHashMap<Long, Long>();
    private Map<Long, List<String>> deviceprofilemap = new ConcurrentHashMap<Long, List<String>>();
    private Map<Long, List<String>> groupprofilemap = new ConcurrentHashMap<Long, List<String>>();
    private static final Logger LOGGER = Logger.getLogger(LogForwarderFilter.class.getName());

    public static synchronized LogForwarderFilter getInstance() {
        if (instance == null) {
            instance = new LogForwarderFilter();
        }
        return instance;
    }

    public void init() {
        LogForwarderFilterhandler.init();
    }

    public void filterAndForward(Hashtable<?, ?> log) throws IOException {
        Long hostID = null;
        boolean isCritMatched = false;
        Object strHostID = log.get("HOSTID");
        Object strAppID = log.get("APPID");
        if (strHostID != null) {
            hostID = Long.parseLong(strHostID.toString());
        } else if (strAppID != null) {
            Long appID = Long.parseLong(strAppID.toString());
            hostID = this.apptohostmap.get(appID);
            if (hostID == null) {
                LogForwarderFilterhandler.updateApptoHostMapping();
            }
            hostID = this.apptohostmap.get(appID);
        }
        if (!this.groupprofilemap.isEmpty()) {
            isCritMatched = this.isGroupCritMatchedSend(hostID, log);
        }
        if (!isCritMatched && !this.deviceprofilemap.isEmpty()) {
            isCritMatched = this.isDeviceCritMatchedSend(hostID, log);
        }
        log.remove("FULLLOG");
    }

    private boolean isDeviceCritMatchedSend(Long hostid, Hashtable<?, ?> log) {
        List<String> profile = this.deviceprofilemap.get(hostid);
        if (profile != null) {
            JSONObject msg = LogForwarderUtils.convertHashtoJson(log);
            LogForwarderAPI.getInstance().sendMessage(msg, profile);
            return true;
        }
        return false;
    }

    private boolean isGroupCritMatchedSend(Long hostid, Hashtable<?, ?> log) {
        List<String> profile;
        Long groupid = this.hosttogroupmap.get(hostid);
        if (groupid == null) {
            LogForwarderFilterhandler.updateDevicetoGroupMapping();
        }
        if ((groupid = this.hosttogroupmap.get(hostid)) != null && (profile = this.groupprofilemap.get(groupid)) != null) {
            JSONObject msg = LogForwarderUtils.convertHashtoJson(log);
            LogForwarderAPI.getInstance().sendMessage(msg, profile);
            return true;
        }
        return false;
    }

    public void clearProfileMap() {
        if (!this.deviceprofilemap.isEmpty()) {
            this.deviceprofilemap.clear();
        }
        if (!this.groupprofilemap.isEmpty()) {
            this.groupprofilemap.clear();
        }
    }

    private void clearHostToGroupMap() {
        if (!this.hosttogroupmap.isEmpty()) {
            this.hosttogroupmap.clear();
        }
    }

    private void clearAppToHostMap() {
        if (!this.apptohostmap.isEmpty()) {
            this.apptohostmap.clear();
        }
    }

    public void populateDeviceGroupMap(DataObject doo) {
        this.clearHostToGroupMap();
        try {
            if (!doo.isEmpty()) {
                Iterator allDevices = doo.getRows("HostGroupMapping");
                while (allDevices.hasNext()) {
                    Row row = (Row)allDevices.next();
                    Long hostID = (Long)row.get("HOSTID");
                    Long groupID = (Long)row.get("GROUPID");
                    this.hosttogroupmap.put(hostID, groupID);
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "LogForwarderFilter.populateDeviceGroupMap", e);
        }
    }

    public void populateAppHostMap(DataObject doo) {
        this.clearAppToHostMap();
        try {
            if (!doo.isEmpty()) {
                Iterator allApps = doo.getRows("AppResources");
                while (allApps.hasNext()) {
                    Row row = (Row)allApps.next();
                    Long hostID = (Long)row.get("HOSTID");
                    Long appID = (Long)row.get("APPID");
                    this.apptohostmap.put(appID, hostID);
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "LogForwarderFilter.populateAppHostMap", e);
        }
    }

    public void updateDeviceProfileMap(Long deviceID, String profile) {
        try {
            if (!this.deviceprofilemap.containsKey(deviceID)) {
                ArrayList<String> listofinterestedprofiles = new ArrayList<String>();
                listofinterestedprofiles.add(profile);
                this.deviceprofilemap.put(deviceID, listofinterestedprofiles);
            } else {
                List<String> templist = this.deviceprofilemap.get(deviceID);
                templist.add(profile);
                this.deviceprofilemap.put(deviceID, templist);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "LogForwarderFilter.updateDeviceProfileMap", e);
        }
    }

    public void updateGroupProfileMap(Long groupID, String profile) {
        try {
            if (!this.groupprofilemap.containsKey(groupID)) {
                ArrayList<String> listofinterestedprofiles = new ArrayList<String>();
                listofinterestedprofiles.add(profile);
                this.groupprofilemap.put(groupID, listofinterestedprofiles);
            } else {
                List<String> templist = this.groupprofilemap.get(groupID);
                templist.add(profile);
                this.groupprofilemap.put(groupID, templist);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "LogForwarderFilter.updateGroupProfileMap", e);
        }
    }
}

