/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.logforwarder;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.common.logforwarder.LogForwarderFilter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogForwarderFilterhandler {
    private static final Logger LOGGER = Logger.getLogger(LogForwarderFilterhandler.class.getName());

    public static void init() {
        LogForwarderFilterhandler.updateDevicetoGroupMapping();
        LogForwarderFilterhandler.updateApptoHostMapping();
        LogForwarderFilterhandler.updateProfileMapping();
    }

    public static void updateApptoHostMapping() {
        try {
            DataObject appResourceDO = null;
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AppResources"));
            query.addSelectColumn(new Column("AppResources", "*"));
            appResourceDO = DataAccess.get((SelectQuery)query);
            LogForwarderFilter.getInstance().populateAppHostMap(appResourceDO);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "LogForwarderFilterhandler.updatetoHostMapping", e);
        }
    }

    public static void updateDevicetoGroupMapping() {
        try {
            DataObject devicegroupDO = null;
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"HostGroupMapping"));
            query.addSelectColumn(new Column("HostGroupMapping", "*"));
            devicegroupDO = DataAccess.get((SelectQuery)query);
            LogForwarderFilter.getInstance().populateDeviceGroupMap(devicegroupDO);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "LogForwarderFilterhandler.updateDevicetoGroupMapping", e);
        }
    }

    public static void updateProfileMapping() {
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSLogForwardConfig"));
            query.addSelectColumn(new Column("ADSLogForwardConfig", "*"));
            query.setCriteria(new Criteria(Column.getColumn((String)"ADSLogForwardConfig", (String)"IS_ENABLED"), (Object)Boolean.TRUE, 0));
            DataObject profileDO = DataAccess.get((SelectQuery)query);
            LogForwarderFilterhandler.populateSyslogMap(profileDO);
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, "LogForwarderFilterhandler.updateProfileMapping", ex);
        }
    }

    public static void populateSyslogMap(DataObject profileDO) {
        try {
            LogForwarderFilter.getInstance().clearProfileMap();
            if (!profileDO.isEmpty()) {
                Iterator allDeviceDetails = profileDO.getRows("ADSLogForwardConfig");
                DataObject deviceDO = null;
                DataObject groupDO = null;
                while (allDeviceDetails.hasNext()) {
                    Row row;
                    Row individualProfileDetails = (Row)allDeviceDetails.next();
                    Long configID = (Long)individualProfileDetails.get("CONFIG_ID");
                    String profile = (String)individualProfileDetails.get("FORWARDER_NAME");
                    deviceDO = LogForwarderFilterhandler.getSourceHostDeviceDO(configID);
                    groupDO = LogForwarderFilterhandler.getSourceHostGroupDO(configID);
                    if (!deviceDO.isEmpty()) {
                        Iterator devices = deviceDO.getRows("LogForwarderDeviceMapping");
                        while (devices.hasNext()) {
                            row = (Row)devices.next();
                            long deviceID = (Long)row.get("DEVICEID");
                            LogForwarderFilter.getInstance().updateDeviceProfileMap(deviceID, profile);
                        }
                    }
                    if (groupDO.isEmpty()) continue;
                    Iterator groups = groupDO.getRows("LogForwarderGroupMapping");
                    while (groups.hasNext()) {
                        row = (Row)groups.next();
                        long groupID = (Long)row.get("GROUPID");
                        LogForwarderFilter.getInstance().updateGroupProfileMap(groupID, profile);
                    }
                }
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, "LogForwarderFIlterhandler.populateSyslogMap", ex);
        }
    }

    public static DataObject getSourceHostDeviceDO(long configID) throws DataAccessException {
        Table device_mapping = Table.getTable((String)"LogForwarderDeviceMapping");
        Table logForward = Table.getTable((String)"ADSLogForwardConfig");
        Table device = Table.getTable((String)"Hosts");
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSLogForwardConfig"));
        query.addSelectColumn(Column.getColumn((String)"ADSLogForwardConfig", (String)"*"));
        query.addSelectColumn(Column.getColumn((String)"LogForwarderDeviceMapping", (String)"*"));
        query.addSelectColumn(Column.getColumn((String)"Hosts", (String)"HOST_ID"));
        query.addSelectColumn(Column.getColumn((String)"Hosts", (String)"DISPLAY_NAME"));
        query.setCriteria(new Criteria(Column.getColumn((String)"ADSLogForwardConfig", (String)"CONFIG_ID"), (Object)configID, 0));
        query.addJoin(new Join(logForward, device_mapping, new String[]{"CONFIG_ID"}, new String[]{"CONFIGID"}, 1));
        query.addJoin(new Join(device_mapping, device, new String[]{"DEVICEID"}, new String[]{"HOST_ID"}, 1));
        return PersistenceDBUtil.getPersistence().get((SelectQuery)query);
    }

    public static DataObject getSourceHostGroupDO(long configID) throws DataAccessException {
        Table group_mapping = Table.getTable((String)"LogForwarderGroupMapping");
        Table logForward = Table.getTable((String)"ADSLogForwardConfig");
        Table group = Table.getTable((String)"HostGroup");
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSLogForwardConfig"));
        query.addSelectColumn(Column.getColumn((String)"ADSLogForwardConfig", (String)"*"));
        query.addSelectColumn(Column.getColumn((String)"LogForwarderGroupMapping", (String)"*"));
        query.addSelectColumn(Column.getColumn((String)"HostGroup", (String)"ID"));
        query.addSelectColumn(Column.getColumn((String)"HostGroup", (String)"NAME"));
        query.setCriteria(new Criteria(Column.getColumn((String)"ADSLogForwardConfig", (String)"CONFIG_ID"), (Object)configID, 0));
        query.addJoin(new Join(logForward, group_mapping, new String[]{"CONFIG_ID"}, new String[]{"CONFIGID"}, 1));
        query.addJoin(new Join(group_mapping, group, new String[]{"GROUPID"}, new String[]{"ID"}, 1));
        return PersistenceDBUtil.getPersistence().get((SelectQuery)query);
    }

    public static Long getGroupID(Long hostID) {
        Criteria criteria = new Criteria(Column.getColumn((String)"Hosts", (String)"HOST_ID"), (Object)hostID, 0);
        try {
            DataObject dobj = PersistenceDBUtil.getPersistence().get(Arrays.asList("Hosts", "HostGroupMapping"), criteria);
            Row group = dobj.getRow("HostGroupMapping");
            Long groupID = Long.parseLong(group.get("GROUPID").toString());
            return groupID;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

