/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.logforwarder;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.manageengine.ads.fw.logforward.LogForwardHandler;
import com.manageengine.ela.server.common.device.util.DeviceUtil;
import com.manageengine.ela.server.common.logforwarder.LogForwarderUtils;
import com.manageengine.ela.server.common.network.dns.inet.InetAddressHandler;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.response.ember.ResponseBuilder;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class LogForwarderOperationHandler {
    private static final Logger LOGGER = Logger.getLogger(LogForwarderOperationHandler.class.getName());

    public static boolean addProfile(JSONObject reqJsonObject, ResponseBuilder responseBuilder, String operation) throws BaseStatusCode {
        try {
            JSONObject config_data = reqJsonObject.getJSONObject("CONFIGJSON");
            String host = config_data.getString("HOST");
            JSONArray deviceList = reqJsonObject.getJSONArray("SOURCE_DEVICE");
            JSONArray groupList = reqJsonObject.getJSONArray("SOURCE_GROUPS");
            Long[] deviceLongArray = LogForwarderUtils.jsonArrayToLongarray(deviceList);
            Long[] groupLongArray = LogForwarderUtils.jsonArrayToLongarray(groupList);
            boolean isClearTable = false;
            JSONObject responsejson = new JSONObject();
            InetAddress inetAddress = DeviceUtil.resolveDNSForDevice(host);
            if (inetAddress == null) {
                throw BaseStatusCode.getBaseStatusCode(7940);
            }
            if (InetAddressHandler.isLocalMachine(host)) {
                throw BaseStatusCode.getBaseStatusCode(7937);
            }
            LogForwardHandler.getInstance().setLogForwarderProfile(config_data);
            JSONObject config = LogForwardHandler.getInstance().getLogForwarderConfig(config_data.getString("FORWARDER_NAME"));
            Long config_id = Long.parseLong(config.getString("CONFIG_ID"));
            responsejson.put("CONFIG_ID", (Object)config_id);
            LogForwarderOperationHandler.addOrUpdateMappingTable(config_id, deviceLongArray, groupLongArray, isClearTable);
            responseBuilder.setResponse(responsejson);
        }
        catch (BaseStatusCode ex) {
            throw ex;
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "LogForwardOperationHandler.checkAndAddProfile", e);
            throw BaseStatusCode.getBaseStatusCode(7937);
        }
        return true;
    }

    public static boolean updateProfile(JSONObject reqJsonObject, ResponseBuilder responseBuilder, String operation) throws BaseStatusCode {
        try {
            JSONObject config_data = reqJsonObject.getJSONObject("CONFIGJSON");
            String host = config_data.getString("HOST");
            JSONArray deviceList = reqJsonObject.getJSONArray("SOURCE_DEVICE");
            JSONArray groupList = reqJsonObject.getJSONArray("SOURCE_GROUPS");
            Long[] deviceLongArray = LogForwarderUtils.jsonArrayToLongarray(deviceList);
            Long[] groupLongArray = LogForwarderUtils.jsonArrayToLongarray(groupList);
            boolean isClearTable = true;
            JSONObject responsejson = new JSONObject();
            InetAddress inetAddress = DeviceUtil.resolveDNSForDevice(host);
            if (inetAddress == null) {
                throw BaseStatusCode.getBaseStatusCode(7940);
            }
            if (InetAddressHandler.isLocalMachine(host)) {
                throw BaseStatusCode.getBaseStatusCode(7937);
            }
            LogForwardHandler.getInstance().setLogForwarderProfile(config_data);
            Long config_id = Long.parseLong(config_data.getString("CONFIG_ID"));
            LogForwarderOperationHandler.addOrUpdateMappingTable(config_id, deviceLongArray, groupLongArray, isClearTable);
            responseBuilder.setResponse(responsejson);
        }
        catch (BaseStatusCode ex) {
            throw ex;
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "LogForwardOperationHandler.checkAndAddProfile", e);
            throw BaseStatusCode.getBaseStatusCode(7937);
        }
        return true;
    }

    private static void addOrUpdateMappingTable(Long config_id, Long[] deviceLongArray, Long[] groupLongArray, boolean isClearTable) {
        try {
            Row serverMappingRow;
            int index;
            if (isClearTable) {
                SelectQueryImpl devicequery = new SelectQueryImpl(Table.getTable((String)"LogForwarderDeviceMapping"));
                devicequery.addSelectColumn(new Column("LogForwarderDeviceMapping", "*"));
                DataObject deviceDO = DataAccess.get((SelectQuery)devicequery);
                if (!deviceDO.isEmpty()) {
                    Criteria c = new Criteria(new Column("LogForwarderDeviceMapping", "CONFIGID"), (Object)config_id, 0);
                    deviceDO.deleteRows("LogForwarderDeviceMapping", c);
                    DataAccess.update((DataObject)deviceDO);
                }
                SelectQueryImpl groupquery = new SelectQueryImpl(Table.getTable((String)"LogForwarderGroupMapping"));
                groupquery.addSelectColumn(new Column("LogForwarderGroupMapping", "*"));
                DataObject groupDO = DataAccess.get((SelectQuery)groupquery);
                if (!groupDO.isEmpty()) {
                    Criteria c = new Criteria(new Column("LogForwarderGroupMapping", "CONFIGID"), (Object)config_id, 0);
                    groupDO.deleteRows("LogForwarderGroupMapping", c);
                    DataAccess.update((DataObject)groupDO);
                }
            }
            DataObject devicemappingDO = PersistenceDBUtil.getPersistence().constructDataObject();
            DataObject groupmappingDO = PersistenceDBUtil.getPersistence().constructDataObject();
            for (index = 0; index < deviceLongArray.length; ++index) {
                if (deviceLongArray[index] == null) continue;
                serverMappingRow = new Row("LogForwarderDeviceMapping");
                serverMappingRow.set("CONFIGID", (Object)config_id);
                serverMappingRow.set("DEVICEID", (Object)deviceLongArray[index]);
                devicemappingDO.addRow(serverMappingRow);
            }
            for (index = 0; index < groupLongArray.length; ++index) {
                if (groupLongArray[index] == null) continue;
                serverMappingRow = new Row("LogForwarderGroupMapping");
                serverMappingRow.set("CONFIGID", (Object)config_id);
                serverMappingRow.set("GROUPID", (Object)groupLongArray[index]);
                groupmappingDO.addRow(serverMappingRow);
            }
            devicemappingDO = PersistenceDBUtil.getPersistence().update(devicemappingDO);
            groupmappingDO = PersistenceDBUtil.getPersistence().update(groupmappingDO);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "LogForwarderOperationHandler.AddOrUpdateMapping", e);
        }
    }

    public static boolean getProfileDetails(JSONObject reqJsonObject, ResponseBuilder responseBuilder, Long userID) throws BaseStatusCode {
        try {
            String profile = reqJsonObject.getString("FORWARDER_NAME");
            JSONObject config = LogForwardHandler.getInstance().getLogForwarderConfig(profile);
            JSONObject responsejson = new JSONObject();
            JSONObject profiledetail = new JSONObject();
            if (config != null) {
                long configid = Long.parseLong(config.getString("CONFIG_ID"));
                profiledetail.put("CONFIG_ID", configid);
                profiledetail.put("HOST", (Object)config.getString("HOST"));
                profiledetail.put("PORT", (Object)config.getString("PORT"));
                profiledetail.put("ISENABLED", config.getBoolean("IS_ENABLED"));
                JSONObject param = config.getJSONObject("PARAMS");
                profiledetail.put("STANDARD", (Object)param.getString("version"));
                profiledetail.put("PROTOCOL", (Object)param.getString("protocol"));
                responsejson.put("PROFILE", (Object)profiledetail);
                responsejson.put("ISEDIT", (Object)Boolean.TRUE);
                LogForwarderUtils.populateSourceCheckedList(responsejson, configid);
            }
            responseBuilder.setResponse(responsejson);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "LogForwarderOperationHandler.getProfileDetails", e);
            throw BaseStatusCode.getBaseStatusCode(7937);
        }
        return true;
    }

    public static boolean enableDisableProfiles(JSONObject reqJsonObject, ResponseBuilder responseBuilder) throws BaseStatusCode {
        try {
            String profiles = reqJsonObject.getString("PROFILES");
            boolean action = reqJsonObject.getBoolean("ISENABLED");
            String[] profilearray = profiles.split(",");
            LogForwardHandler.getInstance().enableDisableProfiles(profilearray, action);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "LogForwarderOperationHandler.enableDisableProfiles", e);
            throw BaseStatusCode.getBaseStatusCode(7937);
        }
        return true;
    }
}

