/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.logforwarder;

import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.common.logforwarder.LogForwarderConstants;
import com.manageengine.ela.server.common.logforwarder.LogForwarderFilterhandler;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LogForwarderUtils {
    private static final Logger LOGGER = Logger.getLogger(LogForwarderUtils.class.getName());

    public static void appendStringFieldDefault(JSONObject log, String fieldName, StringBuilder retString) {
        String fieldVal = (String)log.opt(fieldName);
        if (fieldVal != null) {
            retString.append(" ").append(fieldVal);
        } else {
            retString.append(" ").append("-");
        }
    }

    public static boolean isApplicationOrWindows(String hostType) {
        return hostType.equalsIgnoreCase("Windows") || hostType.equalsIgnoreCase("MSSQL") || hostType.equalsIgnoreCase("Printer") || hostType.equalsIgnoreCase("Terminal") || hostType.equalsIgnoreCase("Oracle");
    }

    public static void appendHostNameField(JSONObject log, StringBuilder retString) {
        String hostname = (String)log.opt("HOSTNAME");
        String hostnameSmall = (String)log.opt("hostname");
        if (hostname != null) {
            retString.append(" ").append(hostname);
        } else if (hostnameSmall != null) {
            retString.append(" ").append(hostnameSmall);
        } else {
            retString.append(" ").append("-");
        }
    }

    public static void appendStringFieldWindows(JSONObject log, String fieldName, String defaultVal, StringBuilder retString) {
        String fieldVal = (String)log.opt(fieldName);
        if (fieldVal != null) {
            retString.append(fieldVal).append("\t");
        } else {
            retString.append(defaultVal).append("\t");
        }
    }

    public static int priorityCalculator(JSONObject log) {
        int def_fac = 16;
        int priority = 110;
        String sev = log.opt("SEVERITY").toString();
        if (sev != null) {
            int severity = Integer.parseInt(sev);
            switch (severity) {
                case 0: {
                    severity = LogForwarderConstants.SYSLOGSEVERITYMAP.get("error");
                    break;
                }
                case 1: {
                    severity = LogForwarderConstants.SYSLOGSEVERITYMAP.get("warning");
                    break;
                }
                case 2: {
                    severity = LogForwarderConstants.SYSLOGSEVERITYMAP.get("information");
                    break;
                }
                case 3: {
                    severity = LogForwarderConstants.SYSLOGSEVERITYMAP.get("information");
                    break;
                }
                case 4: {
                    severity = LogForwarderConstants.SYSLOGSEVERITYMAP.get("emergency");
                    break;
                }
                default: {
                    severity = LogForwarderConstants.SYSLOGSEVERITYMAP.get("information");
                }
            }
            priority = def_fac * 8 + severity;
        }
        return priority;
    }

    public static JSONObject convertHashtoJson(Hashtable log) {
        JSONObject message = new JSONObject();
        try {
            Set keys = log.keySet();
            for (String key : keys) {
                message.put(key, log.get(key));
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "LogForwarderAPI.convertHashtoJson", e);
        }
        return message;
    }

    public static Long[] jsonArrayToLongarray(JSONArray array) throws JSONException {
        Long[] result = new Long[array.length()];
        try {
            for (int index = 0; index < array.length(); ++index) {
                result[index] = Long.parseLong(array.getString(index));
            }
            return result;
        }
        catch (Exception e) {
            return result;
        }
    }

    public static Long[] stringArrayToLongarray(String[] array) {
        Long[] result = new Long[array.length];
        try {
            for (int index = 0; index < array.length; ++index) {
                result[index] = Long.parseLong(array[index]);
            }
            return result;
        }
        catch (Exception e) {
            return result;
        }
    }

    public static void populateSourceCheckedList(JSONObject responsejson, long configid) {
        try {
            Row row;
            DataObject devicemapDO = LogForwarderFilterhandler.getSourceHostDeviceDO(configid);
            DataObject groupmapDO = LogForwarderFilterhandler.getSourceHostGroupDO(configid);
            JSONArray groupList = new JSONArray();
            JSONArray deviceList = new JSONArray();
            JSONArray displayText = new JSONArray();
            JSONObject countObject = new JSONObject();
            if (!devicemapDO.isEmpty()) {
                Iterator devices = devicemapDO.getRows("Hosts");
                while (devices.hasNext()) {
                    row = (Row)devices.next();
                    Long hostID = Long.parseLong(row.get("HOST_ID").toString());
                    deviceList.put((Object)hostID);
                    displayText.put((Object)row.get("DISPLAY_NAME").toString());
                    Long groupID = LogForwarderFilterhandler.getGroupID(hostID);
                    if (countObject.has(groupID + "")) {
                        int count = countObject.getInt(groupID + "");
                        countObject.remove(groupID + "");
                        countObject.put(groupID + "", count + 1);
                        continue;
                    }
                    countObject.put(groupID + "", 1);
                }
            }
            if (!groupmapDO.isEmpty()) {
                Iterator groups = groupmapDO.getRows("HostGroup");
                while (groups.hasNext()) {
                    row = (Row)groups.next();
                    groupList.put(row.get("ID"));
                    displayText.put((Object)row.get("NAME").toString());
                }
            }
            responsejson.put("devices", (Object)deviceList);
            responsejson.put("groups", (Object)groupList);
            responsejson.put("displayText", (Object)displayText);
            responsejson.put("deviceGroupCount", (Object)countObject);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "LogForwarderOperationHandler.getSourceCheckedList", e);
        }
    }
}

