/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.network.dns.inet;

import com.adventnet.sa.server.util.CommonUtil;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class InetAddressHandler {
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");
    private static final Logger LOGGER = Logger.getLogger(CommonUtil.class.getName());

    public static InetAddress getLocalHost() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (Exception ex) {
            LOGGER.info("Hostname can not be resolved");
            return null;
        }
    }

    public static InetAddress getInetAddress(String identity) {
        InetAddress[] addressList = InetAddressHandler.getAllByName(identity);
        if (addressList != null) {
            return addressList[0];
        }
        return null;
    }

    public static InetAddress[] getAllByName(String identity) {
        try {
            return InetAddress.getAllByName(identity);
        }
        catch (Exception ex) {
            LOGGER.fine("Device can not be resolved");
            return null;
        }
    }

    public static boolean isValidInet4Address(String inet4Address) {
        if (inet4Address == null) {
            return false;
        }
        return IPV4_PATTERN.matcher(inet4Address).matches();
    }

    public static String getNameFromFQDN(String name) {
        try {
            if (name != null && name.indexOf(".") > -1 && !InetAddressHandler.isValidInet4Address(name)) {
                name = name.substring(0, name.indexOf("."));
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return name;
    }

    public static boolean checkAndRemoveLocalhost(ArrayList<String> list) {
        if (list.size() > 0) {
            InetAddress addr = InetAddressHandler.getLocalHost();
            InetAddress addrlp = InetAddressHandler.getInetAddress("localhost");
            int index = 0;
            while (index < list.size()) {
                String hostname = list.get(index);
                if (InetAddressHandler.verifyHostname(addr, hostname) || InetAddressHandler.verifyHostname(addrlp, hostname)) {
                    list.remove(index);
                    continue;
                }
                ++index;
            }
        }
        return true;
    }

    private static boolean verifyHostname(InetAddress addr, String hostname) {
        boolean result = false;
        if (addr == null) {
            return false;
        }
        String address = addr.getHostAddress();
        String name = addr.getHostName();
        String dnsName = addr.getCanonicalHostName();
        if (address.equalsIgnoreCase(hostname) || name.equalsIgnoreCase(hostname) || dnsName.equalsIgnoreCase(hostname)) {
            result = true;
        }
        return result;
    }

    public static boolean isLocalMachine(String machineName) {
        InetAddress addrlp = InetAddressHandler.getInetAddress("localhost");
        return InetAddressHandler.verifyHostname(InetAddressHandler.getLocalHost(), machineName) || InetAddressHandler.verifyHostname(addrlp, machineName);
    }
}

