/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.response;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.common.cache.Cache;
import java.util.Locale;

public class BaseStatusCode
extends Exception
implements Cloneable {
    private long statusCode;
    private String displayText;
    private String displayTextKey;
    private String detailedMessage = null;
    private String tbShootingLink = null;
    private static final long serialVersionUID = 1L;
    private static final Persistence PERSISTENCELITE = PersistenceDBUtil.getPersistenceLite();
    private static final Cache<Long, BaseStatusCode> STATUSCODECACHE = new Cache();

    private BaseStatusCode(Long statusCodes) {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"ELAStatusCodeMapping", (String)"STATUS_CODE"), (Object)statusCodes, 0);
            DataObject dataObject = PERSISTENCELITE.get("ELAStatusCodeMapping", criteria);
            Row firstRow = dataObject.getFirstRow("ELAStatusCodeMapping");
            String detailedMessage = (String)firstRow.get("DESCRIPTION");
            String displayText = (String)firstRow.get("DISPLAYTEXT");
            String bShootingLink = (String)firstRow.get("TROUBLESHOOTING_LINK");
            this.loadStatusMessage(statusCodes, displayText, detailedMessage, bShootingLink);
        }
        catch (Exception exp) {
            this.loadStatusMessage(65535L, "ela.errorcode.displaytext.undefined", "Undefined Error", "");
        }
    }

    private BaseStatusCode(Long statusCodes, String displayText) {
        this(statusCodes, displayText, displayText);
    }

    private BaseStatusCode(Long statusCodes, String displayText, String statusMsg) {
        this(statusCodes, displayText, statusMsg, null);
    }

    private BaseStatusCode(Long statusCodes, String displayText, String statusMsg, String tbShootingLink) {
        this.loadStatusMessage(statusCodes, displayText, statusMsg, tbShootingLink);
    }

    private void loadStatusMessage(Long statusCodes, String displayText, String statusMsg, String tbShootingLink) {
        this.statusCode = statusCodes;
        this.detailedMessage = statusMsg;
        this.displayText = displayText;
        this.displayTextKey = displayText;
        this.tbShootingLink = tbShootingLink;
    }

    public static BaseStatusCode getBaseStatusCode() {
        return BaseStatusCode.getBaseStatusCode(65535L);
    }

    public static BaseStatusCode getBaseStatusCode(int statusCodes) {
        return BaseStatusCode.getBaseStatusCode(Long.valueOf(statusCodes));
    }

    public static BaseStatusCode getBaseStatusCode(Long statusCodes) {
        BaseStatusCode code = BaseStatusCode.collectFromCache(statusCodes);
        if (code == null) {
            code = new BaseStatusCode(statusCodes);
            BaseStatusCode.addCache(statusCodes, code);
        }
        return code;
    }

    public static BaseStatusCode getBaseStatusCode(int statusCodes, String displayText) {
        return BaseStatusCode.getBaseStatusCode(Long.valueOf(statusCodes), displayText);
    }

    public static BaseStatusCode getBaseStatusCode(Long statusCodes, String displayText) {
        BaseStatusCode code = BaseStatusCode.collectFromCache(statusCodes);
        if (code != null) {
            try {
                code = code.clone();
                code.setDisplayText(displayText);
            }
            catch (Exception exp) {
                code = new BaseStatusCode(statusCodes, displayText);
            }
            return code;
        }
        code = new BaseStatusCode(statusCodes, displayText);
        BaseStatusCode.addCache(statusCodes, code);
        return code;
    }

    public static BaseStatusCode getBaseStatusCode(int statusCodes, String displayText, String statusMsg) {
        return BaseStatusCode.getBaseStatusCode(Long.valueOf(statusCodes), displayText, statusMsg);
    }

    public static BaseStatusCode getBaseStatusCode(Long statusCodes, String displayText, String statusMsg) {
        BaseStatusCode code = BaseStatusCode.collectFromCache(statusCodes);
        if (code != null) {
            try {
                code = code.clone();
                code.setDisplayText(displayText);
                code.setMessage(statusMsg);
            }
            catch (Exception exp) {
                code = new BaseStatusCode(statusCodes, displayText, statusMsg);
            }
            return code;
        }
        code = new BaseStatusCode(statusCodes, displayText, statusMsg);
        BaseStatusCode.addCache(statusCodes, code);
        return code;
    }

    public static BaseStatusCode getBaseStatusCode(int statusCodes, String displayText, String statusMsg, String trblShootingLink) {
        return BaseStatusCode.getBaseStatusCode(Long.valueOf(statusCodes), displayText, statusMsg, trblShootingLink);
    }

    public static BaseStatusCode getBaseStatusCode(Long statusCodes, String displayText, String statusMsg, String trblShootingLink) {
        BaseStatusCode code = BaseStatusCode.collectFromCache(statusCodes);
        if (code != null) {
            try {
                code = code.clone();
                code.setDisplayText(displayText);
                code.setMessage(statusMsg);
                code.setTbShootingLink(statusMsg);
            }
            catch (Exception exp) {
                code = new BaseStatusCode(statusCodes, displayText, statusMsg, trblShootingLink);
            }
            return code;
        }
        code = new BaseStatusCode(statusCodes, displayText, statusMsg, trblShootingLink);
        BaseStatusCode.addCache(statusCodes, code);
        return code;
    }

    private static BaseStatusCode collectFromCache(Long statusCode) throws NullPointerException {
        BaseStatusCode statuscache;
        if (statusCode != null && (statuscache = STATUSCODECACHE.get(statusCode)) != null) {
            return statuscache;
        }
        return null;
    }

    private static void addCache(Long statusCode, BaseStatusCode code) {
        if (code != null && statusCode != null) {
            STATUSCODECACHE.put(statusCode, code);
        }
    }

    private void setTbShootingLink(String tbShootingLink) {
        this.tbShootingLink = tbShootingLink;
    }

    private void setDisplayText(String displayText) {
        this.displayText = displayText;
        this.displayTextKey = displayText;
    }

    private void setMessage(String message) {
        this.detailedMessage = message;
    }

    public String getTbShootingLink() {
        return this.tbShootingLink;
    }

    public String getDisplayText() throws NullPointerException {
        if (this.displayText == null) {
            throw new NullPointerException();
        }
        return this.displayText;
    }

    public String getStatusCode() {
        return Long.toHexString(this.statusCode);
    }

    public long getOrgStatusCode() {
        return this.statusCode;
    }

    @Override
    public String getMessage() {
        return this.detailedMessage;
    }

    public BaseStatusCode resolveDisplayText(Locale locale) {
        this.displayText = ProductBundle.getInstance().getString(locale, this.displayTextKey);
        return this;
    }

    public BaseStatusCode clone() throws CloneNotSupportedException {
        return (BaseStatusCode)super.clone();
    }

    @Override
    public String toString() {
        return "Status Code 0x" + this.getStatusCode() + ": " + this.getMessage();
    }

    public String getDisplayTextKey() {
        return this.displayTextKey;
    }
}

