/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.response.ember;

import com.adventnet.la.util.ProductBundle;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import java.util.ArrayList;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ResponseBuilder {
    private JSONObject result = new JSONObject();

    public ResponseBuilder() {
        this.setStatus(BaseStatusCode.getBaseStatusCode(0));
    }

    public void setResponse(Object response) throws JSONException {
        this.result.put("response", response);
    }

    public void setTotalCount(Long count) throws JSONException {
        this.result.put("totalCount", (Object)count);
    }

    public void setCustomTotalCount(Long count) throws JSONException {
        this.result.put("custom_totalCount", (Object)count);
    }

    public void setStatus(BaseStatusCode status) {
        try {
            this.result.put("STATUS_CODE", (Object)status.getStatusCode());
            this.result.put("STATUS_MSG", (Object)status.getDisplayTextKey());
            this.result.put("TB_SHOOTING_LINK", (Object)status.getTbShootingLink());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setStatus(JSONObject status) {
        try {
            this.result.put("CUSTOM_STATUS", (Object)status);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setCustomStatusMsg(String msg) throws JSONException {
        if (msg == null) {
            this.result.put("STATUS_MSG", (Object)BaseStatusCode.getBaseStatusCode(65535).getDisplayText());
        } else {
            this.result.put("STATUS_MSG", (Object)msg);
        }
    }

    public ResponseBuilder resolveStatusMsg(Locale locale) {
        try {
            if (!this.result.isNull("STATUS_MSG")) {
                this.result.put("STATUS_MSG", (Object)ProductBundle.getInstance().getString(locale, this.result.getString("STATUS_MSG")));
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return this;
    }

    public String getResponse() {
        return this.result.toString();
    }

    public JSONObject getResponseJson() {
        return this.result;
    }

    public boolean hasKey(String key) {
        return !this.result.isNull(key);
    }

    public void addKeyPair(String key, Object value) throws JSONException {
        this.result.put(key, value);
    }

    public void addKeyPair(String key, ArrayList<?> arrayList) throws JSONException {
        if (arrayList.size() > 0) {
            this.result.put(key, (Object)new JSONArray(arrayList));
        }
    }

    public String toString() {
        return this.getResponse();
    }
}

