/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.schedule;

import com.adventnet.la.TimePack;
import com.manageengine.ela.server.common.callback.DocIdsResolvedCallBack;
import com.manageengine.ela.server.common.io.file.FileHandler;
import com.manageengine.ela.server.correlation.auditdata.CorrNosqlIndexHandler;
import com.manageengine.ela.server.correlation.common.handler.ExecutorServiceHandler;
import com.manageengine.ela.server.correlation.core.config.CorrConfigInfo;
import com.zoho.za.dae.elastic.BulkProcessListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;

public class ScheduledDocIdsResolver {
    private static final String DOCID_BACKUP_FILE_DIR = System.getProperty("server.dir") + File.separator + "server" + File.separator + "data" + File.separator + "docIdCache" + File.separator + "docCache.dmp";
    private static final Logger LOGGER = Logger.getLogger(ScheduledDocIdsResolver.class.getName());
    private static final ScheduledExecutorService DISPATCHER;
    private static transient List<DocIdsResolvedCallBack> callBackList;
    private static AtomicBoolean flag;
    private static ReentrantLock lock;

    public static void insert(DocIdsResolvedCallBack callback) {
        lock.lock();
        try {
            callBackList.add(callback);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processCallBacks() {
        lock.lock();
        try {
            TimePack timePack = new TimePack(TimeZone.getDefault());
            Iterator<DocIdsResolvedCallBack> iterator = callBackList.iterator();
            while (iterator.hasNext()) {
                DocIdsResolvedCallBack callBack = iterator.next();
                Map<Long, LinkedHashMap<String, Object>> docDetails = callBack.getDocDetails();
                docDetails.forEach((key, docIds) -> docIds.forEach((docId, value) -> {
                    if (value instanceof String) {
                        Map<String, Object> data = CorrNosqlIndexHandler.getIndexedDocInfo((String)value, docId, timePack);
                        if (data == null) {
                            LOGGER.log(Level.FINE, "Docid {0} is not yet indexed", new Object[]{docId});
                        }
                        callBack.setResolvedValues((Long)key, (String)docId, data);
                    }
                }));
                if (!callBack.isEverythingIndexed()) continue;
                callBack.callBack(null);
                iterator.remove();
            }
        }
        catch (Throwable err) {
            LOGGER.log(Level.WARNING, "Error occurred during data resolution", err);
        }
        finally {
            lock.unlock();
        }
    }

    static {
        lock = new ReentrantLock(true);
        flag = new AtomicBoolean(Boolean.FALSE);
        callBackList = Collections.synchronizedList(new ArrayList());
        DISPATCHER = new ScheduledThreadPoolExecutor(1){

            @Override
            protected void beforeExecute(Thread thread, Runnable runnable) {
                thread.setName("DocId[index][data][dispatcher]");
                super.beforeExecute(thread, runnable);
            }
        };
        DISPATCHER.scheduleWithFixedDelay(() -> {
            try {
                if (flag.get()) {
                    ScheduledDocIdsResolver.processCallBacks();
                    flag.set(Boolean.FALSE);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }, 0L, CorrConfigInfo.getDefault_scheduled_docidresolver_delay(), TimeUnit.MILLISECONDS);
        ExecutorServiceHandler.registerExecutorForShutdown(DISPATCHER);
        BulkProcessListener.registerCallBack((BulkProcessor.Listener)new BulkProcessor.Listener(){

            public void beforeBulk(long l, BulkRequest bulkRequest) {
            }

            public void afterBulk(long l, BulkRequest bulkRequest, BulkResponse bulkResponse) {
                try {
                    flag.set(true);
                }
                catch (Throwable exp) {
                    LOGGER.log(Level.WARNING, "Error occurred during doc cache processing {0}", new Object[]{exp.getMessage()});
                }
            }

            public void afterBulk(long l, BulkRequest bulkRequest, Throwable throwable) {
            }
        });
        File file = new File(DOCID_BACKUP_FILE_DIR);
        try {
            if (file.exists() && new BufferedReader(new FileReader(file)).readLine() != null) {
                LOGGER.log(Level.INFO, "Loading unprocessed docId backup data");
                callBackList.addAll((List)FileHandler.readObjectFromFile(file));
            }
        }
        catch (Exception exp) {
            LOGGER.log(Level.INFO, "Failed to read docId backup data.");
            exp.printStackTrace();
        }
        finally {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                int size = callBackList.size();
                if (size > 0) {
                    if (!file.exists()) {
                        try {
                            file.createNewFile();
                        }
                        catch (IOException e) {
                            LOGGER.info("File creation failed");
                        }
                    }
                    LOGGER.log(Level.INFO, "Shutdown hook : Backing up unprocessed {0} callbacks to disk.", size);
                    FileHandler.storeObjectInFIle(callBackList, file);
                }
            }));
        }
    }
}

