/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.schedule.ad;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.adventnet.taskengine.TaskExecutionException;
import com.manageengine.ela.server.common.discovery.windows.domain.ScheduledDiscoveryHandler;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CommonObjectImport
implements Task {
    private static final Logger LOGGER = Logger.getLogger(CommonObjectImport.class.getName());

    public void executeTask(TaskContext taskContext) throws TaskExecutionException {
        try {
            LOGGER.log(Level.INFO, "Starting Schedule for A import");
            List<String> tableList = Arrays.asList("ELADiscoveryScheduleConfig", "ELADiscoveryCriteriaConfig");
            Criteria criteria = new Criteria(Column.getColumn((String)"ELADiscoveryScheduleConfig", (String)"SCHEDULE_ID"), (Object)taskContext.getScheduleID(), 0);
            DataObject dobj = PersistenceDBUtil.getPersistence().get(tableList, criteria);
            if (dobj.containsTable("ELADiscoveryScheduleConfig")) {
                Row schduleConfigRow = dobj.getFirstRow("ELADiscoveryScheduleConfig");
                Integer type = (Integer)schduleConfigRow.get("TYPE_ID");
                switch (type) {
                    case 1: {
                        ScheduledDiscoveryHandler.beginScheduledDiscovery(dobj);
                        break;
                    }
                    default: {
                        throw BaseStatusCode.getBaseStatusCode(7428);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Scheduled user import failed to complete. See exception for cause.");
            e.printStackTrace();
        }
    }

    public void stopTask() throws TaskExecutionException {
    }
}

