/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.schedule.application.webserver;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.adventnet.taskengine.TaskExecutionException;
import com.manageengine.ela.server.application.webserver.iis.IISFormatUtil;
import com.manageengine.ela.server.application.webserver.iis.IISLogCollector;
import com.manageengine.ela.server.application.webserver.iis.IISLogManager;
import com.manageengine.ela.server.application.webserver.iis.IISLogProperties;
import com.manageengine.ela.server.application.webserver.iis.IISUtil;
import com.manageengine.ela.server.application.webserver.iis.constants.IISApplicationConstants;
import com.manageengine.ela.server.common.cache.ServerDetailsBean;
import com.manageengine.ela.server.common.credential.Credential;
import com.manageengine.ela.server.common.device.util.DeviceUtil;
import com.manageengine.ela.server.common.io.file.parser.FileParser;
import com.manageengine.ela.server.common.io.file.pattern.DynamicPattern;
import com.manageengine.ela.server.common.io.file.pattern.PatternDetailsBean;
import com.manageengine.ela.server.common.io.file.pattern.PatternUtils;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.schedule.config.ScheduleUtil;
import com.manageengine.ela.server.importlog.ImportFile;
import com.manageengine.ela.server.importlog.ImportFilters;
import com.manageengine.ela.server.importlog.protocols.ImportProtocolBean;
import com.manageengine.ela.server.importlog.protocols.ImportProtocolUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.json.JSONArray;

public class IISScheduler
implements Task {
    public static final Logger LOGGER = Logger.getLogger(IISScheduler.class.getName());
    private static final Persistence PERSISTENCELITE = PersistenceDBUtil.getPersistenceLite();
    private static IISLogManager iisLogManager = null;

    public IISScheduler() throws IllegalAccessException {
        if (iisLogManager == null) {
            iisLogManager = IISLogManager.getInstance();
        }
    }

    public void stopTask() throws TaskExecutionException {
    }

    public void executeTask(TaskContext taskContext) throws TaskExecutionException {
        try {
            Long scheduleId = taskContext.getScheduleID();
            this.executeSchedule(scheduleId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void executeSchedule(Long scheduleId) throws DataAccessException, BaseStatusCode {
        Criteria criteria = new Criteria(Column.getColumn((String)"WebServerConfiguration", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
        DataObject dataObject = PERSISTENCELITE.get(Arrays.asList("WebServerConfiguration", "IISApplicationInfo", "IISConfiguredSites", "IISLogFIleInfo"), criteria);
        if (dataObject.isEmpty()) {
            ScheduleUtil.deleteSchedule(new JSONArray().put((Object)scheduleId));
            return;
        }
        Row iisApplicationInfoRow = dataObject.getRow("WebServerConfiguration");
        Long appId = (Long)iisApplicationInfoRow.get("APPID");
        Long webServerId = (Long)iisApplicationInfoRow.get("WEBSERVER_ID");
        Long status = IISUtil.updateAndGetStatus(appId);
        String tz = IISUtil.getTimeZone(webServerId);
        Long deviceID = IISUtil.getDeviceIDFromAPPID(appId);
        String deviceName = DeviceUtil.getDeviceName(deviceID).getDeviceName();
        if (status.equals(IISApplicationConstants.ENABLED)) {
            Long credentialId = (Long)iisApplicationInfoRow.get("CREDENTIAL_ID");
            Iterator iterator = dataObject.getRows("IISLogFIleInfo");
            Iterator siteIterator = dataObject.getRows("IISConfiguredSites");
            while (iterator.hasNext()) {
                Row siteRow = (Row)siteIterator.next();
                String siteName = (String)siteRow.get("SITE_NAME");
                Row iisFileConfigRow = (Row)iterator.next();
                Long fileId = (Long)iisFileConfigRow.get("FILE_ID");
                String fileName = (String)iisFileConfigRow.get("FILE_NAME");
                String filePath = (String)iisFileConfigRow.get("DIRECTORY") + File.separator + fileName;
                filePath = filePath.replaceAll("\\\\", "/");
                Long rotationType = (Long)iisFileConfigRow.get("ROTATION_TYPE");
                Long patternId = (Long)iisFileConfigRow.get("PATTERN_ID");
                Long maxFileSize = (Long)iisFileConfigRow.get("FILE_SIZE");
                Long formatId = (Long)iisFileConfigRow.get("FORMAT_ID");
                Long auditId = IISUtil.addAndGetAuditId(fileId, fileName, appId);
                Long alreadyReadCount = IISUtil.getAlreadyReadCount(auditId);
                String auditFileName = IISUtil.getFileName(auditId);
                if (rotationType == 2L && (auditFileName == null || auditFileName.equals(IISFormatUtil.getDefaultFileNameForFileSizeRollover(formatId))) && (auditFileName = IISUtil.getFileNameForMaxSize((String)iisFileConfigRow.get("DIRECTORY"), formatId, deviceName, webServerId)) == null) {
                    auditFileName = IISFormatUtil.getDefaultFileNameForFileSizeRollover(formatId);
                }
                IISUtil.setAuditStatus(auditId, 12145L, false);
                if (auditFileName != null) {
                    fileName = auditFileName;
                    iisFileConfigRow.set("FILE_NAME", (Object)auditFileName);
                    filePath = (String)iisFileConfigRow.get("DIRECTORY") + File.separator + fileName;
                    filePath = filePath.replaceAll("\\\\", "/");
                }
                try {
                    Criteria patternCriteria = new Criteria(Column.getColumn((String)"ELADynamicPatterns", (String)"PATTERN_ID"), (Object)patternId, 0);
                    DataObject dataObject1 = PERSISTENCELITE.get("ELADynamicPatterns", patternCriteria);
                    List<DynamicPattern> dynamicPatterns = PatternUtils.getDynamicPatternList(dataObject1);
                    ImportFile importFile = new ImportFile(filePath, 0);
                    importFile.setFilename(fileName);
                    PatternDetailsBean patternDetailsBean = new PatternDetailsBean(dynamicPatterns);
                    importFile.setPatternDetailsBean(patternDetailsBean);
                    IISLogProperties logProperty = new IISLogProperties(importFile);
                    logProperty.setHeaderLine(IISUtil.getHeaderLine(auditId));
                    Long protocolId = ImportProtocolUtils.getProtocolId("SMB-Windows");
                    Credential credential = IISUtil.getCredential(credentialId, deviceID);
                    if (!(credential != null && credential.getUserName() != null || ServerDetailsBean.getInstance().isDefaultAuthenticationAllowed())) {
                        throw BaseStatusCode.getBaseStatusCode(1);
                    }
                    ImportProtocolBean importProtocolBean = credential == null ? new ImportProtocolBean(protocolId) : new ImportProtocolBean(protocolId, credential.getUserName(), credential.getPassword());
                    importProtocolBean.setProtocolHandlerClass(ImportProtocolUtils.getProtocolHandlerName(protocolId));
                    importProtocolBean.setDeviceName(deviceName);
                    logProperty.setImportProtocolBean(importProtocolBean);
                    logProperty.setSourceId(-1L);
                    logProperty.setLogFormatId(-1L);
                    logProperty.setProtocolId(protocolId);
                    logProperty.setLinkedDevice(deviceID, deviceName);
                    logProperty.setThrowAway(false);
                    logProperty.setImportFilters(new ImportFilters(appId));
                    logProperty.setStatus(12145L);
                    logProperty.setSize(maxFileSize);
                    IISLogCollector collector = new IISLogCollector(auditId, siteName, appId);
                    collector.setRotationType(rotationType);
                    FileParser fileParser = new FileParser(collector);
                    logProperty.setFileParser(fileParser);
                    logProperty.setLineCount(alreadyReadCount);
                    iisLogManager.addNewFile(logProperty);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    IISUtil.setAuditStatus(auditId, 12197L, true);
                }
            }
            PERSISTENCELITE.update(dataObject);
        }
    }
}

