/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.schedule.archive;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.db.archive.ArchiveNotificationHandler;
import com.adventnet.db.archive.ArchivePolicyInfo;
import com.adventnet.db.archive.TableArchiverUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.Row;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.adventnet.taskengine.TaskExecutionException;
import com.manageengine.ela.server.alert.listener.AlertDBArchiveListener;
import java.sql.Connection;
import java.util.Iterator;
import java.util.logging.Logger;

public class TableArchiveTask
implements Task {
    private static final Logger LOGGER = Logger.getLogger(TableArchiveTask.class.getName());

    public void executeTask(TaskContext taskContext) throws TaskExecutionException {
        LOGGER.info("Starting Alert Table Archive Task");
        Iterator iterator = taskContext.getDefaultTaskInputs();
        try {
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                Long policyID = Long.parseLong((String)row.get("VARIABLE_VALUE"));
                ArchivePolicyInfo policyInfo = TableArchiverUtil.getPolicy((Long)policyID);
                this.updateCriteriaString(policyInfo);
                policyInfo.setNotificationHandler((ArchiveNotificationHandler)new AlertDBArchiveListener(System.currentTimeMillis()));
                RelationalAPI.getInstance().getArchiveAdapter().startArchive(policyInfo);
                LOGGER.info("Completed Table Archive Task. Policy Id : " + policyID);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        LOGGER.info("Error while processing archive task");
    }

    private void updateCriteriaString(ArchivePolicyInfo policyInfo) {
        Long max = this.getMaxAuditID();
        Long limit = max - policyInfo.getThreshold() / 2L;
        String crit = "($.AUDIT_ID < '" + limit + "')";
        policyInfo.setCriteria(crit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long getMaxAuditID() {
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"LAAlertAudit"));
        Column first = Column.getColumn((String)"LAAlertAudit", (String)"AUDIT_ID").maximum();
        first.setColumnAlias("MAX");
        query.addSelectColumn(first);
        Long count = 0L;
        Connection conn = null;
        DataSet ds = null;
        try {
            RelationalAPI relApi = RelationalAPI.getInstance();
            conn = relApi.getConnection();
            ds = relApi.executeQuery((Query)query, conn);
            LOGGER.fine("MaxAudit Id Object : " + ds.toString());
            while (ds.next()) {
                count = ds.getAsLong("MAX");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (ds != null) {
                    ds.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return count;
    }

    public void stopTask() throws TaskExecutionException {
    }
}

