/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.schedule.config;

import com.adventnet.persistence.Row;
import com.adventnet.taskengine.util.CalendarRowConfig;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.schedule.config.ELABaseScheduleImpl;
import java.util.Date;
import org.joda.time.DateTime;

public class CalendarScheduleImpl
extends ELABaseScheduleImpl {
    private RepeatFrequency repeatFrequency = null;
    private int dayOfWeek = -1;
    private int dateOfMonth = -1;
    private int monthOfYear = -1;
    private int yearOfDecade = -1;
    private long timeOfDay = 0L;
    private long week = -1L;
    private boolean useDateInReverse = false;

    public CalendarScheduleImpl(String scheduleName, String className) {
        this(scheduleName, className, "No description");
    }

    public CalendarScheduleImpl(String scheduleName, String className, String scheduleDescription) {
        super(scheduleName, className, scheduleDescription);
    }

    @Override
    public Row getConfigRow() throws BaseStatusCode {
        if (this.validate()) {
            Row row = new Row("Calendar");
            row.set("SCHEDULE_ID", this.scheduleRow.get("SCHEDULE_ID"));
            row.set("REPEAT_FREQUENCY", (Object)this.getRepeatFrequency().getFrequency());
            row.set("TIME_OF_DAY", (Object)this.getTimeOfDay());
            row.set("UNIT_OF_TIME", (Object)this.getUnitsOfTime().getCondnString());
            row.set("DAY_OF_WEEK", (Object)this.getDayOfWeek());
            row.set("WEEK", (Object)this.getWeek());
            row.set("DATE_OF_MONTH", (Object)this.getDateOfMonth());
            row.set("MONTH_OF_YEAR", (Object)this.getMonthOfYear());
            row.set("YEAR_OF_DECADE", (Object)this.getYearOfDecade());
            row.set("USE_DATE_IN_REVERSE", (Object)this.useDateInReverse());
            return row;
        }
        throw BaseStatusCode.getBaseStatusCode(7428);
    }

    public void setRepeatFrequency(RepeatFrequency frequency) {
        this.repeatFrequency = frequency;
    }

    public RepeatFrequency getRepeatFrequency() {
        return this.repeatFrequency;
    }

    public long getTimeOfDay() {
        return this.timeOfDay;
    }

    public void setTimeOfDay(long timeOfDay) {
        this.timeOfDay = timeOfDay;
    }

    public int getDayOfWeek() {
        return this.dayOfWeek;
    }

    public void setDayOfWeek(int dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    public Long getWeek() {
        return this.week;
    }

    public void setWeek(long week) {
        this.week = week;
    }

    public int getDateOfMonth() {
        return this.dateOfMonth;
    }

    public void setDateOfMonth(int dateOfMonth) {
        if (dateOfMonth >= 29) {
            dateOfMonth = 31 - dateOfMonth;
            this.setUseDateInReverse(true);
        } else {
            this.setUseDateInReverse(false);
        }
        this.dateOfMonth = dateOfMonth;
    }

    public int getMonthOfYear() {
        return this.monthOfYear;
    }

    public void setMonthOfYear(int monthOfYear) {
        this.monthOfYear = monthOfYear;
    }

    public int getYearOfDecade() {
        return this.yearOfDecade;
    }

    public void setYearOfDecade(int yearOfDecade) {
        this.yearOfDecade = yearOfDecade;
    }

    public boolean useDateInReverse() {
        return this.useDateInReverse;
    }

    public void setUseDateInReverse(boolean useDateInReverse) {
        this.useDateInReverse = useDateInReverse;
    }

    @Override
    public Date getInitialScheduleTime() {
        Date currentDate = new Date();
        if (!this.validate()) {
            return currentDate;
        }
        Long currentMillis = System.currentTimeMillis();
        DateTime date = new DateTime((Object)currentDate);
        switch (this.getUnitsOfTime()) {
            case HOURS: {
                date = date.withMillisOfDay(new Long(this.getTimeOfDay()).intValue() * 3600000);
                break;
            }
            case MINUTES: {
                date = date.withMillisOfDay(new Long(this.getTimeOfDay()).intValue() * 60000);
                break;
            }
            case SECONDS: {
                date = date.withMillisOfDay(new Long(this.getTimeOfDay()).intValue() * 1000);
            }
        }
        if (this.getDayOfWeek() > 0) {
            if (this.getDayOfWeek() == 1) {
                date = date.withDayOfWeek(7);
            } else if (this.getDayOfWeek() < 8) {
                date = date.withDayOfWeek(this.getDayOfWeek() - 1);
            } else {
                int i;
                int[] daysOfWeekArray = CalendarRowConfig.decodeDaysOfWeekMask((int)this.getDayOfWeek());
                int currentDayOfWeek = date.getDayOfWeek();
                currentDayOfWeek = currentDayOfWeek == 1 ? 7 : --currentDayOfWeek;
                for (i = 0; i < daysOfWeekArray.length; ++i) {
                    if (currentDayOfWeek > daysOfWeekArray[i]) continue;
                    DateTime datecheck = null;
                    datecheck = daysOfWeekArray[i] + 1 == 8 ? date.withDayOfWeek(1) : date.withDayOfWeek(daysOfWeekArray[i] + 1);
                    if (datecheck.getMillis() < currentMillis) continue;
                    date = date.withDayOfWeek(datecheck.getDayOfWeek());
                    break;
                }
                if (i == daysOfWeekArray.length) {
                    date = daysOfWeekArray[0] + 1 == 8 ? date.withDayOfWeek(1) : date.withDayOfWeek(daysOfWeekArray[0]);
                }
            }
            if (date.getMillis() < currentMillis) {
                date = date.plusWeeks(1);
            }
        }
        if (this.getWeek() > -1L) {
            date = date.withWeekyear(this.getWeek().intValue());
        }
        if (this.getDateOfMonth() > -1 && (date = this.useDateInReverse() ? date.withDayOfMonth(date.getChronology().dayOfMonth().getMaximumValue(date.getMillis()) - (this.getDateOfMonth() - 1)) : date.withDayOfMonth(this.getDateOfMonth())).getMillis() < currentMillis) {
            date = date.plusMonths(1);
        }
        if (this.getMonthOfYear() > -1 && (date = date.withMonthOfYear(this.getMonthOfYear())).getMillis() < currentMillis) {
            date = date.plusYears(1);
        }
        return date.toDate();
    }

    private boolean validate() {
        return this.getRepeatFrequency() != null && this.getUnitsOfTime() != null;
    }

    public static enum RepeatFrequency {
        DAILY("DAILY"),
        WEEKLY("WEEKLY"),
        MONTHLY("MONTHLY");

        String frequency = null;

        private RepeatFrequency(String type) {
            this.frequency = type;
        }

        public String getFrequency() {
            return this.frequency;
        }
    }
}

