/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.schedule.config;

import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.schedule.config.ELASchedule;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class ELABaseScheduleImpl
implements ELASchedule {
    private String className = null;
    protected Row scheduleRow = null;
    protected DataObject scheduleDobj = null;
    protected DataObject depedntDO = null;
    protected Date initialScheduleTime = null;
    private boolean isExecuteImediately = false;
    private boolean skipMissedSchedule = false;
    private UnitofTime unitsOfTime = null;
    public static final SimpleDateFormat DATEFORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public ELABaseScheduleImpl(String scheduleName, String className, String scheduleDescription) {
        this.className = className;
        this.scheduleRow = new Row("Schedule");
        this.scheduleRow.set("SCHEDULE_NAME", (Object)scheduleName);
        this.scheduleRow.set("DESCRIPTION", (Object)scheduleDescription);
    }

    @Override
    public String getScheduleExecutor() {
        return this.className;
    }

    @Override
    public void addDependentDO(DataObject dobj) {
        this.depedntDO = dobj;
    }

    @Override
    public DataObject createSchedule() throws DataAccessException, BaseStatusCode {
        if (this.scheduleDobj == null) {
            this.getDataObject();
        }
        try {
            PersistenceDBUtil.getScheduler().updateSchedule(this.scheduleDobj);
            return this.scheduleDobj;
        }
        catch (DataAccessException dae) {
            throw dae;
        }
        catch (Exception exp) {
            throw BaseStatusCode.getBaseStatusCode(65535);
        }
    }

    @Override
    public DataObject getDataObject() throws DataAccessException, BaseStatusCode {
        if (this.scheduleDobj != null) {
            return this.scheduleDobj;
        }
        this.scheduleDobj = PersistenceDBUtil.getPersistence().constructDataObject();
        this.scheduleDobj.addRow(this.scheduleRow);
        Row taskengineRow = new Row("TaskEngine_Task");
        taskengineRow.set("TASK_NAME", this.scheduleRow.get("SCHEDULE_NAME"));
        taskengineRow.set("CLASS_NAME", (Object)this.getScheduleExecutor());
        this.scheduleDobj.addRow(taskengineRow);
        Row row = new Row("Scheduled_Task");
        row.set("SCHEDULE_ID", this.scheduleRow.get("SCHEDULE_ID"));
        row.set("TASK_ID", taskengineRow.get("TASK_ID"));
        row.set("SKIP_MISSED_SCHEDULE", (Object)this.isSkipMissedSchedule());
        row.set("SCHEDULE_MODE", (Object)1);
        this.scheduleDobj.addRow(row);
        row = new Row("Task_Input");
        row.set("SCHEDULE_ID", this.scheduleRow.get("SCHEDULE_ID"));
        row.set("SCHEDULE_TIME", (Object)DATEFORMAT.format(this.getInitialScheduleTime()));
        row.set("TASK_ID", taskengineRow.get("TASK_ID"));
        this.scheduleDobj.addRow(row);
        this.scheduleDobj.addRow(this.getConfigRow());
        if (this.depedntDO != null) {
            this.scheduleDobj.append(this.depedntDO);
        }
        return this.scheduleDobj;
    }

    public boolean isExecuteImediately() {
        return this.isExecuteImediately;
    }

    public void setExecuteImediately(boolean isExecuteImediately) {
        this.isExecuteImediately = isExecuteImediately;
    }

    @Override
    public Object getScheduleId() {
        return this.scheduleRow.get("SCHEDULE_ID");
    }

    public void setInitialScheduleTime(Date date) {
        this.initialScheduleTime = date;
    }

    public Date getInitialScheduleTime() {
        if (this.initialScheduleTime == null) {
            return new Date();
        }
        return this.initialScheduleTime;
    }

    public void setDefaultTaskInput(HashMap<String, String> variables) throws DataAccessException, BaseStatusCode {
        DataObject dobj;
        if (this.scheduleDobj != null && !variables.isEmpty()) {
            dobj = PersistenceDBUtil.getPersistence().constructDataObject();
            Long instanceId = Long.parseLong(this.scheduleDobj.getFirstRow("Task_Input").get("INSTANCE_ID").toString());
            Set<Map.Entry<String, String>> set = variables.entrySet();
            for (Map.Entry<String, String> mapEntry : set) {
                Row row = new Row("Default_Task_Input");
                row.set("INSTANCE_ID", (Object)instanceId);
                row.set("VARIABLE_NAME", (Object)mapEntry.getKey());
                row.set("VARIABLE_VALUE", (Object)mapEntry.getValue());
                dobj.addRow(row);
            }
        } else {
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
        PersistenceDBUtil.getPersistence().add(dobj);
    }

    public UnitofTime getUnitsOfTime() {
        return this.unitsOfTime;
    }

    public void setUnitsOfTime(UnitofTime unitsOfTime) {
        this.unitsOfTime = unitsOfTime;
    }

    public boolean isSkipMissedSchedule() {
        return this.skipMissedSchedule;
    }

    public void setSkipMissedSchedule(boolean skipMissedSchedule) {
        this.skipMissedSchedule = skipMissedSchedule;
    }

    public static enum UnitofTime {
        HOURS("Hours"),
        MINUTES("Minutes"),
        SECONDS("Seconds");

        String condn = null;

        private UnitofTime(String type) {
            this.condn = type;
        }

        public String getCondnString() {
            return this.condn;
        }
    }
}

