/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.schedule.config;

import com.adventnet.persistence.Row;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.schedule.config.ELABaseScheduleImpl;
import java.util.Date;

public class PeriodicScheduleImpl
extends ELABaseScheduleImpl {
    private Date startDate = new Date();
    private Date endDate = null;
    private Long timePeriod = null;

    public PeriodicScheduleImpl(String scheduleName, String className) {
        this(scheduleName, className, "No description");
    }

    public PeriodicScheduleImpl(String scheduleName, String className, String description) {
        super(scheduleName, className, description);
    }

    @Override
    public Row getConfigRow() throws BaseStatusCode {
        if (this.validate()) {
            Row row = new Row("Periodic");
            row.set("SCHEDULE_ID", this.scheduleRow.get("SCHEDULE_ID"));
            if (this.getStartDate() != null) {
                row.set("START_DATE", (Object)DATEFORMAT.format(this.getStartDate()));
            }
            row.set("END_DATE", this.endDate == null ? null : DATEFORMAT.format(this.endDate));
            row.set("TIME_PERIOD", (Object)this.getTimePeriod());
            row.set("UNIT_OF_TIME", (Object)this.getUnitsOfTime().getCondnString());
            row.set("EXECUTE_IMMEDIATELY", (Object)this.isExecuteImediately());
            return row;
        }
        throw BaseStatusCode.getBaseStatusCode(7428);
    }

    private boolean validate() {
        return this.getTimePeriod() != null && this.getUnitsOfTime() != null;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Long getTimePeriod() {
        return this.timePeriod;
    }

    public void setTimePeriod(Long timePeriod) {
        this.timePeriod = timePeriod;
    }
}

