/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.schedule.config;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.util.DBUtil;
import com.adventnet.taskengine.Scheduler;
import com.adventnet.taskengine.util.PersistenceUtil;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.schedule.config.CalendarScheduleImpl;
import com.manageengine.ela.server.common.schedule.config.ELABaseScheduleImpl;
import com.manageengine.ela.server.common.schedule.config.PeriodicScheduleImpl;
import com.manageengine.ela.server.common.util.JSONUtil;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import org.joda.time.DateTime;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ScheduleUtil {
    public static void startScheduleNow(Long instenceID) {
        try {
            PersistenceDBUtil.getScheduler().preponeTask(instenceID);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public static void deleteSchedule(JSONArray scheduleIDs) {
        for (int i = 0; i < scheduleIDs.length(); ++i) {
            try {
                Long schedule = scheduleIDs.getLong(i);
                DataObject dobj = PersistenceUtil.getSchedule((Long)schedule);
                Criteria criteria = new Criteria(Column.getColumn((String)"TaskEngine_Task", (String)"TASK_NAME"), dobj.getFirstValue("Schedule", "SCHEDULE_NAME"), 0);
                PersistenceDBUtil.getScheduler().removeSchedule(schedule.longValue());
                DBUtil.deleteExistingRows("TaskEngine_Task", criteria, new boolean[0]);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void enableDisableSchedule(JSONArray scheduleIds, Boolean status) throws BaseStatusCode {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"Task_Input", (String)"SCHEDULE_ID"), (Object)JSONUtil.toLongArray(scheduleIds), 8);
            DataObject dObj = PersistenceDBUtil.getPersistence().get("Task_Input", criteria);
            Iterator iterator = dObj.getRows("Task_Input");
            Scheduler dbScheduler = PersistenceDBUtil.getScheduler();
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                dbScheduler.setTaskInputAdminStatus(((Long)row.get("INSTANCE_ID")).longValue(), status != false ? 3 : 4);
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(7938);
        }
    }

    public static void enableDisableELASchedules(JSONArray exportIDs, Boolean isEnable) throws BaseStatusCode {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"ELATableExportSchedules", (String)"EXPORT_ID"), (Object)JSONUtil.toLongArray(exportIDs), 8);
            DataObject dobj = PersistenceDBUtil.getPersistence().get("ELATableExportSchedules", criteria);
            Iterator iter = dobj.getRows("ELATableExportSchedules");
            if (iter.hasNext()) {
                JSONArray scheduleIDs = new JSONArray();
                while (iter.hasNext()) {
                    Row row = (Row)iter.next();
                    scheduleIDs.put(row.get("SCHEDULE_ID"));
                }
                ScheduleUtil.enableDisableSchedule(scheduleIDs, isEnable);
            }
        }
        catch (DataAccessException dae) {
            dae.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(7430);
        }
        catch (JSONException je) {
            je.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(7938);
        }
    }

    public static DataObject getNewScheduleDO(JSONObject request, Long userID, Locale locale) throws BaseStatusCode {
        try {
            if (ScheduleUtil.isScheduleExists(request.getString("SCHEDULE_DISPLAY_NAME"))) {
                throw BaseStatusCode.getBaseStatusCode(7432);
            }
            if (!request.has("SCHEDULE_NAME")) {
                request.put("SCHEDULE_NAME", (Object)("ELA Schedule : " + request.getString("SCHEDULE_DISPLAY_NAME")));
            }
            JSONObject time = request.getJSONObject("TIME");
            ELABaseScheduleImpl schedule = null;
            Integer frequency = request.getInt("FREQUENCY");
            Frequency scheduleFrequency = Frequency.getFrequency(frequency);
            if (scheduleFrequency == null) {
                throw BaseStatusCode.getBaseStatusCode(7428);
            }
            schedule = scheduleFrequency.isPeriodic() ? ScheduleUtil.getPeriodicSchedule(frequency, request) : ScheduleUtil.getCalendarSchedule(frequency, request);
            DataObject dobj = schedule.getDataObject();
            Row row = new Row("ELATableExportSchedules");
            DataAccess.generateValues((Row)row);
            row.set("SCHEDULE_ID", schedule.getScheduleId());
            row.set("SCHEDULE_DISPLAY_NAME", (Object)request.getString("SCHEDULE_DISPLAY_NAME"));
            row.set("AUTHOR", (Object)userID);
            row.set("EMAIL_ADDRESS", (Object)request.optString("EMAIL_ADDRESS", null));
            if (request.has("EMAIL_SUBJECT")) {
                row.set("EMAIL_SUBJECT", (Object)request.getString("EMAIL_SUBJECT"));
            } else {
                row.set("EMAIL_SUBJECT", (Object)ProductBundle.getInstance().getString(locale, "ela.schedule.defaultMailSubject"));
            }
            row.set("EXPORT_FREQUENCY", (Object)frequency);
            row.set("EXPORT_TIME_TYPE", (Object)time.optInt("TYPE", 0));
            row.set("HOURS", (Object)time.optInt("HOURS", -1));
            row.set("MINUTES", (Object)time.optInt("MINUTES", -1));
            dobj.addRow(row);
            return dobj;
        }
        catch (DataAccessException | JSONException exp) {
            exp.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(7937);
        }
    }

    public static DataObject getUpdatedScheduleDO(JSONObject request) throws BaseStatusCode {
        try {
            SelectQuery selectQuery = ScheduleUtil.getScheduleQuery(request.getLong("EXPORT_ID"));
            return ScheduleUtil.getUpdatedScheduleDO(selectQuery, request);
        }
        catch (JSONException exp) {
            exp.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
    }

    public static DataObject getUpdatedScheduleDO(SelectQuery selectQuery, JSONObject request) throws BaseStatusCode {
        try {
            JSONObject time = request.getJSONObject("TIME");
            Integer frequency = request.getInt("FREQUENCY");
            selectQuery.addSelectColumn(Column.getColumn((String)"Periodic", (String)"TIME_PERIOD"));
            selectQuery.addSelectColumn(Column.getColumn((String)"Task_Input", (String)"SCHEDULE_TIME"));
            DataObject dobj = PersistenceDBUtil.getPersistence().get(selectQuery);
            Row row = dobj.getRow("ELATableExportSchedules");
            if (Frequency.getFrequency(frequency).isPeriodic() && Frequency.getFrequency((Integer)row.get("EXPORT_FREQUENCY")).isPeriodic()) {
                PeriodicScheduleImpl periodicSchedule = ScheduleUtil.getPeriodicSchedule(frequency, request);
                Row periodicRow = dobj.getRow("Periodic");
                periodicRow.set("TIME_PERIOD", (Object)periodicSchedule.getTimePeriod());
                periodicRow.set("UNIT_OF_TIME", (Object)periodicSchedule.getUnitsOfTime().getCondnString());
                periodicRow.set("START_DATE", periodicSchedule.getStartDate() != null ? ELABaseScheduleImpl.DATEFORMAT.format(periodicSchedule.getStartDate()) : null);
                periodicRow.set("END_DATE", periodicSchedule.getEndDate() != null ? ELABaseScheduleImpl.DATEFORMAT.format(periodicSchedule.getEndDate()) : null);
                periodicRow.set("EXECUTE_IMMEDIATELY", (Object)periodicSchedule.isExecuteImediately());
                Row taskInput = dobj.getRow("Task_Input");
                taskInput.set("SCHEDULE_TIME", (Object)ELABaseScheduleImpl.DATEFORMAT.format(periodicSchedule.getInitialScheduleTime()));
                dobj.updateRow(periodicRow);
                dobj.updateRow(taskInput);
            } else if (!Frequency.getFrequency(frequency).isPeriodic() && !Frequency.getFrequency((Integer)row.get("EXPORT_FREQUENCY")).isPeriodic()) {
                Row calendarRow = dobj.getRow("Calendar");
                CalendarScheduleImpl calendarSchedule = ScheduleUtil.getCalendarSchedule(frequency, request);
                Row taskInput = dobj.getRow("Task_Input");
                taskInput.set("SCHEDULE_TIME", (Object)ELABaseScheduleImpl.DATEFORMAT.format(calendarSchedule.getInitialScheduleTime()));
                Row newCalendarRow = calendarSchedule.getConfigRow();
                newCalendarRow.set("SCHEDULE_ID", calendarRow.get("SCHEDULE_ID"));
                dobj.updateRow(newCalendarRow);
                dobj.updateRow(taskInput);
            } else if (!Frequency.getFrequency(frequency).isPeriodic()) {
                Row periodicRow = dobj.getRow("Periodic");
                CalendarScheduleImpl calendarSchedule = ScheduleUtil.getCalendarSchedule(frequency, request);
                Row taskInput = dobj.getRow("Task_Input");
                taskInput.set("SCHEDULE_TIME", (Object)ELABaseScheduleImpl.DATEFORMAT.format(calendarSchedule.getInitialScheduleTime()));
                Row calendarRow = calendarSchedule.getConfigRow();
                calendarRow.set("SCHEDULE_ID", periodicRow.get("SCHEDULE_ID"));
                dobj.deleteRow(periodicRow);
                dobj.addRow(calendarRow);
                dobj.updateRow(taskInput);
            } else {
                Row calendarRow = dobj.getRow("Calendar");
                Row periodicRow = ScheduleUtil.getPeriodicSchedule(frequency, request).getConfigRow();
                periodicRow.set("SCHEDULE_ID", calendarRow.get("SCHEDULE_ID"));
                dobj.deleteRow(calendarRow);
                dobj.addRow(periodicRow);
            }
            row.set("EMAIL_ADDRESS", (Object)request.optString("EMAIL_ADDRESS", null));
            if (request.has("EMAIL_SUBJECT")) {
                row.set("EMAIL_SUBJECT", (Object)request.getString("EMAIL_SUBJECT"));
            }
            row.set("EXPORT_FREQUENCY", (Object)frequency);
            row.set("EXPORT_TIME_TYPE", (Object)time.optInt("TYPE", 0));
            row.set("HOURS", (Object)time.optInt("HOURS", -1));
            row.set("MINUTES", (Object)time.optInt("MINUTES", -1));
            dobj.updateRow(row);
            return dobj;
        }
        catch (Exception exp) {
            exp.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(7938);
        }
    }

    public static JSONObject getScheduleInfo(DataObject dobj) throws BaseStatusCode {
        JSONObject schedule = new JSONObject();
        try {
            Row row = dobj.getRow("ELATableExportSchedules");
            schedule.put("SCHEDULE_ID", row.get("SCHEDULE_ID"));
            schedule.put("SCHEDULE_DISPLAY_NAME", row.get("SCHEDULE_DISPLAY_NAME"));
            schedule.put("FREQUENCY", row.get("EXPORT_FREQUENCY"));
            schedule.put("EXPORT_TIME_TYPE", row.get("EXPORT_TIME_TYPE"));
            schedule.put("HOURS", row.get("HOURS"));
            schedule.put("MINUTES", row.get("MINUTES"));
            schedule.put("EMAIL_ADDRESS", row.get("EMAIL_ADDRESS"));
            schedule.put("EMAIL_SUBJECT", row.get("EMAIL_SUBJECT"));
            row = dobj.getRow("Periodic");
            if (row != null) {
                schedule.put("SCHEDULE_AT", row.get("START_DATE"));
                schedule.put("EVERY_MINUTES", row.get("TIME_PERIOD"));
            }
            if ((row = dobj.getRow("Calendar")) != null) {
                schedule.put("DAY_OF_WEEK", row.get("DAY_OF_WEEK"));
                boolean useInReverse = (Boolean)row.get("USE_DATE_IN_REVERSE");
                if (useInReverse) {
                    schedule.put("DATE_OF_MONTH", 31 - (Integer)row.get("DATE_OF_MONTH"));
                } else {
                    schedule.put("DATE_OF_MONTH", row.get("DATE_OF_MONTH"));
                }
            }
            if ((row = dobj.getRow("Task_Input")) != null) {
                schedule.put("SCHEDULE_TIME", row.get("SCHEDULE_TIME"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(7430);
        }
        return schedule;
    }

    public static JSONObject getScheduleInfo(Long exportID) throws BaseStatusCode {
        try {
            SelectQuery selectQuery = ScheduleUtil.getScheduleQuery(exportID);
            DataObject dobj = PersistenceDBUtil.getPersistence().get(selectQuery);
            return ScheduleUtil.getScheduleInfo(dobj);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(7430);
        }
    }

    private static PeriodicScheduleImpl getPeriodicSchedule(Integer frequency, JSONObject request) throws JSONException, BaseStatusCode {
        JSONObject time = request.getJSONObject("TIME");
        PeriodicScheduleImpl periodicSchedule = new PeriodicScheduleImpl(request.optString("SCHEDULE_NAME"), ScheduleUtil.getScheduleClass(request.getString("SCHEDULE_CLASS")));
        if (Frequency.getFrequency(frequency) == Frequency.ONCE) {
            Date date = new Date(time.getLong("SCHEDULE_AT"));
            periodicSchedule.setTimePeriod(100L);
            periodicSchedule.setUnitsOfTime(ELABaseScheduleImpl.UnitofTime.SECONDS);
            periodicSchedule.setInitialScheduleTime(date);
            periodicSchedule.setStartDate(date);
            periodicSchedule.setEndDate(date);
        } else {
            DateTime date = new DateTime((Object)new Date());
            if (Frequency.getFrequency(frequency) == Frequency.EVERY) {
                periodicSchedule.setTimePeriod(time.getLong("EVERY_MINUTES"));
                periodicSchedule.setUnitsOfTime(ELABaseScheduleImpl.UnitofTime.MINUTES);
            } else {
                if (Frequency.getFrequency(frequency) == Frequency.HOURLY) {
                    periodicSchedule.setTimePeriod(1L);
                } else {
                    periodicSchedule.setTimePeriod(24L);
                    date = date.withHourOfDay(time.getInt("HOURS"));
                }
                date = date.withMinuteOfHour(time.getInt("MINUTES"));
                date = date.withSecondOfMinute(0).withMillisOfSecond(0);
                periodicSchedule.setUnitsOfTime(ELABaseScheduleImpl.UnitofTime.HOURS);
            }
            periodicSchedule.setInitialScheduleTime(date.toDate());
            periodicSchedule.setStartDate(date.toDate());
        }
        periodicSchedule.setSkipMissedSchedule(true);
        return periodicSchedule;
    }

    private static CalendarScheduleImpl getCalendarSchedule(Integer frequency, JSONObject request) throws JSONException, BaseStatusCode {
        JSONObject time = request.getJSONObject("TIME");
        CalendarScheduleImpl calendarSchedule = new CalendarScheduleImpl(request.optString("SCHEDULE_NAME"), ScheduleUtil.getScheduleClass(request.getString("SCHEDULE_CLASS")));
        if (Frequency.getFrequency(frequency) == Frequency.WEEKLY) {
            calendarSchedule.setRepeatFrequency(CalendarScheduleImpl.RepeatFrequency.WEEKLY);
            calendarSchedule.setDayOfWeek(time.getInt("DAY_OF_WEEK"));
        } else {
            calendarSchedule.setRepeatFrequency(CalendarScheduleImpl.RepeatFrequency.MONTHLY);
            calendarSchedule.setDateOfMonth(time.getInt("DATE_OF_MONTH"));
        }
        Long secondsOfDay = (long)time.getInt("HOURS") * 3600L + (long)time.getInt("MINUTES") * 60L;
        calendarSchedule.setTimeOfDay(secondsOfDay);
        calendarSchedule.setUnitsOfTime(ELABaseScheduleImpl.UnitofTime.SECONDS);
        calendarSchedule.setSkipMissedSchedule(true);
        return calendarSchedule;
    }

    public static SelectQuery getScheduleQuery(Long exportID) {
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"ELATableExportSchedules"));
        selectQuery.addJoin(new Join(Table.getTable((String)"ELATableExportSchedules"), Table.getTable((String)"Schedule"), new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 2));
        selectQuery.addJoin(new Join(Table.getTable((String)"Schedule"), Table.getTable((String)"Calendar"), new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 1));
        selectQuery.addJoin(new Join(Table.getTable((String)"Schedule"), Table.getTable((String)"Periodic"), new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 1));
        selectQuery.addJoin(new Join(Table.getTable((String)"Schedule"), Table.getTable((String)"Task_Input"), new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 1));
        selectQuery.addSelectColumn(Column.getColumn((String)"ELATableExportSchedules", (String)"EXPORT_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ELATableExportSchedules", (String)"SCHEDULE_ID", (String)"EXPORT_SCHEDULE_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ELATableExportSchedules", (String)"SCHEDULE_DISPLAY_NAME"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ELATableExportSchedules", (String)"EXPORT_FREQUENCY"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ELATableExportSchedules", (String)"EXPORT_TIME_TYPE"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ELATableExportSchedules", (String)"AUTHOR"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ELATableExportSchedules", (String)"HOURS"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ELATableExportSchedules", (String)"MINUTES"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ELATableExportSchedules", (String)"EMAIL_ADDRESS"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ELATableExportSchedules", (String)"EMAIL_SUBJECT"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Schedule", (String)"SCHEDULE_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Schedule", (String)"SCHEDULE_NAME"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Calendar", (String)"SCHEDULE_ID", (String)"CAL_SCH_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Calendar", (String)"DAY_OF_WEEK"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Calendar", (String)"DATE_OF_MONTH"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Calendar", (String)"USE_DATE_IN_REVERSE"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Periodic", (String)"SCHEDULE_ID", (String)"PER_SCH_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Periodic", (String)"START_DATE"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Periodic", (String)"TIME_PERIOD"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Task_Input", (String)"INSTANCE_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Task_Input", (String)"SCHEDULE_TIME"));
        selectQuery.setCriteria(new Criteria(Column.getColumn((String)"ELATableExportSchedules", (String)"EXPORT_ID"), (Object)exportID, 0));
        return selectQuery;
    }

    private static boolean isScheduleExists(String name) {
        Criteria criteria = new Criteria(Column.getColumn((String)"ELATableExportSchedules", (String)"SCHEDULE_DISPLAY_NAME"), (Object)name, 0);
        return DBUtil.getCountInt("ELATableExportSchedules", criteria) > 0;
    }

    private static String getScheduleClass(String className) throws BaseStatusCode {
        try {
            Class.forName(className);
            return className;
        }
        catch (ClassNotFoundException exp) {
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
    }

    public static boolean updateTaskInputTime(DataObject scheduleData) {
        try {
            Row scheduleRow = scheduleData.getRow("ELATableExportSchedules");
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"Task_Input"));
            selectQuery.addSelectColumn(Column.getColumn((String)"Task_Input", (String)"INSTANCE_ID"));
            selectQuery.addSelectColumn(Column.getColumn((String)"Task_Input", (String)"SCHEDULE_ID"));
            selectQuery.addSelectColumn(Column.getColumn((String)"Task_Input", (String)"SCHEDULE_TIME"));
            Criteria criteria = new Criteria(Column.getColumn((String)"Task_Input", (String)"SCHEDULE_ID"), scheduleRow.get("SCHEDULE_ID"), 0);
            selectQuery.setCriteria(criteria);
            DataObject dataObject = PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
            Row taskInput = dataObject.getRow("Task_Input", criteria);
            Timestamp updatedVal = (Timestamp)scheduleData.getFirstValue("Task_Input", "SCHEDULE_TIME");
            if (taskInput.get("SCHEDULE_TIME") == null || updatedVal.compareTo((Timestamp)taskInput.get("SCHEDULE_TIME")) != 0) {
                taskInput.set("SCHEDULE_TIME", (Object)updatedVal);
                dataObject.updateRow(taskInput);
                PersistenceDBUtil.getPersistence().update(dataObject);
                return true;
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return false;
    }

    public static enum Frequency {
        ONCE(0),
        HOURLY(1),
        DAILY(2),
        WEEKLY(3),
        MONTHLY(4),
        EVERY(5);

        private int value;

        private Frequency(int value) {
            this.value = value;
        }

        public static Frequency getFrequency(int freqValue) {
            switch (freqValue) {
                case 0: {
                    return ONCE;
                }
                case 1: {
                    return HOURLY;
                }
                case 2: {
                    return DAILY;
                }
                case 3: {
                    return WEEKLY;
                }
                case 4: {
                    return MONTHLY;
                }
                case 5: {
                    return EVERY;
                }
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }

        public boolean isPeriodic() {
            return this.value < 3 || this.value == 5;
        }
    }
}

