/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.schedule.configuration;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.adventnet.taskengine.TaskExecutionException;
import com.manageengine.ela.server.common.device.monitors.WindowsDeviceIPMonitor;
import java.util.Iterator;
import java.util.logging.Logger;

public class DeviceIPAddressUpdater
implements Task {
    private static final Logger LOGGER = Logger.getLogger(DeviceIPAddressUpdater.class.getName());

    public void executeTask(TaskContext arg0) throws TaskExecutionException {
        LOGGER.info("Daily Ip update Called at " + System.currentTimeMillis());
        this.performChangesOnDevices();
        LOGGER.info("Daily Ip update Completed at " + System.currentTimeMillis());
    }

    private void performChangesOnDevices() {
        Table table = Table.getTable((String)"Hosts");
        SelectQueryImpl query = new SelectQueryImpl(table);
        query.addSelectColumn(Column.getColumn((String)table.getTableName(), (String)"HOST_ID"));
        try {
            WindowsDeviceIPMonitor instance = WindowsDeviceIPMonitor.getInstance();
            DataObject dobj = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
            Iterator itr = dobj.getRows(table.getTableName());
            while (itr.hasNext()) {
                Row row = (Row)itr.next();
                instance.add((Long)row.get("HOST_ID"));
            }
            LOGGER.info("Total Devices " + dobj.size("Hosts"));
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public void stopTask() throws TaskExecutionException {
    }
}

