/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.schedule.criteria;

import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.schedule.criteria.ScheduleCriteriaEntry;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ScheduleCriteria {
    public static final Integer[] SUPPORTED_OPERATIONS = new Integer[]{ScheduleCriteriaOperation.EQUAL.getValue(), ScheduleCriteriaOperation.NOT_EQUAL.getValue()};
    public static final int SEARCH_TYPE_SCHEDULED_EXPORT = 3;
    private static final Logger LOGGER = Logger.getLogger(ScheduleCriteria.class.getName());

    public static JSONObject prepareSearchRequest(JSONObject request, List<Map.Entry<Integer, List<ScheduleCriteriaEntry>>> criteriaData) throws BaseStatusCode {
        try {
            JSONObject searchRequest = new JSONObject();
            searchRequest.put("TYPE", 3);
            JSONObject entry = new JSONObject();
            JSONArray array = new JSONArray();
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<Integer, List<ScheduleCriteriaEntry>> criteriaDatum : criteriaData) {
                ScheduleCriteriaLink link = ScheduleCriteriaLink.get(criteriaDatum.getKey());
                List<ScheduleCriteriaEntry> crit = criteriaDatum.getValue();
                String criteriaLink = ScheduleCriteriaLink.getCriteriaString(link);
                if (criteriaLink != null) {
                    builder.append(criteriaLink);
                }
                builder.append(String.format("(%s)", ScheduleCriteria.getQueryForCriteria(crit)));
            }
            entry.put("QUERY", (Object)builder.toString());
            array.put((Object)entry);
            searchRequest.put("SEARCH_DATA", (Object)array);
            request.put("SEARCH_DATA", (Object)searchRequest);
            request.put("REP_UUID", (Object)UUID.randomUUID().toString());
            JSONObject extraInfo = new JSONObject();
            extraInfo.put("UUID", (Object)UUID.randomUUID().toString());
            request.put("EXTRA_PARAMS", (Object)extraInfo);
            LOGGER.log(Level.INFO, "Query loaded for schedule {0}", builder.toString());
        }
        catch (JSONException exp) {
            LOGGER.log(Level.WARNING, "Error occurred during search request preparation {0}", exp.getMessage());
        }
        return request;
    }

    private static String getQueryForCriteria(List<ScheduleCriteriaEntry> criteriaList) {
        StringBuilder builder = new StringBuilder();
        block4: for (ScheduleCriteriaEntry criteria : criteriaList) {
            String criteriaLink = ScheduleCriteriaLink.getCriteriaString(criteria.getLink());
            if (criteriaLink != null) {
                builder.append(criteriaLink);
            }
            StringBuilder element = new StringBuilder();
            element.append(criteria.getField());
            switch (criteria.getOperation()) {
                case EQUAL: {
                    element.append(":");
                    break;
                }
                case NOT_EQUAL: {
                    element.insert(0, '-');
                    element.append(":");
                    break;
                }
                default: {
                    LOGGER.log(Level.INFO, "Invalid criteria found for search request", criteria);
                    continue block4;
                }
            }
            element.append('\"').append(criteria.getFieldValue()).append('\"');
            builder.append(element.toString());
        }
        return builder.toString();
    }

    public static enum ScheduleCriteriaLink {
        EMPTY(-1),
        AND(0),
        OR(1);

        private int value;

        private ScheduleCriteriaLink(int value) {
            this.value = value;
        }

        public static ScheduleCriteriaLink get(int value) throws BaseStatusCode {
            switch (value) {
                case -1: {
                    return EMPTY;
                }
                case 0: {
                    return AND;
                }
                case 1: {
                    return OR;
                }
            }
            throw BaseStatusCode.getBaseStatusCode(7428);
        }

        public static String getCriteriaString(ScheduleCriteriaLink link) {
            switch (link) {
                case OR: {
                    return " OR ";
                }
                case AND: {
                    return " AND ";
                }
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum ScheduleCriteriaOperation {
        EQUAL(0),
        NOT_EQUAL(1);

        private int value;

        private ScheduleCriteriaOperation(int value) {
            this.value = value;
        }

        public static ScheduleCriteriaOperation get(int value) throws BaseStatusCode {
            switch (value) {
                case 0: {
                    return EQUAL;
                }
                case 1: {
                    return NOT_EQUAL;
                }
            }
            throw BaseStatusCode.getBaseStatusCode(7428);
        }

        public int getValue() {
            return this.value;
        }
    }
}

