/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.schedule.export;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.common.schedule.export.TableBaseExportSchedule;
import com.manageengine.ela.server.common.util.ServerUtil;
import org.json.JSONException;
import org.json.JSONObject;

public class CorrelationExportSchedule
extends TableBaseExportSchedule {
    @Override
    public String getReportName(Long exportID) {
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"CorrScheduledReports"));
            query.addJoin(new Join("CorrScheduledReports", "CorrRuleInfo", new String[]{"RULE_ID"}, new String[]{"RULE_ID"}, 2));
            query.addSelectColumn(Column.getColumn((String)"CorrScheduledReports", (String)"EXPORT_ID"));
            query.addSelectColumn(Column.getColumn((String)"CorrRuleInfo", (String)"RULE_ID"));
            query.addSelectColumn(Column.getColumn((String)"CorrRuleInfo", (String)"RULE_DISPLAY_NAME"));
            query.addSelectColumn(Column.getColumn((String)"CorrRuleInfo", (String)"IS_SYSTEMGENERATED"));
            query.setCriteria(new Criteria(Column.getColumn((String)"CorrScheduledReports", (String)"EXPORT_ID"), (Object)exportID, 0));
            Row row = PersistenceDBUtil.getPersistence().get((SelectQuery)query).getRow("CorrRuleInfo");
            String displayName = (String)row.get("RULE_DISPLAY_NAME");
            if (((Boolean)row.get("IS_SYSTEMGENERATED")).booleanValue()) {
                displayName = ProductBundle.getInstance().getString(displayName);
            }
            return displayName;
        }
        catch (DataAccessException dae) {
            dae.printStackTrace();
            return "EventLog Analyzer Correlation Report";
        }
    }

    @Override
    protected void customizeRequest(Long exportID, JSONObject request) throws JSONException {
        request.put("REPORT_CONTENT_LIST", (Object)ProductBundle.getInstance().getString(ServerUtil.getServerLocale(), "ela.tableexportparams.reportcontentslist.correlation"));
    }
}

