/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.schedule.export;

import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.adventnet.taskengine.TaskExecutionException;
import com.manageengine.ela.server.common.export.TableExportParams;
import com.manageengine.ela.server.common.io.file.FileHandler;
import java.io.File;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class ExportedReportRemoveSchedule
implements Task {
    public void executeTask(TaskContext taskContext) throws TaskExecutionException {
        try {
            File file = new File(TableExportParams.EXPORT_FOLDER_PATH);
            DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy_MM_dd");
            Long timeToRemove = LocalDate.now().minusDays(3L).toEpochDay();
            if (file.exists()) {
                File[] files;
                for (File fileToCheck : files = file.listFiles()) {
                    if (!fileToCheck.isDirectory()) continue;
                    String fileName = fileToCheck.getName();
                    try {
                        long fileepoch = LocalDate.parse(fileName, format).toEpochDay();
                        if (fileepoch > timeToRemove) continue;
                        FileHandler.deleteFiles(fileToCheck);
                    }
                    catch (Exception exp) {
                        exp.printStackTrace();
                    }
                }
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public void stopTask() throws TaskExecutionException {
    }
}

