/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.schedule.export;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.adventnet.taskengine.TaskExecutionException;
import com.manageengine.ela.server.common.export.utils.TableExportUtil;
import com.manageengine.ela.server.common.export.utils.TableScheduleUtil;
import com.manageengine.ela.server.common.schedule.criteria.ScheduleCriteria;
import com.manageengine.ela.server.common.schedule.criteria.ScheduleCriteriaEntry;
import com.manageengine.ela.server.common.schedule.export.TableExportInterface;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.joda.time.DateTime;
import org.json.JSONException;
import org.json.JSONObject;

public class TableBaseExportSchedule
implements Task,
TableExportInterface {
    private static final Logger LOGGER = Logger.getLogger(TableBaseExportSchedule.class.getName());

    public void executeTask(TaskContext taskContext) throws TaskExecutionException {
        try {
            this.preExecution();
            List<String> tableList = Arrays.asList("ELATableExportSchedules", "ELAExportScheduleConfigurations");
            Criteria criteria = new Criteria(Column.getColumn((String)"ELATableExportSchedules", (String)"SCHEDULE_ID"), (Object)taskContext.getScheduleID(), 0);
            DataObject dobj = PersistenceDBUtil.getPersistence().get(tableList, criteria);
            Row row = dobj.getRow("ELATableExportSchedules");
            Row configRow = dobj.getRow("ELAExportScheduleConfigurations");
            if (row != null) {
                DateTime dt2;
                String reqJSON = (String)configRow.get("ADDITIONAL_PARAMS_ROW");
                JSONObject request = reqJSON != null ? new JSONObject(reqJSON) : new JSONObject();
                JSONObject customStructure = new JSONObject();
                customStructure.put("UNIQUE_ID", configRow.get("REQ_UNIQUE_ID"));
                String customStrReq = (String)configRow.get("ADDITIONAL_PARAMS_STR");
                customStructure.put("REQUEST_PARAMS", (Object)(customStrReq != null ? new JSONObject(customStrReq) : new JSONObject()));
                request.put("CUSTOM_STRUCTURE", (Object)customStructure);
                request.put("TABLE_ID", configRow.get("TABLE_ID"));
                request.put("SCHEDULE_ID", row.get("SCHEDULE_ID"));
                request.put("EXPORT_ID", row.get("EXPORT_ID"));
                request.put("EMAIL_ADDRESS", row.get("EMAIL_ADDRESS"));
                request.put("EMAIL_SUBJECT", row.get("EMAIL_SUBJECT"));
                DateTime dt = new DateTime((Object)taskContext.getActualScheduleTime()).withSecondOfMinute(0).withMillisOfSecond(0);
                switch ((Integer)row.get("EXPORT_TIME_TYPE")) {
                    case 0: {
                        dt = dt.withMinuteOfHour(0);
                    }
                    case 1: {
                        dt2 = dt.minusHours(1);
                        break;
                    }
                    case 2: {
                        dt = dt.withHourOfDay(0).withMinuteOfHour(0);
                    }
                    case 3: {
                        dt2 = dt.minusDays(1);
                        break;
                    }
                    case 4: {
                        dt = dt.withDayOfWeek(1).withHourOfDay(0).withMinuteOfHour(0);
                    }
                    case 5: {
                        dt2 = dt.minusWeeks(1);
                        break;
                    }
                    case 6: {
                        dt = dt.withDayOfMonth(1).withHourOfDay(0).withMinuteOfHour(0);
                    }
                    case 7: {
                        dt2 = dt.minusMonths(1);
                        break;
                    }
                    default: {
                        dt2 = dt;
                    }
                }
                request.put("EXPORT_START_DATE", dt2.getMillis());
                request.put("EXPORT_END_DATE", dt.getMillis());
                request.put("IS_SCHEDULED", true);
                request.put("JSREPORTUSERID", row.get("AUTHOR"));
                this.customizeRequest((Long)row.get("EXPORT_ID"), request);
                switch ((Integer)configRow.get("FORMAT")) {
                    case 1: {
                        TableExportUtil.exportToCSV(this.getReportName((Long)row.get("EXPORT_ID")), request);
                        break;
                    }
                    default: {
                        TableExportUtil.exportToPDF(this.getReportName((Long)row.get("EXPORT_ID")), request);
                    }
                }
                this.postExecution(Boolean.TRUE);
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
            this.postExecution(Boolean.FALSE);
        }
    }

    public void stopTask() throws TaskExecutionException {
    }

    @Override
    public void preExecution() {
    }

    @Override
    public String getReportName(Long exportID) {
        return "EventLog Analyzer Report";
    }

    @Override
    public void postExecution(Boolean status) {
    }

    protected void customizeRequest(Long exportID, JSONObject request) throws JSONException {
        ArrayList<Map.Entry<Integer, List<ScheduleCriteriaEntry>>> criteriaList = new ArrayList<Map.Entry<Integer, List<ScheduleCriteriaEntry>>>();
        try {
            DataObject dataObject = TableScheduleUtil.getScheduleCriteriaDO(exportID);
            Iterator iterator = dataObject.getRows("ScheduleCriteriaGroups");
            while (iterator.hasNext()) {
                Row group = (Row)iterator.next();
                Long groupID = (Long)group.get("GROUP_ID");
                Integer groupLinkType = (Integer)group.get("LINK_TO_PREV");
                Criteria criteria = new Criteria(Column.getColumn((String)"ScheduleCriteria", (String)"GROUP_ID"), (Object)groupID, 0);
                Iterator criteriaIterator = dataObject.getRows("ScheduleCriteria", criteria);
                ArrayList<ScheduleCriteriaEntry> groupContents = new ArrayList<ScheduleCriteriaEntry>();
                while (criteriaIterator.hasNext()) {
                    Row schCriteria = (Row)criteriaIterator.next();
                    Long fieldID = (Long)schCriteria.get("FIELD_ID");
                    Criteria fieldSelectionCriteria = new Criteria(Column.getColumn((String)"NoSqlIndexFields", (String)"FIELD_ID"), (Object)fieldID, 0);
                    String fieldIndexName = (String)dataObject.getValue("NoSqlIndexFields", "FIELD_INDEX_NAME", fieldSelectionCriteria);
                    String fieldVal = (String)schCriteria.get("FIELD_VAL");
                    int operation = (Integer)schCriteria.get("OPERATION");
                    int linkType = (Integer)schCriteria.get("LINK_TO_PREV");
                    int order = (Integer)schCriteria.get("CRITERIA_ORDER");
                    ScheduleCriteriaEntry scheduleCriteria = new ScheduleCriteriaEntry(fieldIndexName, fieldVal, ScheduleCriteria.ScheduleCriteriaOperation.get(operation), ScheduleCriteria.ScheduleCriteriaLink.get(linkType), (Integer)order);
                    groupContents.add(scheduleCriteria);
                }
                if (groupContents.isEmpty()) continue;
                criteriaList.add(new AbstractMap.SimpleEntry(groupLinkType, groupContents));
            }
            if (!criteriaList.isEmpty()) {
                request = ScheduleCriteria.prepareSearchRequest(request, criteriaList);
                LOGGER.log(Level.FINE, "Criteria for export {0} = {1}", new Object[]{exportID, request});
            }
        }
        catch (Exception exp) {
            LOGGER.log(Level.WARNING, "Error occurred during updating schedule report request for {0} - {1}", new Object[]{exportID, exp.getMessage()});
        }
    }
}

