/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.schedule.monitor;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.winaccess.AgentConstants;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.adventnet.taskengine.TaskExecutionException;
import java.util.Date;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RLCollectorStatusUpdater
implements Task {
    private static final Logger LOGGER = Logger.getLogger(RLCollectorStatusUpdater.class.getName());
    private static final Long THERSHOLD_TIME = 3600000L;

    public void executeTask(TaskContext input) throws TaskExecutionException {
        LOGGER.log(Level.INFO, "Scheduler Call to update agent status");
        this.updateRemoteDeviceStatus();
    }

    public void stopTask() throws TaskExecutionException {
    }

    public void updateRemoteDeviceStatus() {
        try {
            SelectQueryImpl select = new SelectQueryImpl(Table.getTable((String)"SyslogServers"));
            select.addSelectColumn(Column.getColumn((String)"SyslogServers", (String)"SLID"));
            select.addSelectColumn(Column.getColumn((String)"SyslogServers", (String)"STATUS"));
            select.addSelectColumn(Column.getColumn((String)"SyslogServers", (String)"STATUS_UPDATE_TIME"));
            select.setCriteria(new Criteria(Column.getColumn((String)"SyslogServers", (String)"STATUS"), (Object)AgentConstants.AGENT_RUNNING, 0).and(new Criteria(Column.getColumn((String)"SyslogServers", (String)"PORTS"), (Object)"-", 0)));
            DataObject dObj = PersistenceDBUtil.getPersistence().get((SelectQuery)select);
            Iterator iter = dObj.getRows("SyslogServers");
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                Long statusUpdateTime = (Long)row.get("STATUS_UPDATE_TIME");
                if (statusUpdateTime != null && statusUpdateTime >= System.currentTimeMillis() - THERSHOLD_TIME) continue;
                String slid = row.get("SLID").toString();
                row.set("STATUS", (Object)AgentConstants.AGENT_STATUS_UNAVAILABLE.toString());
                row.set("ERROR_DETAILS", (Object)"Agent Status Unavailable");
                row.set("ERROR_CODE", (Object)1002);
                dObj.updateRow(row);
                LOGGER.log(Level.INFO, "status changed to UNAVAILABLE for slid: " + slid + ", statusUpdateTime: " + statusUpdateTime + ", in date: " + new Date(statusUpdateTime));
            }
            PersistenceDBUtil.getPersistence().update(dObj);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while updating syslogservers status: ", e);
        }
    }
}

